import os
import yaml

from si_tests.deployments.utils import extra_context, file_utils, wait_utils, commons, kubectl_utils
from si_tests.deployments.utils.namespace import NAMESPACE


def deploy_metallb(os_manager, timeout):
    context = extra_context.ExtraContext().metallb
    kubectl = kubectl_utils.Kubectl()

    metallb_yaml = file_utils.get_release("3rd-party/30-metallb.yaml")
    metallb_address_pools_yaml = file_utils.get_release("3rd-party/31-metallb-address-pools.yaml")
    metallb_pods = {"controller": "metallb-controller", "speaker": "metallb-speaker"}

    metallb_data = file_utils.get_yaml_content(metallb_yaml)
    metallb_address_pools_data = {}
    if os.path.exists(metallb_address_pools_yaml):
        metallb_pods = {k: f"mcc-{v}" for k, v in metallb_pods.items()}
        with open(metallb_address_pools_yaml, "r") as f:
            metallb_address_pools_data = list(yaml.safe_load_all(f))
            if context and context.get("metallb_address_pools"):
                commons.LOG.info("Update metallb-address-pools.yaml")
                for data in metallb_address_pools_data:
                    if data["kind"] != "IPAddressPool":
                        continue
                    data["spec"]["addresses"] = context.get("metallb_address_pools")
    else:
        if context and context.get("metallb_address_pools"):
            commons.LOG.info("Update metallb.yaml")
            config = metallb_data["spec"]["releases"][0]["values"]["configInline"]
            config["address-pools"][0]["addresses"] = context.get("metallb_address_pools")

    new_yaml = file_utils.get_new_name(metallb_yaml)
    commons.LOG.info("Save new metallb yaml to %s", new_yaml)
    file_utils.save_to_yaml(metallb_data, new_yaml)
    commons.LOG.info("Deploy metallb")
    kubectl.apply(new_yaml)

    wait = wait_utils.Waiter(os_manager, timeout, NAMESPACE.metallb)
    commons.LOG.info("Wait till metallb controller starts")
    wait.deployment(metallb_pods["controller"])

    commons.LOG.info("Wait till metallb speakers start")
    wait.daemonset(metallb_pods["speaker"])

    if os.path.exists(metallb_address_pools_yaml):
        metallb_address_pools_updated_yaml = file_utils.get_new_name(metallb_address_pools_yaml)
        commons.LOG.info("Save new metallb address pools yaml to %s", metallb_address_pools_updated_yaml)
        with open(metallb_address_pools_updated_yaml, "w") as f:
            yaml.dump_all(metallb_address_pools_data, f)

        commons.LOG.info("Apply metallb address pools")
        kubectl.apply(metallb_address_pools_updated_yaml)

    commons.LOG.info("Metallb successfully deployed")
