#    Copyright 2022 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1TFWebUI(base.BaseModel):
    pass


class V1TFWebUIList(base.BaseModelList):
    pass


class TFWebUI(base.K8sNamespacedResource):
    resource_type = 'tfwebui'
    model = V1TFWebUI


class TFWebUIManager(base.K8sBaseManager):
    model = V1TFWebUIList
    resource_class = TFWebUI
    resource_group = 'webui.tf.mirantis.com'
    resource_version = 'v1alpha1'
    resource_plural = 'tfwebuis'


class V2TFWebUI(base.BaseModel):
    pass


class V2TFWebUIList(base.BaseModelList):
    pass


class TFWebUIV2(base.K8sNamespacedResource):
    resource_type = 'tfwebui'
    model = V2TFWebUI


class TFWebUIManagerV2(base.K8sBaseManager):
    model = V2TFWebUIList
    resource_class = TFWebUIV2
    resource_group = 'tf.mirantis.com'
    resource_version = 'v2'
    resource_plural = 'tfwebuis'
