import os
import yaml

from si_tests import settings
from si_tests import logger
import si_tests.utils.templates as template_utils

LOG = logger.logger


def test_add_servicetemplate(kcm_manager, show_step):
    """Create a ServiceTemplate in the specified namespace and check that it is valid

    Scenario:
        1. Read the ServiceTemplate content
        2. Create the specified service template in the specified namespace
        3. Check that desired template is valid and available
    """
    show_step(1)
    servicetemplate_path = settings.CUSTOM_SERVICETEMPLATE_PATH
    # To create a new ServiceTemplate, please use the CUSTOM_SERVICETEMPLATE_PATH to the object yaml
    if servicetemplate_path and os.path.isfile(servicetemplate_path):
        options = {}
        LOG.info(f"Creating ServiceTemplate from file '{servicetemplate_path}' ...")
        template = template_utils.render_template(
            file_path=servicetemplate_path,
            options=options
        )
        body = yaml.load(template, Loader=yaml.SafeLoader)
    else:
        raise Exception(f"CUSTOM_SERVICETEMPLATE_PATH '{settings.CUSTOM_SERVICETEMPLATE_PATH}' not found")

    show_step(2)
    servicetemplate_name = body['metadata']['name']
    servicetemplate_namespace = body['metadata']['namespace']
    ns = kcm_manager.get_or_create_namespace(servicetemplate_namespace)

    servicetemplate = ns.create_servicetemplate(servicetemplate_name, body)

    show_step(3)
    assert servicetemplate.is_valid, f"Template {template.namespace}/{template.name} is not valid"
