# V1Node


## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**available_resources** | **Dict[str, str]** | AvailableResources contains available resources of the node | [optional] 
**gpu_model** | **str** | GpuModel the model of the GPU if node has one | [optional] 
**name** | **str** | Name of the node | [optional] 
**node_group** | **str** | NodeGroup is the name of the node group if node in the group | [optional] 
**pods** | [**List[V1Pod]**](V1Pod.md) | Pods contains the list of pods allocated to the node | [optional] 
**region_name** | **str** | RegionName the name of the region the node belongs to | [optional] 
**status** | **str** | Status of the node, could be \&quot;Allocated\&quot;, \&quot;Maintenance\&quot;, \&quot;Unhealthy\&quot;, \&quot;Free\&quot; | [optional] 
**total_resources** | **Dict[str, str]** | TotalResources contains the total resources for the node group | [optional] 
**used_resources** | **Dict[str, str]** | UsedResources contains used resources of the node | [optional] 

## Example

```python
from si_tests.clients.gcore.box_api.models.v1_node import V1Node

# TODO update the JSON string below
json = "{}"
# create an instance of V1Node from a JSON string
v1_node_instance = V1Node.from_json(json)
# print the JSON string representation of the object
print(V1Node.to_json())

# convert the object into a dict
v1_node_dict = v1_node_instance.to_dict()
# create an instance of V1Node from a dict
v1_node_from_dict = V1Node.from_dict(v1_node_dict)
```
[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


