#!/bin/env python
import os.path
import pprint
import sys
# to be able locally run .py with si_tests
from pathlib import Path

path_root = Path(__file__).parents[2]
sys.path.append(str(path_root))

from si_tests import logger  # noqa: E402
from si_tests import settings  # noqa: E402
from si_tests.utils import utils  # noqa: E402
from si_tests.managers.si_config_manager import SIConfigManager  # noqa: E402

LOG = logger.logger

ppr = pprint.PrettyPrinter(indent=4)

# Minimal custom variables to be expected for run:
# cd kasa_si-tests
# export ENV_CONFIG_NAME='half-virtual-2nic-mosk'
# export SI_CONFIG="si_config.yaml"
# python3 si_tests/utils/render_bm_child_config.py
#
# Exampled format, for extra-correct values pass:
# render_opts = {'somedata': 'somevalue'}
render_opts = dict()
if not os.path.isfile(settings.SI_CONFIG_PATH):
    raise f'File {settings.SI_CONFIG_PATH} not found! Exit'
child_data = utils.render_child_data(SIConfigManager(si_config_path=settings.SI_CONFIG_PATH), render_opts)

LOG.info(f"Rendered child_data from file:\n"
         f"{settings.BM_CHILD_SETTINGS_YAML_PATH}:")
ppr.pprint(child_data)
