from si_tests import logger
from si_tests.lcm.openstack_lcm.policies import Policy
from si_tests.utils.utils import verify


LOG = logger.logger


def test_crud_operations_glance_policy(openstack_client_manager,
                                       policy_user):
    """Test CRUD operations  for glance policy
       https://mirantis.testrail.com/index.php?/cases/view/4963574

       Parameters required for test execution:
         - KUBECONFIG

       Setup environment:
       Create user with role member
    """
    user_name, password = policy_user
    http_exception = "Exception: 403"
    os_service = 'glance'
    os_pod = 'glance-api'
    policy = Policy(os_service, os_pod)

    try:

        LOG.info("Precondition. Create new user, and assignee member role. "
                 "Check on glance api pod that rule is absent")
        get_policy_file_before_update = \
            ['/bin/sh', '-c',
             ' grep -rin "get_images:"'
             ' /etc/glance/policy.d/02-custom.yaml']
        policy.check_policy_absent_before_update(
            get_policy_file_before_update)

        LOG.info("Step 1: Check that policy is absent. "
                 "List image is possible by admin and member users")
        step = 1

        images = openstack_client_manager.image.list([])
        verify(http_exception not in images,
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "List image is possible by admin")
        images = openstack_client_manager.image.list(
            [f"--os-username={user_name}", f"--os-password={password}"])
        verify(http_exception not in images,
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "List image is possible by user")

        LOG.info("Step 2: Add to osdpl new rule")
        step = 2
        policy_not_role = {'get_images': '!'}

        policy.update_policy_osdpl(policy_not_role, step)

        LOG.info("Step 3: Check on glance api pod that policies were added")
        step = 3
        check_policy_file = ['/bin/sh', '-c',
                             ' cat /etc/glance/policy.d/02-custom.yaml']
        policy.wait_policy_updated_on_pod(check_policy_file, policy_not_role,
                                          step)

        LOG.info("Step 4: Check that policy added and list image "
                 "is not possible by admin and user")
        step = 4
        error_output = openstack_client_manager.image.list(
            [], combined_output=True)
        verify(http_exception in error_output["stderr"],
               f"[Step {step}]: Incorrect result."
               f" Actual result: {error_output['stderr']}, "
               f"expected result: {http_exception}",
               f"[Step {step}]: List image is not possible by admin")

        error_output = openstack_client_manager.image.list(
            [f"--os-username={user_name}", f"--os-password={password}"],
            combined_output=True)
        verify(http_exception in error_output["stderr"],
               f"[Step {step}]: Incorrect result."
               f" Actual result: {error_output['stderr']}, "
               f"expected result: {http_exception}",
               f"[Step {step}]: List image is not possible by user")

        LOG.info("Step 5: Update policies. Check that policy added "
                 "on glance api pod ")
        step = 5
        policy_not_role = {'get_images': 'role:admin'}
        policy.update_policy_osdpl(policy_not_role, step)
        policy.wait_policy_updated_on_pod(check_policy_file,
                                          policy_not_role, step)

        LOG.info("Step 6: Check that list image is possible only for admins")
        step = 6
        images = openstack_client_manager.image.list([])
        verify(http_exception not in images,
               f"[Step {step}]: List image is not possible for admin",
               f"[Step {step}]: List image is possible for admin")

        error_output = openstack_client_manager.image.list(
            [f"--os-username={user_name}", f"--os-password={password}"],
            combined_output=True)
        verify(http_exception in error_output["stderr"],
               f"[Step {step}]: Incorrect result."
               f" Actual result: {error_output['stderr']}, "
               f"expected result: {http_exception}",
               f"[Step {step}]: List image is not possible by user")

    finally:
        LOG.info("Step 7: Delete Policy. Check that policy was deleted and"
                 " result is the same as in first step ")
        step = 7
        policy_not_role = None
        policy.update_policy_osdpl(policy_not_role, step)

        policy.wait_policy_updated_on_pod(check_policy_file, {},
                                          step)

        images = openstack_client_manager.image.list([])
        verify(http_exception not in images,
               f"[Step {step}]: Policy is not successfully deleted",
               f"[Step {step}]: Policy is absent. "
               "List image is possible by admin")

        images = openstack_client_manager.image.list(
            [f"--os-username={user_name}", f"--os-password={password}"])
        verify(http_exception not in images,
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "List image is possible by user")
