#!/usr/bin/env bash

echo 'set_power'

declare -A nodes_pw
nodes_pw=(\
[cz7769]='KIgViw3T6b34' \
[cz8041]='KIgViw3T6b34' \
[cz7790]='KIgViw3T6b34' \
[cz8148]='KIgViw3T6b34' \
[cz8147]='KIgViw3T6b34' \
[cz8021]='KIgViw3T6b34' \
[cz5023]='KIgViw3T6b34' \
[cz5736]='KIgViw3T6b34' \
[cz8125]='KIgViw3T6b34' \
[cz7810]='KIgViw3T6b34' \
[cz7811]='KIgViw3T6b34' \
[cz7813]='OINsIYBweiuwdu'
)

function set_power(){
  local action=${1:-'status'}
  local nset=${2:-'all'}
  declare -A nodes=();
  declare -A nodes_child=();
  declare -A nodes_mgmt=();

  nodes_child=([cz7810]='5.43.226.133' [cz7811]='5.43.225.144' \
               [cz8148]='176.74.221.182' [cz8147]='176.74.221.180' \
	       [cz8021]='5.43.227.61' [cz5023]='176.74.217.146' \
	       [cz5736]='185.8.58.50' [cz8125]='5.43.227.150' \
               [cz7813]='188.124.60.13')

  nodes_mgmt=([cz7769]='5.43.225.99' [cz8041]='5.43.227.84' \
              [cz7790]='176.74.222.193')
  # awesome merge event...
  case "$nset" in
      'mgmt')
        for i in ${!nodes_mgmt[@]}; do
            nodes[$i]="${nodes_mgmt[$i]}"
        done
      ;;
      'child')
        for i in ${!nodes_child[@]}; do
            nodes[$i]="${nodes_child[$i]}"
        done
      ;;
      'all')
        for i in ${!nodes_child[@]}; do
            nodes[$i]="${nodes_child[$i]}"
        done
        for i in ${!nodes_mgmt[@]}; do
            nodes[$i]="${nodes_mgmt[$i]}"
        done
      ;;
  esac

  for i in "${!nodes[@]}"; do
    echo "node: $i"
    set -x
    ipmitool -I lanplus -H ${nodes[$i]} -U engineer -P "${nodes_pw[$i]}" chassis power $action || true
    set +x
  done
 }

