#    Copyright 2022 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1KaaSEquinixMetalCredential(base.BaseModel):
    pass


class V1KaaSEquinixMetalCredentialList(base.BaseModelList):
    pass


class KaaSEquinixMetalCredential(base.K8sNamespacedResource):
    resource_type = 'equinixmetalcredential'
    model = V1KaaSEquinixMetalCredential


class KaaSEquinixMetalCredentialManager(base.K8sBaseManager):
    model = V1KaaSEquinixMetalCredentialList
    resource_class = KaaSEquinixMetalCredential
    resource_group = 'kaas.mirantis.com'
    resource_version = 'v1alpha1'
    resource_plural = 'equinixmetalcredentials'
