import socket
from OpenSSL import SSL
import certifi

from si_tests import logger

LOG = logger.logger


def get_cert_fingetprint(hostname, port=443):
    context = SSL.Context(method=SSL.TLSv1_2_METHOD)
    context.load_verify_locations(cafile=certifi.where())

    conn = SSL.Connection(context, socket=socket.socket(socket.AF_INET, socket.SOCK_STREAM))
    conn.settimeout(5)
    conn.connect((hostname, port))
    conn.setblocking(1)
    conn.do_handshake()
    conn.set_tlsext_host_name(hostname.encode())
    f_print = conn.get_peer_certificate().digest('sha256')
    LOG.info(f"Fingerprint for {hostname}: {f_print}")
    print(f"Fingerprint for {hostname}: {f_print.decode()}")
    conn.close()
    return f_print.decode()
