import pytest

from si_tests import logger
from si_tests import settings
from si_tests.utils import utils

LOG = logger.logger


@pytest.mark.aws
@pytest.mark.usefixtures('log_step_time')
@pytest.mark.usefixtures('log_method_time')
def test_install_kof_mothership_aws(kcm_bootstrap_manager, show_step):
    """Install and configure kof into k0rdent management cluster with aws auto-dns

    Scenario:
        1. Create kof namespace and generate name prefix
        2. Generate auth for dns-autoconfig (optional)
        3. Install kof operators and wait for readiness
        4. Prepare DNS config and mothership values
        5. Install kof mothership
        6. Install kof regional
        7. Install kof child
    """
    show_step(1)
    kcm_manager = kcm_bootstrap_manager.check.kcm_mgr
    name_prefix = f"ksi-kof-{utils.gen_random_string(4)}"
    kof_ns = kcm_manager.get_or_create_namespace(settings.KSI_KOF_NAMESPACE)

    show_step(2)
    secret_name = f"{name_prefix}-secret"
    kof_ns.create_external_dns_auth_secret(secret_name)

    show_step(3)
    kcm_manager.kof.install_kof_operators()
    kcm_bootstrap_manager.check.wait_kof_op_ready()
    kcm_manager.refresh_expected_objects()
    kcm_bootstrap_manager.check.check_actual_expected_pods()

    show_step(4)
    values = kcm_manager.kof.get_mothership_values(auto_dns='aws',
                                                   dns_secret_name=secret_name)

    show_step(5)
    kcm_manager.kof.install_kof_mothership(values=values)
    kcm_bootstrap_manager.check.wait_kof_mothership_ready()
    kcm_manager.refresh_expected_objects()
    kcm_bootstrap_manager.check.check_actual_expected_pods()

    show_step(6)
    kcm_manager.kof.install_kof_regional()
    kcm_bootstrap_manager.check.wait_kof_regional_ready()
    kcm_bootstrap_manager.check.check_actual_expected_pods()

    show_step(7)
    kcm_manager.kof.install_kof_child()
    kcm_bootstrap_manager.check.wait_kof_child_ready()
    kcm_bootstrap_manager.check.check_actual_expected_pods()
