import pytest

from si_tests import logger
from qase.pytest import qase

LOG = logger.logger


@pytest.mark.usefixtures('log_step_time')
@pytest.mark.usefixtures('log_method_time')
@qase.id(1)
@qase.title("Test Install of KCM")
@qase.suite("Bootstrap")
def test_install_kcm(kcm_bootstrap_manager, show_step):
    """Install KCM chart into k8s cluster

    Scenario:
        1. Verify that no kcm installed inside provided cluster
        2. Install kcm chart
        3. Wait for helmrelease appear and become ready
        4. Verify that management object appear and in the correct state
        5. Check expected pods
    """

    show_step(1)
    assert not kcm_bootstrap_manager.is_kcm_installed(), 'KCM chart already present in provided cluster'
    show_step(2)
    kcm_bootstrap_manager.install_kcm()
    show_step(3)
    kcm_bootstrap_manager.check.wait_for_helm_crd_available()
    kcm_bootstrap_manager.check.wait_for_kcm_helmrelease_readiness()
    show_step(4)
    kcm_bootstrap_manager.check.wait_for_mgmt_object_readiness()
    show_step(5)
    kcm_bootstrap_manager.check.check_actual_expected_pods()
