#    Copyright 2025 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1K0rdentServiceTemplate(base.BaseModel):
    pass


class V1K0rdentServiceTemplateList(base.BaseModelList):
    pass


class K0rdentServiceTemplate(base.K8sNamespacedResource):
    resource_type = 'servicetemplate'
    model = V1K0rdentServiceTemplate

    @property
    def is_valid(self):
        return (self.data.get('status') or {}).get('valid')


class K0rdentServiceTemplateManager(base.K8sBaseManager):
    model = V1K0rdentServiceTemplateList
    resource_class = K0rdentServiceTemplate
    resource_group = 'k0rdent.mirantis.com'
    resource_version = 'v1beta1'
    resource_plural = 'servicetemplates'
