# si_tests.clients.gcore.box_api.PodsApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**admin_deschedule_pod**](PodsApi.md#admin_deschedule_pod) | **POST** /v1/admin/pods/deschedule | Deschedule Pod from current node
[**admin_metrics_for_pod**](PodsApi.md#admin_metrics_for_pod) | **GET** /v1/admin/{project}/pods/{name}/metrics | Get metrics for specific pod
[**admin_pods_metrics**](PodsApi.md#admin_pods_metrics) | **GET** /v1/admin/pods/metrics | Get metrics for inference workloads


# **admin_deschedule_pod**
> admin_deschedule_pod(v1_deschedule_pod_request)

Deschedule Pod from current node

This endpoint deletes the specified pod
and prevents that it's scheduled in the same node

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_deschedule_pod_request import V1DeschedulePodRequest
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.PodsApi(api_client)
    v1_deschedule_pod_request = si_tests.clients.gcore.box_api.V1DeschedulePodRequest() # V1DeschedulePodRequest | Pod descheduling info

    try:
        # Deschedule Pod from current node
        api_instance.admin_deschedule_pod(v1_deschedule_pod_request)
    except Exception as e:
        print("Exception when calling PodsApi->admin_deschedule_pod: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **v1_deschedule_pod_request** | [**V1DeschedulePodRequest**](V1DeschedulePodRequest.md)| Pod descheduling info | 

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |
**404** | Not Found |  -  |
**422** | Unprocessable Entity |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **admin_metrics_for_pod**
> V1GetMetricsForPodResponse admin_metrics_for_pod(project, name)

Get metrics for specific pod

This endpoint gets metrics for specific pod

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_get_metrics_for_pod_response import V1GetMetricsForPodResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.PodsApi(api_client)
    project = 'project_example' # str | Project name
    name = 'name_example' # str | Pod name

    try:
        # Get metrics for specific pod
        api_response = api_instance.admin_metrics_for_pod(project, name)
        print("The response of PodsApi->admin_metrics_for_pod:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PodsApi->admin_metrics_for_pod: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project** | **str**| Project name | 
 **name** | **str**| Pod name | 

### Return type

[**V1GetMetricsForPodResponse**](V1GetMetricsForPodResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **admin_pods_metrics**
> V1GetPodsMetricsResponse admin_pods_metrics()

Get metrics for inference workloads

This endpoint gets metrics for inference workloads

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_get_pods_metrics_response import V1GetPodsMetricsResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.PodsApi(api_client)

    try:
        # Get metrics for inference workloads
        api_response = api_instance.admin_pods_metrics()
        print("The response of PodsApi->admin_pods_metrics:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PodsApi->admin_pods_metrics: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**V1GetPodsMetricsResponse**](V1GetPodsMetricsResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

