#    Copyright 2025 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.


from importlib import resources
import os
from si_tests import settings_func

# ====
# START: Main parameters
# ====

ARTIFACTS_DIR = settings_func.get_var_force_dir(
    "ARTIFACTS_DIR", os.path.join(os.getcwd(), "artifacts/")
)

SI_TESTS_REPO_ROOT = settings_func.get_var("SI_TESTS_REPO_ROOT", "./")
SI_BINARIES_DIR = settings_func.get_var(
    "SI_BINARIES_DIR", settings_func.get_var("SI_BINARIES_DIR", "bin/")
)

LOGS_DIR = settings_func.get_var("LOGS_DIR", ARTIFACTS_DIR)
LOG_NAME = settings_func.get_var("LOG_NAME", "tests.log")
LOG_REST_DEBUG = settings_func.get_var("LOG_REST_DEBUG", True)
ENV_NAME = settings_func.get_var("ENV_NAME")
# DEPRECATED: please for clearly new tests and init logic - use KSI_KUBECONFIG_PATH
KUBECONFIG_PATH = settings_func.get_var("KUBECONFIG", None)
KSI_KUBECONFIG_PATH = settings_func.get_var("KSI_KUBECONFIG_PATH", None)
KSI_CONFIG_PATH = settings_func.get_var(
    "KSI_CONFIG", os.path.join(ARTIFACTS_DIR, "ksi_config.yaml")
)

# It's only possible to deploy in kcm-system ns. To deploy in other ns - need to configure access management object
KCM_NAMESPACE = settings_func.get_var("KCM_NAMESPACE", "kcm-system")
SVELTOS_NAMESPACE = settings_func.get_var("SVELTOS_NAMESPACE", "projectsveltos")
# The namespace created by sveltos for mgmt cluster management
KSI_SVELTOS_MGMT_NAMESPACE = settings_func.get_var("KSI_SVELTOS_MGMT_NAMESPACE", "mgmt")

KSI_SUPPORT_BUNDLE_VERSION = settings_func.get_var(
    "KSI_SUPPORT_BUNDLE_VERSION", "0.117.0"
)
KSI_SUPPORT_BUNDLE_TEMPLATE_PATH = settings_func.get_path(
    "KSI_SUPPORT_BUNDLE_TEMPLATE_PATH",
    "templates/deploy-objects/support-bundle/support-bundle.yaml.tpl",
)

KCM_CLUSTER_DEPLOYMENT_NAME = settings_func.get_var(
    "KCM_CLUSTER_DEPLOYMENT_NAME", "ksi-managed-cluster"
)

# Name and namespace of the cluster which will be used as a host for hosted deployments
KSI_HOST_CLUSTER_NAME = settings_func.get_var("KSI_HOST_CLUSTER_NAME", "")
KSI_HOST_CLUSTER_NAMESPACE = settings_func.get_var("KSI_HOST_CLUSTER_NAMESPACE", "")

KCM_CLUSTER_DEPLOYMENT_NAMESPACE = settings_func.get_var(
    "KCM_CLUSTER_DEPLOYMENT_NAMESPACE", KCM_NAMESPACE
)
KCM_CLUSTER_TEMPLATE_NAME = settings_func.get_var("KCM_CLUSTER_TEMPLATE_NAME", "")

# Target parameters for tests on existing clusters
TARGET_NAMESPACE = settings_func.get_var("TARGET_NAMESPACE", "kcm-system")
TARGET_CLD = settings_func.get_var("TARGET_CLD", KCM_CLUSTER_DEPLOYMENT_NAME)
# comma separated list of clusters
# format "namespace1/cluster1,namespace2/cluster2"
TARGET_CLDS = settings_func.get_var("TARGET_CLUSTERS", "").split(",")

# Custom helm repository parameters where extra ClusterTemplates and ServiceTemplates are stored
CUSTOM_HELM_REPOSITORY_TEMPLATE_PATH = settings_func.get_path(
    "CUSTOM_HELM_REPOSITORY_TEMPLATE_PATH",
    "templates/deploy-objects/repositories/helmrepository.yaml",
)
CUSTOM_HELM_REPOSITORY_SECRET_TEMPLATE_PATH = settings_func.get_path(
    "CUSTOM_HELM_REPOSITORY_SECRET_TEMPLATE_PATH",
    "templates/deploy-objects/repositories/helmrepository-secret.yaml",
)
# Will delete the repository, and it's secret if present, and create new ones
CUSTOM_HELM_REPOSITORY_OVERWRITE = settings_func.get_var_as_bool(
    "CUSTOM_HELM_REPOSITORY_OVERWRITE", False
)

# Parameters to create ServiceTemplate in the test si_tests/tests/lcm/servicetemplates/test_servicetemplate.py
CUSTOM_SERVICETEMPLATE_PATH = settings_func.get_path(
    "CUSTOM_SERVICETEMPLATE_PATH",
    "templates/deploy-objects/servicetemplates/default/servicetemplate.yaml",
)

# Parameters to create ClusterTemplate in the test si_tests/tests/clusterdeployments/test_add_clustertemplate.py
# Example ClusterTemplate yaml: 'templates/deploy-objects/clustertemplates/default/clustertemplate.yaml'
CUSTOM_CLUSTERTEMPLATE_PATH = settings_func.get_path("CUSTOM_CLUSTERTEMPLATE_PATH", "")
# If CUSTOM_SERVICETEMPLATE_PATH is empty, then the KCM_SERVICE_TEMPLATE_NAME will be used
# to deploy an existing ServiceTemplate from the KCM_CLUSTER_DEPLOYMENT_NAMESPACE namespace
KCM_SERVICE_TEMPLATE_NAME = settings_func.get_var("KCM_SERVICE_TEMPLATE_NAME", "")

# If specified, then will be used to create ClusterDeployment object with pre-defined 'services' in cld create_ tests
CUSTOM_CLUSTERDEPLOYMENT_PATH = settings_func.get_var(
    "CUSTOM_CLUSTERDEPLOYMENT_PATH", ""
)
# If specified, then will be used to apply extra services to the existing ClusterDeployment object
CUSTOM_CLUSTERDEPLOYMENT_SERVICES_PATH = settings_func.get_var(
    "CUSTOM_CLUSTERDEPLOYMENT_SERVICES_PATH", ""
)

CUSTOM_SERVICETEMPLATE_VALUES_PATH = settings_func.get_var(
    "CUSTOM_SERVICETEMPLATE_VALUES_PATH", ""
)
# Projectsveltos related name/namespace which is used on the target cluster
CUSTOM_CLUSTERSERVICE_NAME = settings_func.get_var("CUSTOM_CLUSTERSERVICE_NAME", "")
CUSTOM_CLUSTERSERVICE_NAMESPACE = settings_func.get_var(
    "CUSTOM_CLUSTERSERVICE_NAMESPACE", ""
)

CHECK_CLUSTER_READINESS_TIMEOUT = int(
    settings_func.get_var("CHECK_CLUSTER_READINESS_TIMEOUT", 7200)
)

# Check cap* controller managers for errors during check_cluster_readiness()
ENABLE_INTROSPECT_CAP_ERRORS = settings_func.get_var_as_bool(
    "ENABLE_INTROSPECT_CAP_ERRORS", True
)

# Comma-separated list of service templates
SERVICE_TEMPLATES_LIST = settings_func.get_var("SERVICE_TEMPLATES_LIST", "")
if SERVICE_TEMPLATES_LIST:
    SERVICE_TEMPLATES_LIST = SERVICE_TEMPLATES_LIST.split(",")

# Expected pods checker parameters
SKIP_EXPECTED_POD_CHECK = settings_func.get_var_as_bool(
    "SKIP_EXPECTED_POD_CHECK", False
)
CHECK_ACTUAL_EXPECTED_PODS_TIMEOUT = int(
    settings_func.get_var("CHECK_ACTUAL_EXPECTED_PODS_TIMEOUT", 5 * 60)
)
WAIT_PODS_READY_TIMEOUT = int(settings_func.get_var("WAIT_PODS_READY_TIMEOUT", 1800))

KCM_MANAGEMENT_NAME = settings_func.get_var("KCM_MANAGEMENT_NAME", "kcm")
KCM_CHART_VERSION = settings_func.get_var("KCM_CHART_VERSION", "0.1.0")
KCM_CHART_NAME = settings_func.get_var("KCM_CHART_NAME", "kcm")
KSI_KCM_TEMPLATES_REPO_NAME = settings_func.get_var("KSI_KCM_TEMPLATES_REPO_NAME", "kcm-templates")
KSI_KCM_CHART_INSTALL_TIMEOUT = settings_func.get_var("KSI_KCM_CHART_INSTALL_TIMEOUT", "10m")
KSI_ENTERPRISE_NAME = settings_func.get_var("KSI_ENTERPRISE_NAME", "k0rdent-enterprise")
KSI_HELM_INSECURE = settings_func.get_var_as_bool("KSI_HELM_INSECURE", False)

# Customisation of kcm installation
# KCM_SOURCE - can be 'opensource'/'enterprise'/'custom-enterprise'/<other>.
# KCM_SOURCE='opensource' and KCM_SOURCE=None results to the
# same behavior - using opensource repos and repo switcher depended on version. (release/ci)
# KCM_SOURCE='custom-enterprise' requires KCM_CUSTOM_REGISTRY to be set
# KCM_SOURCE='enterprise' targets to enterprise repo.
KCM_SOURCE = settings_func.get_var("KCM_SOURCE", "opensource")
# Will be used both for oci:// and image pulling. e.g if you have 'registry.local' in this param - charts will
# be downloaded from oci://registry.local/charts, k0rdent-enterprise will be installed
# from oci://registry.local/charts/k0rdent-enterprise, images pulled with `registry.local` as a base.
# proper setting: KCM_CUSTOM_REGISTRY = 172.19.124.46:5000. without oci proto.
# url oci://172.19.124.46:5000/charts should be present in repo and will be used in constructions of
# images/charts repos
KCM_CUSTOM_REGISTRY = settings_func.get_var("KCM_CUSTOM_REGISTRY", None)
# Set to true to support HTTP proto for kcm registries. This is value for the kcm controller.
KSI_KCM_CUSTOM_INSECURE_REGISTRY = settings_func.get_var_as_bool("KSI_KCM_CUSTOM_INSECURE_REGISTRY", False)
# Registry auth
KSI_KCM_CUSTOM_REGISTRY_USERNAME = settings_func.get_var("KSI_KCM_CUSTOM_REGISTRY_USERNAME", None)
KSI_KCM_CUSTOM_REGISTRY_PASSWORD = settings_func.get_var("KSI_KCM_CUSTOM_REGISTRY_PASSWORD", None)
# Use self-signed registry certs
KSI_CUSTOM_REGISTRY_CERT_TEXT = settings_func.get_var("KSI_CUSTOM_REGISTRY_CERT_TEXT", None)
KSI_CUSTOM_REGISTRY_CERT_PATH = settings_func.get_path("KSI_CUSTOM_REGISTRY_CERT_PATH", None)

KCM_REPO_DICT = {
    "oss-repo": "ghcr.io/k0rdent/kcm",
    "enterprise-repo": "registry.mirantis.com/k0rdent-enterprise",
    "oot-capi-provider-metal3-ci-registry": "oci://registry.ci.mirantis.com/k0rdent-bm/ci/charts",
    "oot-capi-provider-metal3-enterprise-registry": "oci://registry.mirantis.com/k0rdent-bm/release/charts",
}
KSI_KCM_CTL_NAME_DICT = {
    "oss": "controller",
    "oss-ci": "controller-ci",
    "enterprise": "kcm-controller"
}
# Used in custom repo or airgapped deployments.
# Binary should be available by URL {KSI_K0S_URL}/k0s-v1.32.5+k0s.1-amd64.
# if KSI_K0S_URL = http://172.19.124.46:8080 - http://172.19.124.46:8080/k0s-v1.32.5+k0s.1-amd64 should be available
KSI_K0S_URL = settings_func.get_var("KSI_K0S_URL", None)

# kof variables and customisation
KSI_KOF_NAMESPACE = settings_func.get_var("KSI_KOF_NAMESPACE", "kof")
KSI_KOF_ISTIO_NAMESPACE = settings_func.get_var("KSI_KOF_ISTIO_NAMESPACE", "istio-system")
KSI_KOF_OP_CHART_NAME = settings_func.get_var("KSI_KOF_OP_CHART_NAME", "kof-operators")
KSI_KOF_MS_CHART_NAME = settings_func.get_var("KSI_KOF_MS_CHART_NAME", "kof-mothership")
KSI_KOF_RE_CHART_NAME = settings_func.get_var("KSI_KOF_RE_CHART_NAME", "kof-regional")
KSI_KOF_CH_CHART_NAME = settings_func.get_var("KSI_KOF_CH_CHART_NAME", "kof-child")
KSI_KOF_IS_CHART_NAME = settings_func.get_var("KSI_KOF_IS_CHART_NAME", "kof-istio")
KSI_KOF_CO_CHART_NAME = settings_func.get_var("KSI_KOF_CO_CHART_NAME", "kof-collectors")
KSI_KOF_ST_CHART_NAME = settings_func.get_var("KSI_KOF_ST_CHART_NAME", "kof-storage")
# This should have same version for all kof charts.
KSI_KOF_CHART_VERSION = settings_func.get_var("KSI_KOF_CHART_VERSION", "1.1.0")
KSI_KOF_SOURCE = settings_func.get_var("KSI_KOF_SOURCE", KCM_SOURCE)
KSI_KOF_CUSTOM_REGISTRY = settings_func.get_var("KSI_KOF_CUSTOM_REGISTRY", KCM_CUSTOM_REGISTRY)
# Where to store mgmt metrics. Possible choises - 'management' and 'regional'.
# When 'regional' is set - right after regional deployment (in the regional test)
# the collectors will be installed on mgmt and configured to regional.
# 'management' will require different test execution since the storage chart should be installed also
KSI_KOF_MGMT_STORAGE = settings_func.get_var("KSI_KOF_MGMT_STORAGE", 'management')

KSI_KOF_REPO_DICT = {
    "oss-repo": "ghcr.io/k0rdent/kof",
    "enterprise-repo": "registry.mirantis.com/k0rdent-enterprise",
}

# https://github.com/kubernetes-sigs/cluster-api/blob/main/api/v1beta1/machine_types.go#L597
CAPI_OPERATOR_APIVERSION = settings_func.get_var("CAPI_OPERATOR_APIVERSION", "v1beta2")
REMOVE_RESOURCES_ON_KCM_CLEANUP = settings_func.get_var_as_bool(
    "REMOVE_RESOURCES_ON_KCM_CLEANUP", True
)

KSI_REGION_NAME = settings_func.get_var("KSI_REGION_NAME", 'region-one')
KSI_KOF_EMAIL = settings_func.get_var("KSI_KOF_EMAIL", 'the_mighty_qa@mirantis.com')
# ====
# END: Main parameters
# ====

# ====
# START: Template path parameters
# ====

MACHINE_PRIVELEGED_POD_YAML = settings_func.get_path(
    "MACHINE_PRIVELEGED_POD_YAML", "templates/pods/machine_priveleged_pod.yaml"
)

EXPECTED_PODS_TEMPLATES_DIR = (
    settings_func.get_path("EXPECTED_PODS_TEMPLATES_DIR", "templates/expected-pods")
    + "/"
)

# ====
# END: Template path parameters
# ====

# ====
# START: e2e Conformance parameters
# ====

K8S_CONFORMANCE_POD_YAML = settings_func.get_path(
    "K8S_CONFORMANCE_POD_YAML", "templates/pods/k8s_conformance_test_pod.yaml"
)

K8S_CONFORMANCE_NAMESPACE = settings_func.get_var(
    "K8S_CONFORMANCE_NAMESPACE", "conformance"
)
K8S_CONFORMANCE_POD_NAME = settings_func.get_var(
    "K8S_CONFORMANCE_POD_NAME", "conformance"
)
K8S_CONFORMANCE_REPORTS_DIR = settings_func.get_var(
    "K8S_CONFORMANCE_REPORTS_DIR", "/report"
)

K8S_CONFORMANCE_RESULTS_WAIT_TIMEOUT = int(
    settings_func.get_var("K8S_CONFORMANCE_RESULTS_WAIT_TIMEOUT", 5400)
)

K8S_CONFORMANCE_IMAGE = settings_func.get_var(
    "K8S_CONFORMANCE_IMAGE", "lcm/kubernetes/k8s-conformance"
)

# TODO: remove when PRODX-4679 is Done
K8S_CONFORMANCE_IMAGE_VERSION_CHECK_PATH = settings_func.get_var(
    "K8S_CONFORMANCE_IMAGE_VERSION_CHECK_PATH",
    "https://docker-dev-kaas-virtual.docker.mirantis.net/artifactory/docker-dev-kaas-virtual/"
    + K8S_CONFORMANCE_IMAGE,
)

K8S_CONFORMANCE_IMAGE_VERSION = settings_func.get_var(
    "K8S_CONFORMANCE_IMAGE_VERSION", ""
)
K8S_CONFORMANCE_CLUSTER_DOMAIN = settings_func.get_var(
    "K8S_CONFORMANCE_CLUSTER_DOMAIN", ""
)
K8S_CONFORMANCE_USER_DEFINED_SKIP_REGEX = settings_func.get_var(
    "K8S_CONFORMANCE_USER_DEFINED_SKIP_REGEX", ""
)
K8S_CONFORMANCE_CHECK_RESULTS = settings_func.get_var_as_bool(
    "K8S_CONFORMANCE_CHECK_RESULTS", True
)

K8S_CONFORMANCE_NON_BLOCKING_TAINTS = settings_func.get_var_as_bool(
    "K8S_CONFORMANCE_NON_BLOCKING_TAINTS", False
)

K8S_CONFORMANCE_DISABLE_OFFLINE_LOGIC = settings_func.get_var_as_bool(
    "K8S_CONFORMANCE_DISABLE_OFFLINE_LOGIC", False
)

# ====
# END: e2e Conformance parameters
# ====

# ====
# START: Provider specific configs
# ====

KCM_CLUSTER_CONTROLPLANE_NUMBER = int(
    settings_func.get_var("KCM_CLUSTER_CONTROLPLANE_NUMBER", 1)
)
KCM_CLUSTER_WORKERS_NUMBER = int(settings_func.get_var("KCM_CLUSTER_WORKERS_NUMBER", 1))

# START: AWS specific
AWS_PROVIDER_NAME = "aws"
AWS_ENABLED = settings_func.get_var_as_bool("AWS_ENABLED", False)
AWS_SECRET_ACCESS_KEY = settings_func.get_var("AWS_SECRET_ACCESS_KEY", None)
AWS_ACCESS_KEY_ID = settings_func.get_var("AWS_ACCESS_KEY_ID", None)
AWS_DEFAULT_REGION = settings_func.get_var("AWS_DEFAULT_REGION", "us-east-2")
AWS_DEFAULT_AZ = settings_func.get_var("AWS_DEFAULT_AZ", "us-east-2a")
AWS_INSTANCE_TYPE_CTL = settings_func.get_var("AWS_INSTANCE_TYPE_CTL", "t3.small")
AWS_INSTANCE_TYPE_WRK = settings_func.get_var("AWS_INSTANCE_TYPE_WRK", "t3.small")
AWS_INSTANCE_AMI_CTL = settings_func.get_var("AWS_INSTANCE_AMI_CTL", "")
AWS_INSTANCE_AMI_WRK = settings_func.get_var("AWS_INSTANCE_AMI_WRK", "")
AWS_INSTANCE_ROOT_SIZE_CTL = int(settings_func.get_var("AWS_INSTANCE_ROOT_SIZE_CTL", 0))
AWS_INSTANCE_ROOT_SIZE_WRK = int(settings_func.get_var("AWS_INSTANCE_ROOT_SIZE_WRK", 0))
# END: AWS specific

# START: EKS specific
EKS_PROVIDER_NAME = "eks"
EKS_SSH_KEY_NAME = settings_func.get_var("EKS_SSH_KEY_NAME", "")
# END: AWS specific

# START: Azure specific
AZURE_PROVIDER_NAME = "azure"
AZURE_ENABLED = settings_func.get_var_as_bool("AZURE_ENABLED", False)
AZURE_SUBSCRIPTION_ID = settings_func.get_var("AZURE_SUBSCRIPTION_ID", None)
AZURE_TENANT_ID = settings_func.get_var("AZURE_TENANT_ID", None)
AZURE_CLIENT_ID = settings_func.get_var("AZURE_CLIENT_ID", None)
AZURE_CLIENT_SECRET = settings_func.get_var("AZURE_CLIENT_SECRET", None)
AZURE_CLUSTER_LOCATION = settings_func.get_var("AZURE_CLUSTER_LOCATION", "westus2")
AZURE_VM_SIZE_CTL = settings_func.get_var("AZURE_VM_SIZE", "Standard_A4_v2")
AZURE_VM_SIZE_WRK = settings_func.get_var("AZURE_VM_SIZE_CHILD", "Standard_A4_v2")
# END: Azure specific


# This auth way slightly differs from usual.
# To acquire app-creds navigate to User > Identification > Application access
# START: Openstack specific
OPENSTACK_PROVIDER_NAME = "openstack"
OS_AUTH_URL = settings_func.get_var(
    "OS_AUTH_URL", "https://keystone.ic-eu.ssl.mirantis.net/"
)
OS_APPLICATION_CREDENTIAL_ID = settings_func.get_var(
    "OS_APPLICATION_CREDENTIAL_ID", None
)
OS_APPLICATION_CREDENTIAL_SECRET = settings_func.get_var(
    "OS_APPLICATION_CREDENTIAL_SECRET", None
)
OS_REGION_NAME = settings_func.get_var("OS_REGION_NAME", "RegionOne")
OS_INTERFACE = settings_func.get_var("OS_INTERFACE", "public")
OS_IDENTITY_API_VERSION = settings_func.get_var("OS_IDENTITY_API_VERSION", "3")
OS_AUTH_TYPE = settings_func.get_var("OS_AUTH_TYPE", "v3applicationcredential")
# cfg.dev - standard flavor with 4c/8g/20gb
OS_CTL_MACHINE_FLAVOR = settings_func.get_var("OS_CTL_MACHINE_FLAVOR", "cfg.dev")
# k8s_contrail.cid - standard flavor with 2c/4g/20gb
OS_WRK_MACHINE_FLAVOR = settings_func.get_var(
    "OS_WRK_MACHINE_FLAVOR", "k8s_contrail.cid"
)
OS_INSTANCE_IMAGE_NAME = settings_func.get_var(
    "OS_INSTANCE_IMAGE_NAME", "ubuntu-24.04-x86_64"
)

KSI_OS_SECURITY_GROUP = settings_func.get_var(
    "KSI_OS_SECURITY_GROUP", None
)
KSI_OS_KEYPAIR_NAME = settings_func.get_var(
    "KSI_OS_KEYPAIR_NAME", None
)
# END: Openstack specific


# START: VSphere specific
VSPHERE_PROVIDER_NAME = "vsphere"
VSPHERE_ENABLED = settings_func.get_var_as_bool("VSPHERE_ENABLED", False)
VSPHERE_SERVER_ADDR = settings_func.get_var("VSPHERE_SERVER_ADDR", None)
VSPHERE_DATACENTER_NAME = settings_func.get_var("VSPHERE_DATACENTER_NAME", None)
VSPHERE_DATASTORE_PATH = settings_func.get_var("VSPHERE_DATASTORE_PATH", None)
VSPHERE_USER = settings_func.get_var("VSPHERE_USER", None)
VSPHERE_PASSWORD = settings_func.get_var("VSPHERE_PASSWORD", None)
VSPHERE_NETWORK_PATH = settings_func.get_var(
    "VSPHERE_NETWORK_PATH",
)
VSPHERE_VM_TEMPLATE_PATH = settings_func.get_var("VSPHERE_VM_TEMPLATE_PATH", None)
VSPHERE_RESOURCE_POOL_PATH = settings_func.get_var("VSPHERE_RESOURCE_POOL_PATH", None)
VSPHERE_FOLDER_PATH = settings_func.get_var("VSPHERE_FOLDER_PATH", None)
VSPHERE_SERVER_INSECURE = settings_func.get_var("VSPHERE_SERVER_INSECURE", True)
# TODO(va4st): Add mech for determining the LB addr based on provider networks
VSPHERE_NETWORK_CIDR = settings_func.get_var("VSPHERE_NETWORK_CIDR", None)
VSPHERE_CIDR_INCLUDE_RANGES = settings_func.get_var("VSPHERE_CIDR_INCLUDE_RANGES", None)
VSPHERE_CIDR_EXCLUDE_RANGES = settings_func.get_var("VSPHERE_CIDR_EXCLUDE_RANGES", None)
# TODO(va4st): Use CIDR, excluded ranges and allocated IPs via vclient to get proper static IP
VSPHERE_CONTROL_PLANE_ENDPOINT_IP = settings_func.get_var(
    "VSPHERE_CONTROL_PLANE_ENDPOINT_IP", None
)
VSPHERE_MACHINE_CPU = int(settings_func.get_var("VSPHERE_MACHINE_CPU", 2))
VSPHERE_MACHINE_RAM = int(settings_func.get_var("VSPHERE_MACHINE_RAM", 2048))
VSPHERE_ROOT_VOLUME_SIZE = int(settings_func.get_var("VSPHERE_ROOT_VOLUME_SIZE", 20))
# Using this for both specs - control and worker
VSPHERE_SSH_USER = settings_func.get_var("VSPHERE_SSH_USER", "ubuntu")
# In RAW string.
VSPHERE_SSH_PUBKEY = settings_func.get_var("VSPHERE_SSH_PUBKEY", "ubuntu")
# END: VSphere specific

# START: GCP specific
GCP_PROVIDER_NAME = "gcp"
GCP_AUTH_TYPE = settings_func.get_var("GCP_AUTH_TYPE", "service_account")
GCP_PROJECT_ID = settings_func.get_var("GCP_PROJECT_ID", None)
GCP_PRIVATE_KEY_ID = settings_func.get_var("GCP_PRIVATE_KEY_ID", None)
GCP_PRIVATE_KEY = settings_func.get_var("GCP_PRIVATE_KEY", None)
GCP_CLIENT_EMAIL = settings_func.get_var("GCP_CLIENT_EMAIL", None)
GCP_CLIENT_ID = settings_func.get_var("GCP_CLIENT_ID", None)
GCP_AUTH_URI = settings_func.get_var(
    "GCP_AUTH_URI", "https://accounts.google.com/o/oauth2/auth"
)
GCP_TOKEN_URI = settings_func.get_var(
    "GCP_TOKEN_URI", "https://oauth2.googleapis.com/token"
)
GCP_AUTH_PROVIDER_X509_CERT_URI = settings_func.get_var(
    "GCP_AUTH_PROVIDER_X509_CERT_URI", "https://www.googleapis.com/oauth2/v1/certs"
)
GCP_CLIENT_X509_CERT_URI = settings_func.get_var("GCP_CLIENT_X509_CERT_URI", None)
GCP_UNIVERCE_DOMAIN = settings_func.get_var("GCP_UNIVERCE_DOMAIN", "googleapis.com")

GCP_REGION = settings_func.get_var("GCP_REGION", "europe-west4")
GCP_NETWORK_NAME = settings_func.get_var("GCP_NETWORK_NAME", None)
GCP_CP_MACHINE_TYPE = settings_func.get_var("GCP_CP_MACHINE_TYPE", "n2d-standard-2")
GCP_WORKER_MACHINE_TYPE = settings_func.get_var(
    "GCP_WORKER_MACHINE_TYPE", GCP_CP_MACHINE_TYPE
)
GCP_CP_IMAGE = settings_func.get_var(
    "GCP_CP_IMAGE",
    "projects/ubuntu-os-cloud/global/images/ubuntu-2404-noble-amd64-v20250409",
)
GCP_WRK_IMAGE = settings_func.get_var("GCP_WRK_IMAGE", GCP_CP_IMAGE)
# END: GCP specific

# START: env-on-openstack backend specific
# NOTE(alexz-kh): to be used on ksi internally only, DON'T provide\mix it with OS_ params for provider logic!
KSI_OS_CLOUD_NAME = settings_func.get_var("KSI_OS_CLOUD_NAME", "NONE_KSI_OS_CLOUD_NAME")
KSI_OS_APP_SECRET = settings_func.get_var("KSI_OS_APP_SECRET", "NONE_KSI_OS_APP_SECRET")
KSI_OS_CLOUDS_YAML_PATH = settings_func.get_var(
    "KSI_OS_CLOUDS_YAML_PATH",
    str(resources.files(__package__) / "test_env_data/ic_access/clouds.yaml"),
)
# do we need to delete=>create heat stack?
KSI_KEEP_ENV_BEFORE = settings_func.get_var_as_bool("KSI_KEEP_ENV_BEFORE", True)
# env_config , under test_env_data//labs/{}/
KSI_ENV_CONFIG_NAME = settings_func.get_var("KSI_ENV_CONFIG_NAME", "")

KSI_HEAT_DATA_PATH = settings_func.get_var(
    "KSI_HEAT_DATA_PATH_",
    str(
        resources.files(__package__)
        / "test_env_data/labs/{}/heat_data/".format(KSI_ENV_CONFIG_NAME or ENV_NAME)
    ),
)

KSI_BOOTSTRAP_DATA_PATH = settings_func.get_var(
    "KSI_BOOTSTRAP_DATA_PATH",
    str(
        resources.files(__package__)
        / "test_env_data/labs/{}/bootstrap_data/main.yaml.j2".format(
            KSI_ENV_CONFIG_NAME or ENV_NAME
        )
    ),
)
#  seed node IP, might be overwritten or fetched from ksi_config.yaml
KSI_SEED_IP = settings_func.get_var("KSI_SEED_IP", None)

# this url will be attached to openstack-heat stack(as for now), useful to trace-back orphaned envs
KSI_BUILD_URL = settings_func.get_var("KSI_BUILD_URL", "")

# START: k0s related

KSI_K0S_VERSION = settings_func.get_var("KSI_K0S_VERSION", "v1.32.3+k0s.0")
KSI_K0S_APPLY_REGISTRY_HACK = settings_func.get_var_as_bool(
    "KSI_K0S_APPLY_REGISTRY_HACK", False
)
# r\o access to registry.ci.mirantis.com
KSI_SECRET_REGISTRY_CI_MIRANTIS_COM_USERNAME = settings_func.get_var(
    "KSI_SECRET_REGISTRY_CI_MIRANTIS_COM_USERNAME", None
)
KSI_SECRET_REGISTRY_CI_MIRANTIS_COM_PASSWORD = settings_func.get_var(
    "KSI_SECRET_REGISTRY_CI_MIRANTIS_COM_PASSWORD", None
)
KSI_BAREMETAL_CAPI_PROVIDER_METAL3_CHART_VERSION = settings_func.get_var(
    "KSI_BAREMETAL_CAPI_PROVIDER_METAL3_CHART_VERSION", None
)

# END: k0s related

# HW access list
KSI_SECRET_BMC_CZ5570 = settings_func.get_var("KSI_SECRET_BMC_CZ5570", None)
KSI_SECRET_BMC_CZ5571 = settings_func.get_var("KSI_SECRET_BMC_CZ5571", None)
KSI_SECRET_BMC_CZ8204 = settings_func.get_var("KSI_SECRET_BMC_CZ8204", None)
KSI_SECRET_BMC_CZ5573 = settings_func.get_var("KSI_SECRET_BMC_CZ5573", None)
KSI_SECRET_BMC_CZ5572 = settings_func.get_var("KSI_SECRET_BMC_CZ5572", None)
# END: HW access list

# START: metal3 specific
KSI_METAL3_PROVIDER_NAME = "metal3"
# END: metal3 specific
# ====
# END: Provider specific configs
# ====


# START: GCore inference specific
KSI_INFERENCE_BOX_CLUSTER_NAME = settings_func.get_var("KSI_INFERENCE_BOX_CLUSTER_NAME", "dummy-cluster")
KSI_INFERENCE_BOX_KEYCLOAK_URL = settings_func.get_var("KSI_INFERENCE_BOX_KEYCLOAK_URL", "")
KSI_INFERENCE_BOX_KEYCLOAK_CLIENT_ID = settings_func.get_var("KSI_INFERENCE_BOX_KEYCLOAK_CLIENT_ID",
                                                             KSI_INFERENCE_BOX_CLUSTER_NAME)
KSI_INFERENCE_BOX_KEYCLOAK_REALM_NAME = settings_func.get_var("KSI_INFERENCE_BOX_KEYCLOAK_REALM_NAME", "realmWithLdap")
KSI_INFERENCE_BOX_API_URL = settings_func.get_var("KSI_INFERENCE_BOX_API_URL", "")
KSI_INFERENCE_BOX_API_USERNAME = settings_func.get_var("KSI_INFERENCE_BOX_API_USERNAME", "")
KSI_INFERENCE_BOX_API_PASSWORD = settings_func.get_var("KSI_INFERENCE_BOX_API_PASSWORD", "")

KSI_INFERENCE_ROOT_APP_NAME = settings_func.get_var("KSI_INFERENCE_ROOT_APP_NAME", "the-app-of-apps")
KSI_INFERENCE_ROOT_APP_NAMESPACE = settings_func.get_var("KSI_INFERENCE_ROOT_APP_NAMESPACE", "argocd")
KSI_INFERENCE_ROOT_APP_REPO_URL = settings_func.get_var(
    "KSI_INFERENCE_ROOT_APP_REPO_URL",
    "http://gitea-http.gitea.svc.cluster.local:3000/box/box-cluster.git")
KSI_INFERENCE_ROOT_APP_PATH = settings_func.get_var("KSI_INFERENCE_ROOT_APP_PATH", "apps-of-apps/")
KSI_INFERENCE_ROOT_APP_BASE_TARGET_REVISION = settings_func.get_var(
    "KSI_INFERENCE_ROOT_APP_BASE_TARGET_REVISION",
    "inference")
KSI_INFERENCE_ROOT_APP_UPGRADE_TARGET_REVISION = settings_func.get_var(
    "KSI_INFERENCE_ROOT_APP_UPGRADE_TARGET_REVISION",
    "inference-upgrade")
KSI_INFERENCE_BOX_CLUSTER_BASE_IMAGES = settings_func.get_var("KSI_INFERENCE_BOX_CLUSTER_BASE_IMAGES", "")
KSI_INFERENCE_BOX_CLUSTER_UPGRADE_IMAGES = settings_func.get_var("KSI_INFERENCE_BOX_CLUSTER_UPGRADE_IMAGES", "")
# END: GCore inference specific
