# coding: utf-8

"""
    Inference Box API

    ## Welcome to Inference Box API  A comprehensive REST API for managing cloud infrastructure resources including ML inference deployments, Kubernetes resources, and application lifecycle management.  ## Overview  Inference Box API is a cloud-native REST API service that provides unified access to manage:  - **ML Inference Deployments**: Create, manage, and scale machine learning inference services - **Slurm Clusters**: Deploy, configure, and manage HPC Slurm clusters for batch workloads - **Kubernetes Resources**: Manage namespaces (projects), pods, secrets, volumes, and other K8s resources - **Application Lifecycle**: Deploy and manage applications from catalog templates - **Resource Management**: Handle flavors, capacities, quotas, and node groups - **User & Access Control**: Manage users, groups, and API keys with RBAC integration - **Monitoring & Metrics**: Query metrics and monitor resource usage via Victoria Metrics  The service is built with Go and integrates with Kubernetes, HashiCorp Vault, and Victoria Metrics to provide a complete cloud infrastructure management solution.  ## Key API Endpoints  - **Inference**: `/v1/{project_name}/inferences` - ML inference deployment management - **Slurm Clusters**: `/v1/{project_name}/slurm/clusters` - Slurm cluster deployment and management - **Flavors**: `/v1/flavors` - Compute resource flavor definitions - **Users**: `/v1/admin/users` - User management (admin only) - **Projects**: `/v1/{project_name}` - Project-scoped resource operations - **Metrics**: `/v1/{project_name}/metrics` - Resource usage metrics  ## Getting Started  ### Authentication  All API requests require authentication using the `X-API-Key` header. Most operations are scoped to specific projects/namespaces.  ### API Organization  The API is organized into logical groups: - **Public endpoints**: `/v1/*` - General access endpoints - **Project-scoped**: `/v1/{project_name}/*` - Project-specific resources - **Admin endpoints**: `/v1/admin/*` - Administrative operations  ### Documentation  Interactive documentation is available at `/docs` when the service is running. 

    The version of the OpenAPI document: 2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest

from si_tests.clients.gcore.box_api.models.v1_overview_response import V1OverviewResponse

class TestV1OverviewResponse(unittest.TestCase):
    """V1OverviewResponse unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional) -> V1OverviewResponse:
        """Test V1OverviewResponse
            include_optional is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        # uncomment below to create an instance of `V1OverviewResponse`
        """
        model = V1OverviewResponse()
        if include_optional:
            return V1OverviewResponse(
                allocated_resources = {cpu=100, memory=200},
                clusters = [
                    si_tests.clients.gcore.box_api.models.v1/cluster.v1.Cluster(
                        available_resources = {cpu=50, memory=100}, 
                        capacity = {inference-16vcpu-232gib-1xa100-48gb=100, inference-8vcpu-128gib-1xa100-48gb=50}, 
                        edge_regions = [region1, region2], 
                        name = 'cluster1', 
                        total_resources = {cpu=100, memory=200}, 
                        used_resources = {cpu=50, memory=100}, )
                    ],
                nodes = [
                    si_tests.clients.gcore.box_api.models.v1/node.v1.Node(
                        available_resources = {cpu=32, memory=128Gi, nvidia.com/gpu=2}, 
                        gpu_model = 'NVIDIA A100 40GB', 
                        name = 'node1', 
                        node_group = 'node-group1', 
                        pods = [
                            si_tests.clients.gcore.box_api.models.v1/pod.v1.Pod(
                                inference_name = 'inference-job1', 
                                name = 'pod1', 
                                namespace = 'default', 
                                node_name = 'node1', 
                                region_name = 'region1', 
                                requested_resources = {cpu=4, memory=16Gi, nvidia.com/gpu=1}, )
                            ], 
                        region_name = 'region1', 
                        status = 'Ready', 
                        total_resources = {cpu=64, memory=256, nvidia.com/gpu=4}, 
                        used_resources = {cpu=32, memory=128Gi, nvidia.com/gpu=2}, )
                    ],
                regions = [
                    si_tests.clients.gcore.box_api.models.api_services_overview_v1/region.api_services_overview_v1.Region(
                        name = 'region1', 
                        type = 'core', )
                    ],
                registries = [
                    si_tests.clients.gcore.box_api.models.api_services_overview_v1/registry_response.api_services_overview_v1.RegistryResponse(
                        name = 'my-registry', 
                        namespace = 'my-project', 
                        preheat_policies = [
                            si_tests.clients.gcore.box_api.models.api_services_overview_v1/preheat_policy.api_services_overview_v1.PreheatPolicy(
                                filters = si_tests.clients.gcore.box_api.models.api_services_overview_v1/preheat_policy_filters.api_services_overview_v1.PreheatPolicyFilters(
                                    labels = [production, stable], 
                                    repositories = [nginx, python], 
                                    tags = [latest, stable], ), 
                                name = 'daily-preheat', 
                                trigger = si_tests.clients.gcore.box_api.models.api_services_overview_v1/preheat_policy_trigger.api_services_overview_v1.PreheatPolicyTrigger(
                                    schedule = '0 0 * * *', 
                                    type = 'scheduled', ), )
                            ], 
                        public = False, 
                        status = 'Ready', 
                        storage_limit = '1Gi', 
                        url = 'registry.my-project.ai.example.com', )
                    ],
                registries_total = 1000,
                registries_usage = 875.9,
                used_resources = {cpu=50, memory=100},
                volumes = [
                    si_tests.clients.gcore.box_api.models.v1/volume_response.v1.VolumeResponse(
                        empty_dir = si_tests.clients.gcore.box_api.models.v1/empty_dir_volume_source.v1.EmptyDirVolumeSource(
                            medium = 'Memory', 
                            size_limit = '1Gi', ), 
                        image = si_tests.clients.gcore.box_api.models.v1/image_volume_source.v1.ImageVolumeSource(
                            reference = '', ), 
                        managed = True, 
                        name = 'csi-vast-sc', 
                        object_references = [
                            si_tests.clients.gcore.box_api.models.api_util_references/object_reference.api_util_references.ObjectReference(
                                kind = 'AppDeployment', 
                                name = 'mlappdeployment-1', 
                                project = 'omnicore', )
                            ], 
                        pvc = si_tests.clients.gcore.box_api.models.v1/pvc_volume_source.v1.PVCVolumeSource(
                            access_mode = 'ReadOnlyMany', 
                            capacity = '5Gi', 
                            storage_class = 'csi-vast-sc', ), 
                        regions = [luxembourg, paris], 
                        status = '', 
                        statuses = {
                            'key' : si_tests.clients.gcore.box_api.models.v1/regional_volume_status.v1.RegionalVolumeStatus(
                                status = '', 
                                status_message = '', )
                            }, )
                    ]
            )
        else:
            return V1OverviewResponse(
        )
        """

    def testV1OverviewResponse(self):
        """Test V1OverviewResponse"""
        # inst_req_only = self.make_instance(include_optional=False)
        # inst_req_and_optional = self.make_instance(include_optional=True)

if __name__ == '__main__':
    unittest.main()
