# coding: utf-8

"""
    Inference Box API

    ## Welcome to Inference Box API  A comprehensive REST API for managing cloud infrastructure resources including ML inference deployments, Kubernetes resources, and application lifecycle management.  ## Overview  Inference Box API is a cloud-native REST API service that provides unified access to manage:  - **ML Inference Deployments**: Create, manage, and scale machine learning inference services - **Slurm Clusters**: Deploy, configure, and manage HPC Slurm clusters for batch workloads - **Kubernetes Resources**: Manage namespaces (projects), pods, secrets, volumes, and other K8s resources - **Application Lifecycle**: Deploy and manage applications from catalog templates - **Resource Management**: Handle flavors, capacities, quotas, and node groups - **User & Access Control**: Manage users, groups, and API keys with RBAC integration - **Monitoring & Metrics**: Query metrics and monitor resource usage via Victoria Metrics  The service is built with Go and integrates with Kubernetes, HashiCorp Vault, and Victoria Metrics to provide a complete cloud infrastructure management solution.  ## Key API Endpoints  - **Inference**: `/v1/{project_name}/inferences` - ML inference deployment management - **Slurm Clusters**: `/v1/{project_name}/slurm/clusters` - Slurm cluster deployment and management - **Flavors**: `/v1/flavors` - Compute resource flavor definitions - **Users**: `/v1/admin/users` - User management (admin only) - **Projects**: `/v1/{project_name}` - Project-scoped resource operations - **Metrics**: `/v1/{project_name}/metrics` - Resource usage metrics  ## Getting Started  ### Authentication  All API requests require authentication using the `X-API-Key` header. Most operations are scoped to specific projects/namespaces.  ### API Organization  The API is organized into logical groups: - **Public endpoints**: `/v1/*` - General access endpoints - **Project-scoped**: `/v1/{project_name}/*` - Project-specific resources - **Admin endpoints**: `/v1/admin/*` - Administrative operations  ### Documentation  Interactive documentation is available at `/docs` when the service is running. 

    The version of the OpenAPI document: 2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List
from si_tests.clients.gcore.box_api.models.schemas_parameter import SchemasParameter
from si_tests.clients.gcore.box_api.models.schemas_short_flavor import SchemasShortFlavor
from typing import Optional, Set
from typing_extensions import Self

class SchemasAppComponent(BaseModel):
    """
    SchemasAppComponent
    """ # noqa: E501
    description: StrictStr = Field(description="Description provides a summary of what the component does.")
    display_name: StrictStr = Field(description="DisplayName is the human-readable name of the component.")
    exposable: StrictBool = Field(description="Exposable indicates the possibility of creating a public endpoint for a component")
    license_url: StrictStr = Field(description="LicenseUrl is a URL pointing to the component's license information.")
    parameters: Dict[str, SchemasParameter] = Field(description="Parameters define the list of configurable parameters for the component.")
    readme: StrictStr = Field(description="Readme contains detailed documentation or usage instructions for the component.")
    required: StrictBool = Field(description="Required specifies whether the component is essential for the application to function. If Required is false, this component may be omitted in the application configuration")
    suitable_flavors: List[SchemasShortFlavor] = Field(description="SuitableFlavors lists the compatible flavors or configurations for this component.")
    __properties: ClassVar[List[str]] = ["description", "display_name", "exposable", "license_url", "parameters", "readme", "required", "suitable_flavors"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SchemasAppComponent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in parameters (dict)
        _field_dict = {}
        if self.parameters:
            for _key_parameters in self.parameters:
                if self.parameters[_key_parameters]:
                    _field_dict[_key_parameters] = self.parameters[_key_parameters].to_dict()
            _dict['parameters'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each item in suitable_flavors (list)
        _items = []
        if self.suitable_flavors:
            for _item_suitable_flavors in self.suitable_flavors:
                if _item_suitable_flavors:
                    _items.append(_item_suitable_flavors.to_dict())
            _dict['suitable_flavors'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SchemasAppComponent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "display_name": obj.get("display_name"),
            "exposable": obj.get("exposable"),
            "license_url": obj.get("license_url"),
            "parameters": dict(
                (_k, SchemasParameter.from_dict(_v))
                for _k, _v in obj["parameters"].items()
            )
            if obj.get("parameters") is not None
            else None,
            "readme": obj.get("readme"),
            "required": obj.get("required"),
            "suitable_flavors": [SchemasShortFlavor.from_dict(_item) for _item in obj["suitable_flavors"]] if obj.get("suitable_flavors") is not None else None
        })
        return _obj


