# SchemasParameter


## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**default_value** | **str** | DefaultValue specifies the default value assigned to the parameter if not provided. | 
**description** | **str** | Description field provides details about the purpose of the parameter. | 
**display_name** | **str** | DisplayName is the user-friendly name of the parameter. | 
**enum_values** | **List[str]** | EnumValues lists allowed values when Type is \&quot;enum\&quot;. | [optional] 
**max_value** | **str** | MaxValue applies to integer and float types. | [optional] 
**min_value** | **str** | MinValue applies to integer and float types. | [optional] 
**pattern** | **str** | Pattern enforces a regexp when Type is \&quot;string\&quot;. | [optional] 
**required** | **bool** | Required field indicates is parameter mandatory | 
**type** | [**SchemasParameterType**](SchemasParameterType.md) |  | [optional] 

## Example

```python
from si_tests.clients.gcore.box_api.models.schemas_parameter import SchemasParameter

# TODO update the JSON string below
json = "{}"
# create an instance of SchemasParameter from a JSON string
schemas_parameter_instance = SchemasParameter.from_json(json)
# print the JSON string representation of the object
print(SchemasParameter.to_json())

# convert the object into a dict
schemas_parameter_dict = schemas_parameter_instance.to_dict()
# create an instance of SchemasParameter from a dict
schemas_parameter_from_dict = SchemasParameter.from_dict(schemas_parameter_dict)
```
[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


