# coding: utf-8

"""
    Inference Box API

    ## Welcome to Inference Box API  A comprehensive REST API for managing cloud infrastructure resources including ML inference deployments, Kubernetes resources, and application lifecycle management.  ## Overview  Inference Box API is a cloud-native REST API service that provides unified access to manage:  - **ML Inference Deployments**: Create, manage, and scale machine learning inference services - **Slurm Clusters**: Deploy, configure, and manage HPC Slurm clusters for batch workloads - **Kubernetes Resources**: Manage namespaces (projects), pods, secrets, volumes, and other K8s resources - **Application Lifecycle**: Deploy and manage applications from catalog templates - **Resource Management**: Handle flavors, capacities, quotas, and node groups - **User & Access Control**: Manage users, groups, and API keys with RBAC integration - **Monitoring & Metrics**: Query metrics and monitor resource usage via Victoria Metrics  The service is built with Go and integrates with Kubernetes, HashiCorp Vault, and Victoria Metrics to provide a complete cloud infrastructure management solution.  ## Key API Endpoints  - **Inference**: `/v1/{project_name}/inferences` - ML inference deployment management - **Slurm Clusters**: `/v1/{project_name}/slurm/clusters` - Slurm cluster deployment and management - **Flavors**: `/v1/flavors` - Compute resource flavor definitions - **Users**: `/v1/admin/users` - User management (admin only) - **Projects**: `/v1/{project_name}` - Project-scoped resource operations - **Metrics**: `/v1/{project_name}/metrics` - Resource usage metrics  ## Getting Started  ### Authentication  All API requests require authentication using the `X-API-Key` header. Most operations are scoped to specific projects/namespaces.  ### API Organization  The API is organized into logical groups: - **Public endpoints**: `/v1/*` - General access endpoints - **Project-scoped**: `/v1/{project_name}/*` - Project-specific resources - **Admin endpoints**: `/v1/admin/*` - Administrative operations  ### Documentation  Interactive documentation is available at `/docs` when the service is running. 

    The version of the OpenAPI document: 2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr
from typing_extensions import Annotated
from si_tests.clients.gcore.box_api.models.v1_create_slurm_cluster_request import V1CreateSlurmClusterRequest
from si_tests.clients.gcore.box_api.models.v1_list_slurm_clusters_response import V1ListSlurmClustersResponse
from si_tests.clients.gcore.box_api.models.v1_patch_slurm_cluster_request import V1PatchSlurmClusterRequest
from si_tests.clients.gcore.box_api.models.v1_slurm_cluster_response import V1SlurmClusterResponse

from si_tests.clients.gcore.box_api.api_client import ApiClient, RequestSerialized
from si_tests.clients.gcore.box_api.api_response import ApiResponse
from si_tests.clients.gcore.box_api.rest import RESTResponseType


class SlurmApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def v1_create_slurm_cluster(
        self,
        project_name: Annotated[StrictStr, Field(description="Project name")],
        v1_create_slurm_cluster_request: Annotated[V1CreateSlurmClusterRequest, Field(description="Slurm cluster configuration")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V1SlurmClusterResponse:
        """Create Slurm cluster

        This endpoint creates a new Slurm cluster in the specified region within your project.  Slurm is an open source workload manager and job scheduler for Linux clusters. It provides job scheduling, resource allocation, and cluster management capabilities for batch processing and parallel computing workloads. Our platform uses the soperator (Slurm Operator) to manage Slurm clusters in Kubernetes environments.  Important limitations and requirements: - Only one Slurm cluster per region can be created in a project - Each cluster is identified by its region name rather than a separate cluster name - This limitation comes from soperator requiring the SlurmCluster resource name to equal the Kubernetes namespace name - Only core regions are supported for Slurm cluster deployments  Use this endpoint when you need to: - Set up a new high-performance computing environment for batch jobs - Create a dedicated cluster for machine learning training workloads - Establish a Slurm environment in a new region for your project  The created cluster will include essential Slurm components like the login nodes, controller nodes, and worker nodes, all managed by the soperator.  Note: The creation process may take several minutes to complete as the cluster components are provisioned and configured.

        :param project_name: Project name (required)
        :type project_name: str
        :param v1_create_slurm_cluster_request: Slurm cluster configuration (required)
        :type v1_create_slurm_cluster_request: V1CreateSlurmClusterRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_create_slurm_cluster_serialize(
            project_name=project_name,
            v1_create_slurm_cluster_request=v1_create_slurm_cluster_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1SlurmClusterResponse",
            '404': "ApiErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v1_create_slurm_cluster_with_http_info(
        self,
        project_name: Annotated[StrictStr, Field(description="Project name")],
        v1_create_slurm_cluster_request: Annotated[V1CreateSlurmClusterRequest, Field(description="Slurm cluster configuration")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V1SlurmClusterResponse]:
        """Create Slurm cluster

        This endpoint creates a new Slurm cluster in the specified region within your project.  Slurm is an open source workload manager and job scheduler for Linux clusters. It provides job scheduling, resource allocation, and cluster management capabilities for batch processing and parallel computing workloads. Our platform uses the soperator (Slurm Operator) to manage Slurm clusters in Kubernetes environments.  Important limitations and requirements: - Only one Slurm cluster per region can be created in a project - Each cluster is identified by its region name rather than a separate cluster name - This limitation comes from soperator requiring the SlurmCluster resource name to equal the Kubernetes namespace name - Only core regions are supported for Slurm cluster deployments  Use this endpoint when you need to: - Set up a new high-performance computing environment for batch jobs - Create a dedicated cluster for machine learning training workloads - Establish a Slurm environment in a new region for your project  The created cluster will include essential Slurm components like the login nodes, controller nodes, and worker nodes, all managed by the soperator.  Note: The creation process may take several minutes to complete as the cluster components are provisioned and configured.

        :param project_name: Project name (required)
        :type project_name: str
        :param v1_create_slurm_cluster_request: Slurm cluster configuration (required)
        :type v1_create_slurm_cluster_request: V1CreateSlurmClusterRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_create_slurm_cluster_serialize(
            project_name=project_name,
            v1_create_slurm_cluster_request=v1_create_slurm_cluster_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1SlurmClusterResponse",
            '404': "ApiErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v1_create_slurm_cluster_without_preload_content(
        self,
        project_name: Annotated[StrictStr, Field(description="Project name")],
        v1_create_slurm_cluster_request: Annotated[V1CreateSlurmClusterRequest, Field(description="Slurm cluster configuration")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create Slurm cluster

        This endpoint creates a new Slurm cluster in the specified region within your project.  Slurm is an open source workload manager and job scheduler for Linux clusters. It provides job scheduling, resource allocation, and cluster management capabilities for batch processing and parallel computing workloads. Our platform uses the soperator (Slurm Operator) to manage Slurm clusters in Kubernetes environments.  Important limitations and requirements: - Only one Slurm cluster per region can be created in a project - Each cluster is identified by its region name rather than a separate cluster name - This limitation comes from soperator requiring the SlurmCluster resource name to equal the Kubernetes namespace name - Only core regions are supported for Slurm cluster deployments  Use this endpoint when you need to: - Set up a new high-performance computing environment for batch jobs - Create a dedicated cluster for machine learning training workloads - Establish a Slurm environment in a new region for your project  The created cluster will include essential Slurm components like the login nodes, controller nodes, and worker nodes, all managed by the soperator.  Note: The creation process may take several minutes to complete as the cluster components are provisioned and configured.

        :param project_name: Project name (required)
        :type project_name: str
        :param v1_create_slurm_cluster_request: Slurm cluster configuration (required)
        :type v1_create_slurm_cluster_request: V1CreateSlurmClusterRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_create_slurm_cluster_serialize(
            project_name=project_name,
            v1_create_slurm_cluster_request=v1_create_slurm_cluster_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1SlurmClusterResponse",
            '404': "ApiErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v1_create_slurm_cluster_serialize(
        self,
        project_name,
        v1_create_slurm_cluster_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if project_name is not None:
            _path_params['project_name'] = project_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v1_create_slurm_cluster_request is not None:
            _body_params = v1_create_slurm_cluster_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/{project_name}/slurm/clusters',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v1_delete_slurm_cluster(
        self,
        project_name: Annotated[StrictStr, Field(description="Project name")],
        region_name: Annotated[StrictStr, Field(description="Region name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete Slurm cluster

        This endpoint permanently removes a Slurm cluster and all its associated resources from the specified region.  Slurm (Simple Linux Utility for Resource Management) is a workload manager and job scheduler for Linux clusters. It provides job scheduling, resource allocation, and cluster management capabilities for batch processing and parallel computing workloads. Our platform uses the soperator (Slurm Operator) to manage Slurm clusters in Kubernetes environments.  When you delete a Slurm cluster: - All running and queued jobs are terminated immediately - All cluster data and job history are permanently deleted - All resources associated with the cluster are released - The cluster is removed from the specified region  Use this endpoint when you need to: - Remove a Slurm cluster that is no longer needed - Free up compute resources and reduce costs - Clean up unused or obsolete cluster deployments - Decommission a cluster after completing your computational work  Warning: This operation cannot be undone. Ensure you have backed up any important data and that no critical jobs are running before deleting the cluster.

        :param project_name: Project name (required)
        :type project_name: str
        :param region_name: Region name (required)
        :type region_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_delete_slurm_cluster_serialize(
            project_name=project_name,
            region_name=region_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '404': "ApiErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v1_delete_slurm_cluster_with_http_info(
        self,
        project_name: Annotated[StrictStr, Field(description="Project name")],
        region_name: Annotated[StrictStr, Field(description="Region name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete Slurm cluster

        This endpoint permanently removes a Slurm cluster and all its associated resources from the specified region.  Slurm (Simple Linux Utility for Resource Management) is a workload manager and job scheduler for Linux clusters. It provides job scheduling, resource allocation, and cluster management capabilities for batch processing and parallel computing workloads. Our platform uses the soperator (Slurm Operator) to manage Slurm clusters in Kubernetes environments.  When you delete a Slurm cluster: - All running and queued jobs are terminated immediately - All cluster data and job history are permanently deleted - All resources associated with the cluster are released - The cluster is removed from the specified region  Use this endpoint when you need to: - Remove a Slurm cluster that is no longer needed - Free up compute resources and reduce costs - Clean up unused or obsolete cluster deployments - Decommission a cluster after completing your computational work  Warning: This operation cannot be undone. Ensure you have backed up any important data and that no critical jobs are running before deleting the cluster.

        :param project_name: Project name (required)
        :type project_name: str
        :param region_name: Region name (required)
        :type region_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_delete_slurm_cluster_serialize(
            project_name=project_name,
            region_name=region_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '404': "ApiErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v1_delete_slurm_cluster_without_preload_content(
        self,
        project_name: Annotated[StrictStr, Field(description="Project name")],
        region_name: Annotated[StrictStr, Field(description="Region name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete Slurm cluster

        This endpoint permanently removes a Slurm cluster and all its associated resources from the specified region.  Slurm (Simple Linux Utility for Resource Management) is a workload manager and job scheduler for Linux clusters. It provides job scheduling, resource allocation, and cluster management capabilities for batch processing and parallel computing workloads. Our platform uses the soperator (Slurm Operator) to manage Slurm clusters in Kubernetes environments.  When you delete a Slurm cluster: - All running and queued jobs are terminated immediately - All cluster data and job history are permanently deleted - All resources associated with the cluster are released - The cluster is removed from the specified region  Use this endpoint when you need to: - Remove a Slurm cluster that is no longer needed - Free up compute resources and reduce costs - Clean up unused or obsolete cluster deployments - Decommission a cluster after completing your computational work  Warning: This operation cannot be undone. Ensure you have backed up any important data and that no critical jobs are running before deleting the cluster.

        :param project_name: Project name (required)
        :type project_name: str
        :param region_name: Region name (required)
        :type region_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_delete_slurm_cluster_serialize(
            project_name=project_name,
            region_name=region_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '404': "ApiErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v1_delete_slurm_cluster_serialize(
        self,
        project_name,
        region_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if project_name is not None:
            _path_params['project_name'] = project_name
        if region_name is not None:
            _path_params['region_name'] = region_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/{project_name}/slurm/clusters/{region_name}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v1_get_slurm_cluster(
        self,
        project_name: Annotated[StrictStr, Field(description="Project name")],
        region_name: Annotated[StrictStr, Field(description="Region name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V1SlurmClusterResponse:
        """Get Slurm cluster

        This endpoint retrieves detailed information about a specific Slurm cluster in the given region.  Slurm is an open source workload manager and job scheduler for Linux clusters. It provides job scheduling, resource allocation, and cluster management capabilities for batch processing and parallel computing workloads. Our platform uses the soperator (Slurm Operator) to manage Slurm clusters in Kubernetes environments.  The response includes: - Cluster configuration details (region, creation time, status) - Login node configuration including SSH access details and authorized keys - Worker node configuration including flavor, size, and storage volume - Current cluster status and operational information  Use this endpoint when you need to: - Get detailed information about a specific Slurm cluster - Check the current status and configuration of your cluster - Retrieve SSH connection details for login nodes - View worker node specifications and resource allocations  Note: Since only one Slurm cluster per region can exist in a project (due to soperator requirements), this endpoint effectively returns the cluster for the specified region if it exists.

        :param project_name: Project name (required)
        :type project_name: str
        :param region_name: Region name (required)
        :type region_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_get_slurm_cluster_serialize(
            project_name=project_name,
            region_name=region_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1SlurmClusterResponse",
            '404': "ApiErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v1_get_slurm_cluster_with_http_info(
        self,
        project_name: Annotated[StrictStr, Field(description="Project name")],
        region_name: Annotated[StrictStr, Field(description="Region name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V1SlurmClusterResponse]:
        """Get Slurm cluster

        This endpoint retrieves detailed information about a specific Slurm cluster in the given region.  Slurm is an open source workload manager and job scheduler for Linux clusters. It provides job scheduling, resource allocation, and cluster management capabilities for batch processing and parallel computing workloads. Our platform uses the soperator (Slurm Operator) to manage Slurm clusters in Kubernetes environments.  The response includes: - Cluster configuration details (region, creation time, status) - Login node configuration including SSH access details and authorized keys - Worker node configuration including flavor, size, and storage volume - Current cluster status and operational information  Use this endpoint when you need to: - Get detailed information about a specific Slurm cluster - Check the current status and configuration of your cluster - Retrieve SSH connection details for login nodes - View worker node specifications and resource allocations  Note: Since only one Slurm cluster per region can exist in a project (due to soperator requirements), this endpoint effectively returns the cluster for the specified region if it exists.

        :param project_name: Project name (required)
        :type project_name: str
        :param region_name: Region name (required)
        :type region_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_get_slurm_cluster_serialize(
            project_name=project_name,
            region_name=region_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1SlurmClusterResponse",
            '404': "ApiErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v1_get_slurm_cluster_without_preload_content(
        self,
        project_name: Annotated[StrictStr, Field(description="Project name")],
        region_name: Annotated[StrictStr, Field(description="Region name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Slurm cluster

        This endpoint retrieves detailed information about a specific Slurm cluster in the given region.  Slurm is an open source workload manager and job scheduler for Linux clusters. It provides job scheduling, resource allocation, and cluster management capabilities for batch processing and parallel computing workloads. Our platform uses the soperator (Slurm Operator) to manage Slurm clusters in Kubernetes environments.  The response includes: - Cluster configuration details (region, creation time, status) - Login node configuration including SSH access details and authorized keys - Worker node configuration including flavor, size, and storage volume - Current cluster status and operational information  Use this endpoint when you need to: - Get detailed information about a specific Slurm cluster - Check the current status and configuration of your cluster - Retrieve SSH connection details for login nodes - View worker node specifications and resource allocations  Note: Since only one Slurm cluster per region can exist in a project (due to soperator requirements), this endpoint effectively returns the cluster for the specified region if it exists.

        :param project_name: Project name (required)
        :type project_name: str
        :param region_name: Region name (required)
        :type region_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_get_slurm_cluster_serialize(
            project_name=project_name,
            region_name=region_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1SlurmClusterResponse",
            '404': "ApiErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v1_get_slurm_cluster_serialize(
        self,
        project_name,
        region_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if project_name is not None:
            _path_params['project_name'] = project_name
        if region_name is not None:
            _path_params['region_name'] = region_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/{project_name}/slurm/clusters/{region_name}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v1_list_slurm_clusters(
        self,
        project_name: Annotated[StrictStr, Field(description="Project name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V1ListSlurmClustersResponse:
        """List Slurm clusters

        This endpoint retrieves all Slurm clusters in the project across all regions.  Slurm is an open source workload manager and job scheduler for Linux clusters. It provides job scheduling, resource allocation, and cluster management capabilities for batch processing and parallel computing workloads. Our platform uses the soperator (Slurm Operator) to manage Slurm clusters in Kubernetes environments.  Use this endpoint when you need to: - Get an overview of all Slurm clusters in your project - Monitor the status of your clusters across regions - View cluster configurations and resource allocations

        :param project_name: Project name (required)
        :type project_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_list_slurm_clusters_serialize(
            project_name=project_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1ListSlurmClustersResponse",
            '404': "ApiErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v1_list_slurm_clusters_with_http_info(
        self,
        project_name: Annotated[StrictStr, Field(description="Project name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V1ListSlurmClustersResponse]:
        """List Slurm clusters

        This endpoint retrieves all Slurm clusters in the project across all regions.  Slurm is an open source workload manager and job scheduler for Linux clusters. It provides job scheduling, resource allocation, and cluster management capabilities for batch processing and parallel computing workloads. Our platform uses the soperator (Slurm Operator) to manage Slurm clusters in Kubernetes environments.  Use this endpoint when you need to: - Get an overview of all Slurm clusters in your project - Monitor the status of your clusters across regions - View cluster configurations and resource allocations

        :param project_name: Project name (required)
        :type project_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_list_slurm_clusters_serialize(
            project_name=project_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1ListSlurmClustersResponse",
            '404': "ApiErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v1_list_slurm_clusters_without_preload_content(
        self,
        project_name: Annotated[StrictStr, Field(description="Project name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List Slurm clusters

        This endpoint retrieves all Slurm clusters in the project across all regions.  Slurm is an open source workload manager and job scheduler for Linux clusters. It provides job scheduling, resource allocation, and cluster management capabilities for batch processing and parallel computing workloads. Our platform uses the soperator (Slurm Operator) to manage Slurm clusters in Kubernetes environments.  Use this endpoint when you need to: - Get an overview of all Slurm clusters in your project - Monitor the status of your clusters across regions - View cluster configurations and resource allocations

        :param project_name: Project name (required)
        :type project_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_list_slurm_clusters_serialize(
            project_name=project_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1ListSlurmClustersResponse",
            '404': "ApiErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v1_list_slurm_clusters_serialize(
        self,
        project_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if project_name is not None:
            _path_params['project_name'] = project_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/{project_name}/slurm/clusters',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v1_update_slurm_cluster(
        self,
        project_name: Annotated[StrictStr, Field(description="Project name")],
        region_name: Annotated[StrictStr, Field(description="Region name")],
        v1_patch_slurm_cluster_request: Annotated[V1PatchSlurmClusterRequest, Field(description="Update Slurm cluster configuration")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V1SlurmClusterResponse:
        """Update Slurm cluster

        This endpoint allows you to modify the configuration of an existing Slurm cluster.  Slurm is an open source workload manager and job scheduler for Linux clusters. It provides job scheduling, resource allocation, and cluster management capabilities for batch processing and parallel computing workloads. Our platform uses the soperator (Slurm Operator) to manage Slurm clusters in Kubernetes environments.  Use this endpoint when you need to: - Scale your cluster up to handle increased workload - Scale your cluster down to reduce resource usage and costs  Note: The system will validate that sufficient capacity exists for scaling up.

        :param project_name: Project name (required)
        :type project_name: str
        :param region_name: Region name (required)
        :type region_name: str
        :param v1_patch_slurm_cluster_request: Update Slurm cluster configuration (required)
        :type v1_patch_slurm_cluster_request: V1PatchSlurmClusterRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_update_slurm_cluster_serialize(
            project_name=project_name,
            region_name=region_name,
            v1_patch_slurm_cluster_request=v1_patch_slurm_cluster_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1SlurmClusterResponse",
            '404': "ApiErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v1_update_slurm_cluster_with_http_info(
        self,
        project_name: Annotated[StrictStr, Field(description="Project name")],
        region_name: Annotated[StrictStr, Field(description="Region name")],
        v1_patch_slurm_cluster_request: Annotated[V1PatchSlurmClusterRequest, Field(description="Update Slurm cluster configuration")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V1SlurmClusterResponse]:
        """Update Slurm cluster

        This endpoint allows you to modify the configuration of an existing Slurm cluster.  Slurm is an open source workload manager and job scheduler for Linux clusters. It provides job scheduling, resource allocation, and cluster management capabilities for batch processing and parallel computing workloads. Our platform uses the soperator (Slurm Operator) to manage Slurm clusters in Kubernetes environments.  Use this endpoint when you need to: - Scale your cluster up to handle increased workload - Scale your cluster down to reduce resource usage and costs  Note: The system will validate that sufficient capacity exists for scaling up.

        :param project_name: Project name (required)
        :type project_name: str
        :param region_name: Region name (required)
        :type region_name: str
        :param v1_patch_slurm_cluster_request: Update Slurm cluster configuration (required)
        :type v1_patch_slurm_cluster_request: V1PatchSlurmClusterRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_update_slurm_cluster_serialize(
            project_name=project_name,
            region_name=region_name,
            v1_patch_slurm_cluster_request=v1_patch_slurm_cluster_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1SlurmClusterResponse",
            '404': "ApiErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v1_update_slurm_cluster_without_preload_content(
        self,
        project_name: Annotated[StrictStr, Field(description="Project name")],
        region_name: Annotated[StrictStr, Field(description="Region name")],
        v1_patch_slurm_cluster_request: Annotated[V1PatchSlurmClusterRequest, Field(description="Update Slurm cluster configuration")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update Slurm cluster

        This endpoint allows you to modify the configuration of an existing Slurm cluster.  Slurm is an open source workload manager and job scheduler for Linux clusters. It provides job scheduling, resource allocation, and cluster management capabilities for batch processing and parallel computing workloads. Our platform uses the soperator (Slurm Operator) to manage Slurm clusters in Kubernetes environments.  Use this endpoint when you need to: - Scale your cluster up to handle increased workload - Scale your cluster down to reduce resource usage and costs  Note: The system will validate that sufficient capacity exists for scaling up.

        :param project_name: Project name (required)
        :type project_name: str
        :param region_name: Region name (required)
        :type region_name: str
        :param v1_patch_slurm_cluster_request: Update Slurm cluster configuration (required)
        :type v1_patch_slurm_cluster_request: V1PatchSlurmClusterRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_update_slurm_cluster_serialize(
            project_name=project_name,
            region_name=region_name,
            v1_patch_slurm_cluster_request=v1_patch_slurm_cluster_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1SlurmClusterResponse",
            '404': "ApiErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v1_update_slurm_cluster_serialize(
        self,
        project_name,
        region_name,
        v1_patch_slurm_cluster_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if project_name is not None:
            _path_params['project_name'] = project_name
        if region_name is not None:
            _path_params['region_name'] = region_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v1_patch_slurm_cluster_request is not None:
            _body_params = v1_patch_slurm_cluster_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/v1/{project_name}/slurm/clusters/{region_name}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


