import os
import pytest

from si_tests import settings
from si_tests import logger
import si_tests.utils.waiters as helpers

LOG = logger.logger


@pytest.mark.parametrize("_", ["CLUSTER_NAME={0}"
                               .format(settings.TARGET_CLUSTER)])
@pytest.mark.usefixtures("store_cluster_description")
def test_hpa(target_kubectl, hpa_prerequisites, _):
    deployment_name = "si-tests-hpa-{}".format(settings.TARGET_CLUSTER)

    helpers.wait(lambda: os.system(
        'curl --data "millicores=300&durationSec=75" '
        'http://{}:8080/ConsumeCPU'.format(
            hpa_prerequisites["lb_address"])) == 0,
                 timeout=450, interval=30,
                 timeout_msg='Cannot access {}'.format(
                     hpa_prerequisites["lb_address"]))

    LOG.info("Waiting for pods (must be 2)")
    helpers.wait(lambda: len(target_kubectl.pods.list_starts_with(
        deployment_name, 'default')) == 2,
                 timeout=300, interval=15,
                 timeout_msg='Timeout waiting for number of pods to be 2. '
                             'Actual: {}'.format(
                     len(target_kubectl.pods.list_starts_with(
                         deployment_name, 'default'))))

    LOG.info("Waiting for pods (must be only 1)")
    helpers.wait(lambda: len(target_kubectl.pods.list_starts_with(
        deployment_name, 'default')) == 1,
                 timeout=800, interval=15,
                 timeout_msg='Timeout waiting for number of pods to be 1. '
                             'Actual: {}'.format(
                     len(target_kubectl.pods.list_starts_with(
                         deployment_name, 'default'))))


@pytest.mark.parametrize("_", ["CLUSTER_NAME={0}"
                               .format(settings.TARGET_CLUSTER)])
@pytest.mark.usefixtures("store_cluster_description")
def test_top_hpa(target_kubectl, _):
    if len(target_kubectl.pods.list_starts_with(
            'metrics-server', 'kube-system')) == 0:
        msg = "metrics-server is not found. Skipping"
        LOG.warning(msg)
        pytest.skip(msg)
    helm_controllers = target_kubectl.pods.list_starts_with('helm-controller-')
    for helm_controller in helm_controllers:
        LOG.info(f"Checking helm-controller: {helm_controller.name}")
        metrics = target_kubectl.api_custom.get_namespaced_custom_object(
            'metrics.k8s.io', 'v1beta1', 'kube-system', 'pods', helm_controller.name
        )
        assert metrics is not None, \
            f"No metrics found for {helm_controller.name}"
        assert metrics['apiVersion'] == 'metrics.k8s.io/v1beta1', \
            "Wrong apiVersion."
        assert metrics['metadata']['name'] == helm_controller.name, \
            "Metrics returned for unexpected pod."
        assert {x for x in
                metrics['containers'][0]['usage'].keys()} == {'cpu', 'memory'}, \
            "Wrong metrics returned."
