from socket import timeout as socket_timeout

from retry import retry
from si_tests import logger
import pyipmi
import pyipmi.interfaces

LOG = logger.logger


class IpmiManager(object):
    """Ipmi manager"""

    def interface(self, ipmi_host='', ipmi_user='', ipmi_password='', ipmi_port=623):
        def establish_session(_ipmi, _ipmi_host='', _ipmi_user='',
                              _ipmi_password='', _ipmi_port=623):
            _ipmi.session.set_session_type_rmcp(host=_ipmi_host, port=_ipmi_port)
            _ipmi.session.set_auth_type_user(username=_ipmi_user,
                                             password=_ipmi_password)
            _ipmi.session.establish()
            return _ipmi

        try:

            interface = \
                pyipmi.interfaces.create_interface(interface='rmcp',
                                                   slave_address=0x81,
                                                   host_target_address=0x20)
            ipmi = pyipmi.create_connection(interface)
            ipmi.target = pyipmi.Target(ipmb_address=0x20)
            establish_session(ipmi, ipmi_host, ipmi_user, ipmi_password, ipmi_port)
        # FIXME(alexz): socket.timeout - is not an proper fix, but
        # WA-d for vbmcd endpoints check. For proper fix, need to debug deeply to
        # find exact AT commands to pass out. Most probably, issue in target ipmb_address, or any other magic.
        # in same time ipmitool do it for us.
        except (pyipmi.errors.CompletionCodeError, socket_timeout) as ex:
            LOG.error(ex)
            interface = \
                pyipmi.interfaces.create_interface(interface='ipmitool',
                                                   interface_type='lanplus')
            ipmi = pyipmi.create_connection(interface)
            ipmi.target = pyipmi.Target(ipmb_address=0x20)
            establish_session(ipmi, ipmi_host, ipmi_user, ipmi_password, ipmi_port)
        finally:
            return ipmi

    @retry(Exception, delay=5, tries=5, logger=LOG)
    def get_power_on(self, ipmi_host='', ipmi_user='', ipmi_password='', ipmi_port=623):
        """
        Host power is on?
        return True or False
        """
        LOG.debug(f'check ipmi chassis status for {ipmi_host}:{ipmi_port}')
        ipmi = self.interface(ipmi_host, ipmi_user, ipmi_password, ipmi_port)
        chassis_status = ipmi.get_chassis_status()
        return chassis_status.power_on

    @retry(Exception, delay=5, tries=5, logger=LOG)
    def set_power_off(self, ipmi_host='', ipmi_user='', ipmi_password='', ipmi_port=623):
        """
        Hard type machine power off
        """
        ipmi = self.interface(ipmi_host, ipmi_user, ipmi_password, ipmi_port)
        return ipmi.chassis_control_power_down()

    @retry(Exception, delay=5, tries=5, logger=LOG)
    def set_power_on(self, ipmi_host='', ipmi_user='', ipmi_password='', ipmi_port=623):
        """
        Power on the machine
        """
        ipmi = self.interface(ipmi_host, ipmi_user, ipmi_password, ipmi_port)
        return ipmi.chassis_control_power_up()

    @retry(Exception, delay=5, tries=5, logger=LOG)
    def set_power_reset(self, ipmi_host='', ipmi_user='', ipmi_password='', ipmi_port=623):
        """
        Machine power reset
        """
        ipmi = self.interface(ipmi_host, ipmi_user, ipmi_password, ipmi_port)
        return ipmi.chassis_control_hard_reset()
