#!/usr/bin/env bash

echo 'set_power'

#phys-1490	KaaS Management cluster
#	cz7789
#	cz7916
#	cz10143
#	Managed cluster - control plane
#	cz7700
#	cz7741
#	cz7743
#	Managed cluster - worker/storage
#	cz812
#	cz813
#	cz814
#	cz815

declare -A nodes_pw
nodes_pw=(\
[cz7789]='PM3dqFFwe3fe' \
[cz7916]='dWO5DqsaGNF' \
[cz10143]='dWO5DqsaGNF' \
[cz7700]='cAoTuVfEPPsx' \
[cz7741]='cAoTuVfEPPsx' \
[cz7743]='cAoTuVfEPPsx' \
[cz812]='cAoTuVfEPPsx' \
[cz813]='cAoTuVfEPPsx' \
[cz814]='cAoTuVfEPPsx' \
[cz815]='cAoTuVfEPPsx' \
)

function set_power(){
  local action="${1:-'chassis power status'}"
  local nset=${2:-'all'}
  declare -A nodes=();
  declare -A nodes_child=();
  declare -A nodes_mgmt=();

  nodes_child=([cz812]='176.74.219.182' [cz813]='176.74.219.183' \
               [cz814]='176.74.219.184' [cz815]='176.74.219.185' \
               [cz7700]='5.43.225.12' [cz7741]='5.43.225.76' [cz7743]='5.43.225.78' )

  nodes_mgmt=( [cz7789]='5.43.225.125' [cz10143]='5.43.229.116' \
               [cz7916]='188.124.60.41' )
  # awesome merge event...
  case "$nset" in
      'mgmt')
        for i in ${!nodes_mgmt[@]}; do
            nodes[$i]="${nodes_mgmt[$i]}"
        done
      ;;
      'child')
        for i in ${!nodes_child[@]}; do
            nodes[$i]="${nodes_child[$i]}"
        done
      ;;
      'all')
        for i in ${!nodes_child[@]}; do
            nodes[$i]="${nodes_child[$i]}"
        done
        for i in ${!nodes_mgmt[@]}; do
            nodes[$i]="${nodes_mgmt[$i]}"
        done
      ;;
  esac

  for i in "${!nodes[@]}"; do
    echo "node: $i"
    set -xe
    ipmitool -I lanplus -H ${nodes[$i]} -U engineer -P "${nodes_pw[$i]}" $action
    set +xe
  done
 }

