#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

import ipaddress
from si_tests import logger

LOG = logger.logger


def convert_heat_stack_data_to_os_env(data) -> dict:
    """
    Logical convert phys data from heat stack, to suitable for kaas/templates jinja variables.
    """
    # hardcodes across heat template/bmh/env data
    pxe_network_id = 'vm_subnet2'
    mgmt_node_id = 'gr1_instance'
    child_master_node_id = 'gr2_instance'
    child_worker_node_id = 'gr3_instance'
    #
    result = dict()
    pxe_cidr = [nw['cidr'] for nw in data['subnets'] if nw['logical_resource_id'] == pxe_network_id][0]
    pxe_cidr_nw = ipaddress.ip_network(pxe_cidr)
    LOG.info(f"pxe_network_id={pxe_network_id} => pxe_cidr={pxe_cidr}")
    gr1_nodes = [node for node in data['nodes'] if node['logical_resource_id'] == mgmt_node_id]
    gr2_nodes = [node for node in data['nodes'] if node['logical_resource_id'] == child_master_node_id]
    gr3_nodes = [node for node in data['nodes'] if node['logical_resource_id'] == child_worker_node_id]
    all_nodes = sorted(gr1_nodes, key=lambda x: x['name']) + sorted(gr2_nodes, key=lambda x: x['name']) + sorted(
        gr3_nodes, key=lambda x: x['name'])
    result['BM_MACHINE_COUNT'] = str(len(all_nodes))
    # don't fix start index, its hardcoded across all old templates\ansible
    for idx, node in enumerate(all_nodes, start=0):
        # WARNING(alexz): for now, we assume one network, and few nics on it.
        # in case update - need to update converter
        mac = [
            entry['OS-EXT-IPS-MAC:mac_addr']
            for values in node['addresses'].values()
            for entry in values
            if ipaddress.ip_address(entry['addr']) in pxe_cidr_nw
        ][0]
        LOG.info(f"openstack node: {node['name']}  PXE-mac: {mac} ")
        result.update({f'BM_MACHINE_{idx}_OPENSTACK_UUID': str(node['server_id']),
                       f'BM_MACHINE_{idx}_VBMC_PORT': str(int(6231 + idx)),
                       f'IRONIC_DHCP_MACHINE_{idx}_MAC': str(mac),
                       f'IPMI_MACHINE_{idx}_BMC_ADDRESS': f'0.0.0.0:{str(int(6231 + idx))}',
                       f'IPMI_MACHINE_{idx}_PASSWORD': 'cjAwdG1l',  # r00tme
                       f'IPMI_MACHINE_{idx}_USERNAME': 'YWRtaW4=',  # admin
                       })
    LOG.debug(f'convert_heat_stack_data_to_os_env result: {result}')
    return result
