import pytest

from si_tests.deployments.deploy_refapp import Refapp
from si_tests.utils.workload_report import VMWorkloadDowntimeReport
from si_tests.lcm import openstack_lcm
from si_tests import settings


@pytest.mark.usefixtures('mos_workload_downtime_report')
@pytest.mark.usefixtures('mos_loadtest_os_refapp')  # Should be used if ALLOW_WORKLOAD == True
@pytest.mark.usefixtures('mos_per_node_workload_check_after_test')
@pytest.mark.usefixtures('introspect_no_PRODX_51933_after_lcm')
def test_openstack_upgrade_simple(os_manager, openstack_client_manager):
    """Test is used on BM environments, incompatible with virtual environments.
       Upgrade OS version.
       Parameters required for test execution:
         - KUBECONFIG
         - OPENSTACK_UPGRADE_VERSION
    """

    openstack_lcm.upgrade_openstack(os_manager, openstack_client_manager)


def test_openstack_upgrade_simple_vm(os_manager, openstack_client_manager):
    """Upgrade OS version.
       Parameters required for test execution:
         - KUBECONFIG
         - OPENSTACK_UPGRADE_VERSION
    """

    openstack_lcm.upgrade_openstack(os_manager, openstack_client_manager)


@pytest.mark.usefixtures("mos_per_node_workload_check_after_test")
def test_openstack_upgrade_with_refapp(os_manager,
                                       openstack_client_manager,
                                       func_name):
    """Upgrade Openstack with refapp tests. Test can be run only on vms.
    1) Deploy RefApp
    2) Check RefApp workability before update
    3) Upgrade OpenStack to the new version
    4) Check RefApp workability after update
    5) Delete RefApp

       Parameters required for test execution:
         - KUBECONFIG
         - OSH_OPERATOR_UPDATE_REPO
         - OSH_OPERATOR_UPDATE_TAG
         - OSH_OPERATOR_CHART_URL
         - OSH_OPERATOR_CHART_VERSION
    """

    refapp = Refapp(openstack_client_manager)
    try:
        refapp.deploy()
        refapp.check()
        with VMWorkloadDowntimeReport(func_name, 'mos'):
            openstack_lcm.upgrade_openstack(os_manager, openstack_client_manager)
        refapp.check()
    except Exception:
        if (settings.OPENSTACK_COLLECT_REFAPP_MODE.lower() == "on_error"):
            refapp.collect_logs()
        raise
    finally:
        if (settings.OPENSTACK_COLLECT_REFAPP_MODE.lower() == "always"):
            refapp.collect_logs()
        refapp.delete()
