#    Copyright 2019 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.
import yaml

from collections import defaultdict
from itertools import groupby

from si_tests import logger

LOG = logger.logger


def test_entrypoints_are_unique(openstack_client_manager, show_step):
    """Checks consistency of openstack endpoints
    Scenario:
        1. Get service endpoints from keystone-client
        2. Check that each combination of service and interface contains only one endpoint
    """
    found_duplicates = defaultdict()
    endpoints = openstack_client_manager.endpoint.list([])

    # Group endpoints by service_id and interface type
    def get_sort_keys(e):
        return e.get("Service Type"), e.get("Interface"), str(e.get("Region"))

    endpoints = sorted(endpoints, key=get_sort_keys)
    for key, _endpoints in groupby(endpoints, key=get_sort_keys):
        _endpoints = list(_endpoints)

        # And each group should contain 1 endpoint
        if len(_endpoints) > 1:
            found_duplicates[str(key)] = _endpoints

    assert not found_duplicates, \
        (f"Found problems in 'openstack endpoint list' \n "
         f"{yaml.dump(found_duplicates)}")
