locals {
  managers = [
    for host in module.managers.machines : {
      role = "manager"
      ssh  = {
        address = host.default_ip_address
        user    = var.ssh_username
        keyPath = "./ssh_keys/${var.cluster_name}.pem"
      }
    }
  ]
  workers = [
    for host in module.workers.machines : {
      role = "worker"
      ssh  = {
        address = host.default_ip_address
        user    = var.ssh_username
        keyPath = "./ssh_keys/${var.cluster_name}.pem"
      }
    }
  ]
  mke_launchpad_tmpl = {
    apiVersion = "launchpad.mirantis.com/mke/v1.3"
    kind       = "mke"
    metadata   = {
      name = "launchpad-mke"
    }
    spec = {
      mke = {
        adminUsername = var.mke_admin_username
        adminPassword = var.mke_admin_password
        version       = var.mke_version
        imageRepo     = var.mke_repo
        installFlags : [
          "--default-node-orchestrator=kubernetes",
          "--san=${module.managers.machines[0].default_ip_address}",
          "--cloud-provider=vsphere"
        ]
        cloud = {
          provider = "vsphere"
        }
      }
      mcr = {
        version = var.mcr_version
        channel = var.mcr_channel
        repoURL = var.mcr_repo
      }
      hosts = concat(local.managers, local.workers) #, local.windows_workers)
    }
  }
  launchpad_tmpl = local.mke_launchpad_tmpl
}

output "launchpad_config" {
  value = yamlencode(local.launchpad_tmpl)
}

output "cluster_config" {
  value = {
    mke_lb_dns_name = module.managers.machines[0].default_ip_address,
    mke_username    = var.mke_admin_username,
    mke_password    = var.mke_admin_password,
    ssh_username    = var.ssh_username,
    cloud_provider  = "vsphere"
  }
}
