locals {
  managers           = [
  for ip in module.masters.public_ips : {
    ssh : {
      address = ip
      user    = var.ssh_username
      keyPath = "./ssh_keys/${var.cluster_name}.pem"
      port    = 22
    }
    role = "manager"
  }
  ]
  workers            = [
  for ip in module.workers.public_ips : {
    ssh : {
      address = ip
      user    = var.ssh_username
      keyPath = "./ssh_keys/${var.cluster_name}.pem"
      port    = 22
    }
    role = "worker"
  }
  ]
  msr_launchpad_tmpl = {
    apiVersion = "launchpad.mirantis.com/mke/v1.3"
    kind       = "mke"
    metadata   = {
      name = "launchpad-mke"
    }
    spec       = {
      mke   = {
        version       = var.mke_version
        imageRepo     = var.mke_repo
        adminUsername = var.mke_username
        adminPassword = random_string.password.result
        installFlags : [
          "--default-node-orchestrator=kubernetes",
          "--san=${module.masters.lb_ip}",
        ]
        cloud         = {
          provider   = "external"
          configFile = var.provider_config_file_path
        }
      }
      mcr   = {
        version = var.mcr_version
        channel = var.mcr_channel
        repoURL = var.mcr_repo
      }
      hosts = concat(local.managers, local.workers)
    }
  }
  mke_launchpad_tmpl = {
    apiVersion = "launchpad.mirantis.com/mke/v1.3"
    kind       = "mke"
    metadata   = {
      name = "launchpad-mke"
    }
    spec       = {
      mke   = {
        version       = var.mke_version
        imageRepo     = var.mke_repo
        adminUsername = var.mke_username
        adminPassword = random_string.password.result
        installFlags : [
          "--default-node-orchestrator=kubernetes",
          "--san=${module.masters.lb_ip}",
        ]
        cloud         = {
          provider   = "external"
          configFile = var.provider_config_file_path
        }
      }
      mcr   = {
        version = var.mcr_version
        channel = var.mcr_channel
        repoURL = var.mcr_repo
      }
      hosts = concat(local.managers, local.workers)
    }
  }
  launchpad_tmpl     = var.msr_count > 0 ? local.msr_launchpad_tmpl : local.mke_launchpad_tmpl
}

output "launchpad_config" {
  value = yamlencode(local.launchpad_tmpl)
}

output "cluster_config" {
  value = {
    mke_lb_dns_name = module.masters.lb_ip,
    mke_username    = var.mke_username,
    mke_password    = random_string.password.result,
    ssh_username    = var.ssh_username
    cloud_provider  = "openstack"
  }
}
