This directory holds configurations for various lab environments. It includes
configurations for both hardware and virtual (and half-virtual) labs.

# Hardware labs

TBD

# Virtual labs

Virtual lab environments require L2 / L3 network layout configuration defined
in inventory files. Such configuration includes configurations for the
following components:
* Uplink bridge
* Virtual "top of rack" bridge
* Seed network
* L2 segments connected to virtual machines
* L3 configuration for those segments

The schemas shown below represent how these components are connected with each
other.

'uplink bridge' is simply a bridge that holds machine IP address and is used as
intermediate bridge to simplify configuration.

'TOR bridge' is a bridge to which all other bridges that are used to provide
separate L2 segments are connected to. Connection between 'L2 segment' bridge
and 'TOR bridge' could be either direct (veth) or via VLAN interface to
provide isolation. 'TOR bridge' could be connected to 'uplink bridge' either
directly or via VLAN or VxLAN interface. VLANs are used to isolate L2 segments
from each other. VxLAN is used in full-virtual env when it is required
to create L2 segments across multiple hypervisor hosts.

```text
                             +-----------+
                          +--| interface |--+
                          |  +-----------+  |
                          |                 |
                          |  uplink bridge  |
                          +--------#--------+
                                   |
         +--------------+   +------#-------+
         | Seed network |   |  TOR bridge  |
         +-#----------#-+   +-#----------#-+
           |          |       |          |
  +--------#---+    +-#-------#---+   +--#-----------+
  |    KIND    |    | L2` segment |   | L2`` segment |
  |   cluster  |    +--+-------+--+   +--+-----+-----+
  +------------+       |       |         |     |
                       |    +--|---------+     |
                       |    |  |               |
                       |    |  +----------+    |
                       |    |             |    |
                    +--+----+----+    +---+----+----+
                    | pxe  net1  |    |  pxe  net1  |
                    |            |    |             |
                    |    VM1     |    |    VM2      |
                    +------------+    +-------------+
```

Multi-rack is also supported, in this case each L2 segment will be presented
by N different bridges where N is rack count. Suffix `-r<ID>` will be added to
bridge's 'real' name to indicate that it belongs to a rack with ID `<ID>`.

To support PXE boot in multi-rack configuration DHCP Relay could be configured
for L2 segments that are expected to support PXE.

```text
                                      +-----------+
                                   +--| interface |--+
                                   |  +-----------+  |
                                   |                 |
                                   |  uplink bridge  |
                                   +--------#--------+
                                            |
         +---------------+           +------#------+
         | Seed network  |           | TOR bridge  |
         +-#------+------+           +-#----#----#-+
           |      |                    |    |    |
           |      |        +-----------+    |    +-----------+
           |      |        |                |                |
 +---------#---+  |  +-----#------+   +-----#------+   +-----#------+
 |    KIND     |  |  | L2 / Rack0 |   | L2 / Rack1 |   | L2 / Rack2 |
 |   cluster   |  |  +----+----+--+   +---+-----+--+   +--#------#--+
 +-------------+  |       |    |          |     |         |      |
                  |       |    |          |     |         |      |
    +-------------+       |    |          |     |         |      |
    |   +-----------------|----|----------+     |         |      |
    |   |   +-------------|----|----------------|---------+      |
    |   |   |           +-|----|----------------+                |
    |   |   |           | |    |          +----------------------+
    |   |   |           | +----|----------|-----+
    |   |   |           |      |          |     |
 +--+---+---+--+     +--+------+--+   +---+-----+--+
 |    DHCP     |     |  pxe  net1 |   |  pxe  net1 |
 |    Relay    |     |            |   |            |
 |  namespace  |     |    VM1     |   |    VM2     |
 +-------------+     +------------+   +------------+
```

Alternative lab configuration with DHCP Relays in per-rack top-of-rack
namespaces.

```text
                                      +-----------+
                                   +--| interface |--+
                                   |  +-----------+  |
           +-----------------NAT--->                 |
           |             +---NAT--->  uplink bridge  |
           |             |         +--------#--------+
           |             |                  |
 +---------*----+        |           +------#------+
 | Seed network <--NAT---+           | TOR bridge  |
 +---------*----+        |           +-#----#----#-+
           |      +------+             |    |    |
           |      |        +-----------+    |    +-----------+
           |      |        |                |                |
 +---------*---+  |  +-----#------+   +-----#------+   +-----#------+
 |    KIND     |  |  |   Rack0    |   |   Rack1    |   |   Rack2    |
 |   cluster   |  |  |            |   | DHCP Relay |   | DHCP Relay |
 +-------------+  |  +-*---*---*--+   +---*-----*--+   +--*------*--+
                  |    |   |   |          |     |         |      |
 +-------------+  |    |   |   |          |     |         |      |
 |             *--+    |   |   |          |     |         |      |
 |   "spine"   *-------+   |   |          |     |         |      |
 |  namespace  *-----------|---|----------+     |         |      |
 |             *-----------|---|----------------|---------+      |
 +-------------+        +--|---|----------------+                |
                        |  |   |          +----------------------+
                        |  +---|----------|-----+
                        |      |          |     |
                     +--*------*--+   +---*-----*--+
                     |  pxe  net1 |   |  pxe  net1 |
                     |            |   |            |
                     |    VM1     |   |    VM2     |
                     +------------+   +------------+
```

### Examples

#### Single rack

```yaml
uplink_bridge: br0
tor_network:
  name: tor
  uplink:
    - bridge: "{{ uplink_bridge }}"
      vxlan_id: 10
seed_network:
  name: seed
  device_name: br-seed
  cidr: 10.0.1.0/24
  addresses:
    - 10.0.1.1/24
  forwarding:
    - lookup: "{{ uplink_bridge }}"
      masquerade: yes
  uplink:
    - lookup: pxe/0
l2_rack_id: 0
l2_layout:
  - rack_id: 0
    networks:
      - name: pxe
        uplink:
          - lookup: tor/0
            vlan_id: 20
      - name: net1
        uplink:
          - lookup: tor/0
            vlan_id: 12
```

#### Multirack with DHCP Relay

```yaml
uplink_bridge: br0
tor_network:
  name: tor
  uplink:
    - bridge: "{{ uplink_bridge }}"
      vxlan_id: 10
seed_network:
  name: seed
  device_name: br-seed
  cidr: 10.0.1.0/24
  addresses:
    - 10.0.1.1/24
  forwarding:
    - lookup: "{{ uplink_bridge }}"
      masquerade: yes
l2_rack_id: 0
l2_layout:
  - rack_id: 0
    networks:
      - name: net1
        uplink:
          - lookup: tor/0
            vlan_id: 12
  - rack_id: 1
    networks:
      - name: pxe
        addresses:
          - 10.0.21.1/24
        uplink:
          - lookup: tor/0
            vlan_id: 21
  - rack_id: 2
    networks:
      - name: pxe
        addresses:
          - 10.0.22.1/24
        uplink:
          - lookup: tor/0
            vlan_id: 22
l3_dhcp_relay:
  netns_name: dhcrelay
  servers:
    - 10.0.1.20
    - 10.0.21.50
    - 10.0.21.51
    - 10.0.21.52
  interfaces:
    - lookup: seed/0
      address: 10.0.1.2/24
    - lookup: pxe/1
      address: 10.0.21.2/24
    - lookup: pxe/2
      address: 10.0.22.2/24
```

## Uplink bridge configuration

`uplink_bridge` sets uplink bridge name that will be used in Ansible scripts.
This option does not set the name of a real bridge as this is done before
Ansible tasks were run. But this name used in some tasks so that's the way to
have if configurable.

### Example

```yaml
uplink_bridge: br0
uplink_bridge_opts:
   masquerade: <masquerade outgoing packets>
```
 
* `masquerade` option enables masquerading for all packets outgoing from
  uplink bridge interface (usually `br0`).
  * Mandatory: no
  * Default value: false


## Virtual "top of rack" bridge

`tor_network` configuration section configures virtual TOR bridge.
This bridge is fully managed by Ansible. All other devices should be connected
to that device, directly of via other devices. The structure is the following:

```yaml
tor_network:
  name: <string>
  device_name: <string>
  uplink:
    - <uplink spec>
```

* `name` - set the name of a 'network' (not device!). This name should be
  used in `lookup` strings.
  * Mandatory: yes

* `device_name` - could be set explicitly to avoid automatic name generation
  * Mandatory: no
  * Default value: `br-<name>`, e.g. `br-tor` if `name: tor`

* `uplink` - list of configuration sections each of which defines a link
  to other bridges.
  * Mandatory: no
  * Default value: unset

```text
NOTE

  It's possible to define default values for every parameter in `tor_network`.
  However, tor bridge will be configured only when `tor_network` exists,
  so it will lead to `tor_network` section without any parameter inside
  (because all are defaults) or in dummy `enabled` parameter. It's easier to
  make `name` mandatory and set name explicitly.
  The same is applicable to `seed_network` section.
```

### Example

```yaml
tor_network:
  name: tor
  uplink:
    - bridge: "{{ uplink_bridge }}"
      vxlan_id: 10
```

## Seed network configuration

`seed_network` defines separate network that is used for bootstrap cluster.

```yaml
seed_network:
  name: <string>
  device_name: <string>
  cidr: <cidr>
  masquerade: <masquerade all traffic>
  addresses:
    - <cidr>
  forwarding:
    - <destination spec>
  uplink:
    - <uplink spec>
```
* `name` name for the seed network, this value should be used in `lookup`
  strings.
  * Mandatory: yes

* `device_name` could be set explicitly to avoid automatic name generation.
  * Mandatory: no
  * Default value: `br-<name>`, e.g. `br-seed` if `name: seed`

* `cidr` is not used in generate-configuration, but it is required by
  bootstrap template generator to allocate bootstrap cluster addresses from
  correct network subnet.
  * Mandatory: no
  * Default value: 10.0.0.0/24

* `masquerade` option enables masquerading for all packets outgoing from
  seed network bridge interface (usually `br-seed`).
  * Mandatory: no
  * Default value: false

* `uplink` should be used in 'flat' network configuration, when bootstrap cluster
  and management cluster share the same L2 segment. In multirack configuration
  `uplink` should be removed as traffic should flow via routing. See
  **Links between bridges** section below.
  * Mandatory: no
  * Default value: unset

* `forwarding` allows to configure forwarding rules to other networks. See 
  **Configuring forwarding between networks** section below.
  * Mandatory: no
  * Default value: unset 

## VM networks

Two configuration parameters that are responsible for network configuration
targeted to virtual machines are `l2_rack_id` and `l2_layout`.

* `l2_rack_id` defines 'default' rack id for a given host. It could be set
  for a group of hosts (or for all hosts if only one rack is used) so that
  all network lookups via `lookup` would use this rack id if it is not
  specified explicitly.
  * Mandatory: no
  * Default value: 0

* `l2_layout` allows to create separate L2 segments that could be attached to
  virtual machines. This configuration option is a list of 'rack' definitions
  with networks defined in that specific rack. `l2_layout` should be defined
  for all hosts that acts as a hypervisor.
  * Mandatory: no
  * Default value: unset

```yaml
l2_layout:
  - rack_id: 0
    networks:
      - <network spec>
```

* `rack_id` applies to all networks in `networks` block for this rack. It means
  networks will be marked as belonging to this rack.
  * Mandatory: no
  * Default value: 0

* `networks` defines list of L2 segments in this 'rack'
  * Mandatory: no
  * Default value: unset

Each `<network spec>` could be defined as following:

```yaml
name: <string>
device_name: <int>
addresses:
  - <cidr>
forwarding:
  - <destination spec>
uplink:
  - <uplinks spec>
```

* `name` - name of L2 segment. This name should be used in `lookup` strings.
  * Mandatory: yes

* `device_name` - could be used to override auto-generated name of a bridge
  that represents L2 segment.
  * Mandatory: no
  * Default value: `br-<name>` if `rack_id` is 0, `br-<name>r<rack_id>`
    otherwise. E.g. `br-netX` if `name: netX` and `rack_id: 0`, or `br-netYr1`
    if `name: netY` and `rack_id: 1`

* `addresses` could be used to assign IP addresses on the seed node to
  enable routing between networks (use `forwarding` for that).
  * Mandatory: no
  * Default value: unset

* `forwarding` - see **Configuring forwarding between networks** secton below.
  * Mandatory: no
  * Default value: unset

* `uplink` - see **Links between bridges** section below.
  * Mandatory: no
  * Default value: unset

## VM interfaces

* `vm_interfaces` - Each host that will be a virtual machine should define
  `vm_interfaces` section that describes what L2 segments should be connected
  to the VM and in what order.
  * Mandatory: ???

Element in `vm_interfaces` are defined as follows:

* `lookup` defines L2 segment lookup expression. It is a string of the form
  `<name>/<rack_id>`. `/<rack_id>` could be omitted, default value for `rack_id`
  is 0.
  * Mandatory: yes

* `mtu` MTU for the VM interface
  * Mandatory: no
  * Default value: unset

* `provisioning` indicated that this interface is the interface that will be
  used to PXE boot. It is used by some internal logic but useless in general
  as VM will always boot from the first interface only. Do not set this flag
  for any other interfaces than the first one!
  * Mandatory: no
  * Default value: `false`

* `ovs_bond` defines parameters needed to connect interface to OVS bonded port.
  * Mandatory: no
  * Default value: unset

### OVS bonded port interface

When present, `ovs_bond` switches VM interface from bridged to direct
connection through VETH pair to OVS bonded port interface. It is required
that network name specified in `lookup` parameter was of type `ovs`. This type
should be specified explicitly in `l2layout` (see examples below).

Each bond consists of 2 links only and the number of links is not configurable.

`ovs_bond` supports the following parameters:
* `name` is the base name of OVS bond port. This it not the name of a real port,
  there will be `-{{ host_id }}` suffix appended to that name to generate
  real name. This is to allow multiple bond ports for the same network (same
  OVS bridge device) but for different VMs.
  * Mandatory: yes

* `link_index` is the index of an interface from bond port interfaces to be
  connected to the VM. This index starts from 1.
  * Mandatory: yes

### Example

```yaml
vm_interfaces:
 - lookup: pxe0
   mtu: 9050
   provisioning: true
 - lookup: net1
```

### Example with OVS bond

```yaml
l2layout:
  - networks:
      - name: pxe
        type: ovs
        uplink:
          - lookup: tor/0
-           ...
```

```yaml
vm_interfaces:
 - lookup: pxe0
   ovs_bond:
     name: bond0
     link_index: 1
   mtu: 9050
   provisioning: true
 - lookup: pxe0
   ovs_bond:
     name: bond0
     link_index: 2
   mtu: 9050
 - lookup: net1
```

## Links between bridges

`uplink` configuration section allows to create a link between two bridges.
```text
NOTE

  This is a legacy name as initially this section was supporting only one link
  to a bridge that would be 'uplink' for the current one. This name could be
  confusing a bit especially in `seed_network` section where it could be used
  to establish connection with L2 segments (bridges) that are rather 'downlink'
  than 'uplink'.
```

`uplink` is a nested data structure that defines list of 'uplink' devices
current device should be attached to. Single `<uplink spec>`is a mapping that
defines connection with 'uplink' device:

```yaml
lookup: <string>
bridge: <string>
vlan_id: <int>
vxlan_id: <int>
```

* `lookup` defines uplink L2 segment lookup expression. It is a string of the
  form `<name>/<rack_id>`. `/<rack_id>` could be omitted,
  default value for `rack_id` is 0.
  * Mandatory: yes (if `bridge` is not defined)
  * Default value: unset
 
* `bridge` could be used instead of `lookup` to connect to a specific linux
  bridge device.
  * Mandatory: yes (if `lookup` is not defined)
  * Default value: unset

* `vlan_id` (optional) VLAN ID if current device should be in a specific VLAN
  with trunk port on uplink device.
  * Mandatory: no
  * Default value: unset
 
* `vxlan_id` (optional) VxLAN ID if current device should be in a specific VxLAN
  on top of uplink device.
  * Mandatory: no
  * Default value: unset

Each device could be connected to a number of other devices, either
directly, or with VLAN / VxLAN segregation. Three types of connection are
possible:

* direct
  ```text
  [uplink device]--[veth_a]--[veth_b]--[current device]
  ```

* VxLAN
  ```text
  [uplink device]--[vxlan device]--[current device]
  ```

* VLAN
  ```text
  [uplink device]--[veth_a]--[veth_b]--[veth_b.vlan_id]--[current device]
  ```

### Example

```yaml
uplink:
  - bridge: "{{ uplink_bridge }}"
    vxlan_id: 10
```

## Configuring forwarding between networks

By default, forwarding between L2 segments is not allowed and requires to
be configured explicitly using list of destinations.

```yaml
forwarding:
  - lookup: <L2 segment>
    cidr: <L3 network>
    masquerade: <boolean>
  - ...
```

* `lookup` defines uplink L2 segment lookup expression. It is a string of the
  form `<name>/<rack_id>`.
  `/<rack_id>` could be omitted, default value for `rack_id` is 0.
  * Mandatory: yes (if `cidr` is not defined)
  * Default value: unset

* `cidr` defines L3 network to which forwarding will be allowed.
  * Mandatory: yes (if `lookup` is not defined)
  * Default value: unset

* `masquerade` enables masquerading for outgoing traffic.
  * Mandatory: no
  * Default value: `false`

Destination spec defines where forwarding could be allowed:
* When multiple addresses are configured on a given L2 segment via `addresses`
  key. In this case forwarding between all L3 segments bound to this L2 segment
  is allowed. But still, this doesn't allow forwarding to 'external' L2
  segments or any other L3 segments.

* When destination L2 segment is specified via `lookup` key. In this case
  forwarding is allowed to this particular L2 segment only.

* When destination L3 network is specified via `cidr` key. In this case
  forwarding is allowed to this particular L3 network only.

* `lookup` and `cidr` should not be used together. If this happens forwarding
  would not be allowed.

* Optional `masquerade` key in destination spec enables masquerading
  when forwarding to this destination.

* Traffic that returns back is allowed implicitly.

## DHCP Relay

It is possible to configure DHCP Relay Agent on the seed node to forward PXE
boot requests to DHCP server(s) that are responsible for MGMT cluster PXE
network(s). The list of DHCP servers should be specified when DHCP Relay
is configured, this happens before the cluster created, so some preparation
steps should be taken. Usually this list contains DHCP server IP from seed
network (to handle PXE boot at bootstrap phase) and IPs that will be assigned
to MGMT cluster nodes during deployment (to handle PXE boot for child cluster).
DHCP server from seed network will be gone at that moment but this is not a
problem.

It is also required to specify what L2 segments should be connected to DHCP
Relay namespace (it runs in a separate namespace) and IP addresses assigned
to interfaces where DHCP Relay binds to.

`l3_dhcp_relay` section configured DHCP Relay. There is no `enabled` parameter,
if the section exists DHCP relay will be configured:

* `netns_name` allows to set namespace DHCP Relay will use.
  * Mandatory: no
  * Default value: `dhcrelay`

* `servers` - list of IP adresses where DHCP Relay will forward requests
  * Mandatory: yes

* `interfaces` - list of L2 segments that should be linked to interfaces
  in the namespace. Use `lookup` to specify L2 segment and `address` to specify
  IP address assigned to that L2 inside the namespace.
  * Mandatory: yes

### Example

```yaml
l3_dhcp_relay:
  netns_name: dhcrelay
  servers:
    - 10.0.1.20
    - 10.0.21.50
    - 10.0.21.51
    - 10.0.21.52
  interfaces:
    - lookup: seed/0
      address: 10.0.1.2/24
    - lookup: pxe/1
      address: 10.0.21.2/24
    - lookup: pxe/2
      address: 10.0.22.2/24
```

## Per-rack `top-of-rack` namespaces

It is possible to create one or many network namespaces to run services like
DHCP Relay or BIRD daemon in isolated networking stack to emulate per-rack
top-of-rack switch functionality.

```yaml
l3_layout:
  routes:
    - <route definition>
  namespaces:
    - <namespace definition>
```

### `routes`

`l3_layout` section may include `routes` element that defines additional
routes for seed node. These may be used to tell seed node where per-rack
networks are.

```yaml
l3_layout:
  routes:
    - to: <target network prefix>
      via: <gateway address>
      dev: <interface name>
```

`routes` is a list of route definitions. Each route definition is:

* `to` - prefix of the target network
  * Mandatory: no
  * Default value: `0.0.0.0/0`

* `via` - IP address of the gateway for target network
  * Mandatory: no

* `dev` - interface name for target network
  * Mandatory: no

### `namespaces`

`l3_layout` section may include `namespaces` element that defines namespace(s)
configuration.

```yaml
l3_layout:
  namespaces:
    - name: ...
      interfaces:
        - <interface definition>
      routes:
        - <route definition>
      dhcp_relay:
        <dhcp relay configuration>
      bird:
        <bird configuration>
```

Each namespace configuration may include the following keys:

* `name` - name of network namespace. NOTE: names MUST be unique.
  * Mandatory: yes 

* `interfaces` - list of virtual interfaces added to the namespace. Virtual
  interfaces created as veth pairs, with peer connected to either bridge on
  the seed node or added to another namespace or left on the seed node.
  * Mandatory: yes 

* `routes` - additional routes to created inside the namespace
  * Mandatory: no

* `dhcp_relay` - enables DHCP Relai in the namespace
  * Mandatory: no

* `bird` - enables BIRD daemon in the namespae
  * Mandatory: no

#### `interfaces`

```yaml
l3_layout:
  namespaces:
    - name: ...
      interfaces:
        - ifname: <set interface name>
          addresses:
            - <IP address CIDR>
          lookup: <lookup expression>
          peer:
            ifname: <set interface name>
            netns: <target namespace>
            addresses:
              - <IP address CIDR>
```

`interfaces` section is a list of interface definitions. Each interface
definition may include the following options:

* `ifname` - rename veth to this name in the namespace
  * Mandatory: no

* `addresses` - list of IP addresses to add to the interface inside 
  the namespace
  * Mandatory: no 

* `lookup` - lookup for a bridge device on the seed node and attach veth peer
  to this bridge.
  * Mandatory: no

* `peer` - veth peer configuration.
  * Mandatory: no 

`peer` section may include the following options:

* `netns` - name of a namespace where peer veth interface should be moved
  * Mandatory: no

* `ifname` - rename veth peer to this name
  * Mandatory: no

* `addresses` - assign IP address(es) to peer veth interface
  * Mandatory: no

#### `routes`

```yaml
l3_layout:
  namespaces:
    - name: ...
      routes:
        - to: <target network prefix>
          via: <gateway IP address>
          dev: <device name>
```


`routes` is a list of route definitions. Route definition options are:

* `to` - prefix of the target network
  * Mandatory: no
  * Default value: `0.0.0.0/0`

* `via` - IP address of the gateway for target network
  * Mandatory: no

* `dev` - interface name for target network
  * Mandatory: no

#### `dhcp_relay`

```yaml
l3_layout:
  namespaces:
    - name: ...
      dhcp_relay:
        servers:
          - <upstream DHCP server IP address>
```

Enables DHCP Relay in the namespace. The only option available is `servers`
which is a list of upstream DHCP servers.

Logs from DHCP Relay are saved in `/var/log/dhcrelay/<namespace>.log`.

PID file of DHCP Relay daemon is `/var/run/dhcrelay/<namespace>.pid`.

#### `bird`

```yaml
l3_layout:
  namespaces:
    - name: ...
      bird:
        config: |
          ...
```

Enables BIRD component inside the namespace. The only option available is
`config` which is a plain-text BIRD config. NOTE: bird options `log "logfile";`
and `debug protocols all;` already included from template.

Generated config file is in `/etc/bird/<namespace>.conf` file.

Control socket to connect to running daemon is `/var/run/bird/<namespace>.ctl`

Logs from BIRD are saved in `/var/log/bird/<namespace>.log`.

PID file of BIRD daemon is `/var/run/bird/<namespace>.pid`

### Example

```yaml
l3_layout:
  routes:
    - to: 10.100.91.0/24
      via: 10.10.10.253
    - to: 10.0.21.0/24
      via: 10.10.10.253
  namespaces:
    - name: spine
      interfaces:
        - ifname: eth0
          lookup: spine/0
          addresses:
            - 10.10.10.1/30    # L3 link to `rack0` ns
            - 10.10.10.5/30    # L3 link to `rack1` ns
            - 10.10.10.253/30  # L3 link to seed node
      bird:
        config: |
          define rack0 = 10.10.10.2;
          define rack1 = 10.10.10.6;
          define extgw = 10.10.10.254;
          router id 10.10.10.1;
          protocol device {
          }
          protocol direct {
            disabled;
          }
          protocol kernel {
            ipv4 {
              export all;
            };
          }
          protocol static {
            ipv4;
            route 0.0.0.0/0 via extgw;
            route 10.0.21.0/24 via rack1;
            route 10.100.91.0/24 via rack0;
          }
    - name: rack0
      interfaces:
        - ifname: eth0
          lookup: spine/0
          addresses:
            - 10.10.10.2/30   # L3 link to `spine` ns
        - ifname: eth1
          lookup: lcm/0
          addresses:
            - 10.100.91.1/24
      bird:
        config: |
          router id 10.10.10.2;
          protocol device {
          }
          protocol direct {
            disabled;
          }
          protocol kernel {
            ipv4 {
              export all;
            };
          }
          protocol static {
            ipv4;
            route 0.0.0.0/0 via 10.10.10.1;
            route 10.100.91.0/24 via "eth1";
          }
    - name: rack1
      interfaces:
        - ifname: eth0
          lookup: spine/0
          addresses:
            - 10.10.10.6/30   # L3 link to `spine` ns
        - ifname: eth1
          lookup: pxe/1
          addresses:
            - 10.0.21.1/24
      routes:
        - via: 10.10.10.5/30  # Default route via `spine` ns
      dhcp_relay:
        servers:
          - 10.0.1.20
          - 10.100.91.50
          - 10.100.91.51
          - 10.100.91.52
```
