from si_tests.deployments.utils import wait_utils, commons, kubectl_utils, file_utils
from si_tests.deployments.utils.namespace import NAMESPACE


def deploy_helmbundle_controller(os_manager, timeout):
    kubectl = kubectl_utils.Kubectl()

    commons.LOG.info("Create the namespace")
    kubectl.apply(file_utils.get_release("01-namespaces.yaml"))

    commons.LOG.info("Deploy the HelmBundle Controller")
    if "helmbundles.lcm.mirantis.com" not in kubectl.get_crds():
        kubectl.apply(file_utils.get_release("02-helmbundle-crd.yaml"))

    hb_file = file_utils.get_release("30-helm-controller.yaml")
    hc_documents = file_utils.get_yaml_all_ontent(hb_file)
    for document in hc_documents:
        if document.get('kind') == "StatefulSet":
            for container in document["spec"]["template"]["spec"]["containers"]:
                if container["name"] == "controller":
                    container["command"] += ["-namespaces-to-watch", "osh-system"]
    file_utils.save_to_yaml_all(hc_documents, hb_file)
    kubectl.apply(file_utils.get_release("30-helm-controller.yaml"))

    commons.LOG.info("Wait till helm-controller starts")
    wait = wait_utils.Waiter(os_manager, timeout, NAMESPACE.osh)
    wait.statefulset("helm-controller")

    commons.LOG.info("Helmbundle controller successfully deployed")
