#    Copyright 2022 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1TFAnalytics(base.BaseModel):
    pass


class V1TFAnalyticsList(base.BaseModelList):
    pass


class TFAnalytics(base.K8sNamespacedResource):
    resource_type = 'tfanalytics'
    model = V1TFAnalytics


class TFAnalyticsManager(base.K8sBaseManager):
    model = V1TFAnalytics
    resource_class = TFAnalytics
    resource_group = 'analytics.tf.mirantis.com'
    resource_version = 'v1alpha1'
    resource_plural = 'tfanalytics'


class V2TFAnalytics(base.BaseModel):
    pass


class V2TFAnalyticsList(base.BaseModelList):
    pass


class TFAnalyticsV2(base.K8sNamespacedResource):
    resource_type = 'tfanalytics'
    model = V2TFAnalytics


class TFAnalyticsManagerV2(base.K8sBaseManager):
    model = V2TFAnalytics
    resource_class = TFAnalyticsV2
    resource_group = 'tf.mirantis.com'
    resource_version = 'v2'
    resource_plural = 'tfanalytics'
