import pytest

from si_tests import settings
from si_tests import logger

LOG = logger.logger


@pytest.mark.parametrize("_", ["CLUSTER_NAME={0}"
                               .format(settings.TARGET_CLUSTER)])
@pytest.mark.usefixtures("store_cluster_description")
def test_get_child_cluster_k8s_logs(kaas_manager, _):
    """Get child cluster kubernetes logs"""
    cluster_name = settings.TARGET_CLUSTER
    namespace_name = settings.TARGET_NAMESPACE
    ns = kaas_manager.get_namespace(namespace_name)
    child_cluster = ns.get_cluster(cluster_name)
    child_cluster.download_kubernetes_logs(raise_on_error=True)


@pytest.mark.parametrize("_", ["CLUSTER_NAME={0}"
                               .format(settings.TARGET_CLUSTER)])
@pytest.mark.usefixtures("store_cluster_description")
def test_get_child_cluster_system_logs(kaas_manager, _):
    """Get child cluster system logs"""
    cluster_name = settings.TARGET_CLUSTER
    namespace_name = settings.TARGET_NAMESPACE
    ns = kaas_manager.get_namespace(namespace_name)
    child_cluster = ns.get_cluster(cluster_name)
    child_cluster.download_system_logs(raise_on_error=True)


@pytest.mark.parametrize("_", ["CLUSTER_NAME={0}"
                               .format(settings.TARGET_CLUSTER)])
@pytest.mark.usefixtures("store_cluster_description")
def test_get_mgmt_cluster_k8s_logs(kaas_manager, _):
    """Get mgmt cluster kubernetes logs"""
    cluster_name = settings.TARGET_CLUSTER
    mgmt_cluster = kaas_manager.get_mgmt_cluster()
    mgmt_cluster.download_kubernetes_logs(name="mgmt_k8s_logs_after_{0}"
                                          .format(cluster_name),
                                          raise_on_error=True)
