variable "quantity" {
    description = "Number of VMs to create"
}

variable "name_prefix" {
    description = "The name of the VMs will be this plus a counter value"
}

variable "cluster_name" {
    description = "The name of the VMs will be this plus a counter value"
}

variable "resource_pool_id" {
    description = "ID of the resource pool to create the VMs in"
}

variable "datastore_id" {
    description = "ID of the datastore cluster to create the VMs in"
}

variable "folder" {
    description = "Subfolder in the datacenter at which to create the VMs"
}

variable "network_id" {
    description = "ID of the network to attach the VMs to"
}

variable "template_vm" {
    description = "The template VM which will be cloned as the base for the new VMs"
}

variable "guest_ssh_user" {
  description = "SSH username to connect to the guest VM."
}

variable "guest_ssh_key_public" {
  description = "SSH public key (e.g., id_rsa.pub) path."
}

variable "disk_size" {
    description = "Size of the disk drive for the VMs"
}
variable "ram" {
    description = "Size of the disk drive for the VMs"
}
variable "num_cpu" {
    description = "Size of the disk drive for the VMs"
}
variable "dns" {
    description = "Nameserver for ipam for child cluster"
}
variable "gateway" {
    description = "Gateway host for IPAM"
}
variable "is_ipam_enabled" {
    description = "Use IPAM to assign ip during deployment instead of dhcp"
}
variable "ip_addresses" {
    description = "IP addresses"
}