#!/usr/bin/env bash

echo 'set_power'

declare -A nodes_pw
nodes_pw=(\
[cz10098]='b3uvaENwdJTJ' \
[cz10099]='b3uvaENwdJTJ' \
[cz10100]='b3uvaENwdJTJ' \
[cz7714]='b3uvaENwdJTJ' \
[cz7725]='b3uvaENwdJTJ' \
[cz7726]='b3uvaENwdJTJ' \
[cz7727]='b3uvaENwdJTJ' \
[cz10097]='b3uvaENwdJTJ' \
[cz8221]='b3uvaENwdJTJ' \
[cz7986]='b3uvaENwdJTJ' \
[cz9049]='b3uvaENwdJTJ' \
[cz10102]='b3uvaENwdJTJ' \
[cz10103]='b3uvaENwdJTJ' \
[cz10104]='b3uvaENwdJTJ' \
[cz10106]='b3uvaENwdJTJ' \
[cz10128]='b3uvaENwdJTJ' \
[cz7904]='b3uvaENwdJTJ' \
[cz10096]='b3uvaENwdJTJ' \
[cz10095]='b3uvaENwdJTJ' \
[cz8213]='0b5A#n3kDZqY' \
[cz8214]='0b5A#n3kDZqY' \
[cz8215]='0b5A#n3kDZqY' \
[cz7906]='0b5A#n3kDZqY' \
[cz7901]='0b5A#n3kDZqY' \
[cz7912]='0b5A#n3kDZqY' \
[cz8216]='0b5A#n3kDZqY' \
[cz8217]='0b5A#n3kDZqY' \
[cz8218]='0b5A#n3kDZqY' \
[cz7903]='0b5A#n3kDZqY' \
[cz7907]='0b5A#n3kDZqY' \
[cz7908]='0b5A#n3kDZqY' \
[cz7744]='0b5A#n3kDZqY' \
[cz7856]='0b5A#n3kDZqY' \
[cz7865]='0b5A#n3kDZqY' \
)

function set_power(){
  local action="${1:-'chassis power status'}"
  local nset=${2:-'all'}
  declare -A nodes=();
  declare -A nodes_child=();
  declare -A nodes_mgmt=();

  nodes_child=([cz7714]='5.43.225.36' \
               [cz7725]='5.43.225.39' \
               [cz7726]='5.43.225.40' \
               [cz7727]='5.43.225.41' \
               [cz10095]='5.43.229.124' \
               [cz10096]='5.43.229.125' \
               [cz10097]='5.43.229.126' \
               [cz8221]='5.43.229.21'  \
               [cz7986]='5.43.225.128' \
               [cz9049]='5.43.227.215' \
               [cz10102]='5.43.229.131' \
               [cz10103]='5.43.229.132' \
               [cz10104]='5.43.229.133' \
               [cz10106]='5.43.229.135' \
               [cz10128]='185.8.58.185' \
               [cz7904]='5.43.229.91' \

               [cz8213]='5.43.227.228' \
               [cz8214]='5.43.227.229' \
               [cz8215]='5.43.227.230' \
               [cz7906]='5.43.227.16' \
               [cz7901]='5.43.227.12' \
               [cz7912]='5.43.227.22' \
               [cz8216]='5.43.227.231' \
               [cz8217]='5.43.227.232' \
               [cz8218]='5.43.227.233' \
               [cz7903]='5.43.227.14' \
               [cz7907]='5.43.227.17' \
               [cz7908]='5.43.227.18' \
               [cz7744]='5.43.225.126' \
               [cz7856]='5.43.225.213' \
               [cz7865]='5.43.225.176' )

   nodes_mgmt=([cz10098]='5.43.229.127' \
               [cz10099]='5.43.229.128' \
               [cz10100]='5.43.229.129' )

  # awesome merge event...
  case "$nset" in
      'mgmt')
        for i in ${!nodes_mgmt[@]}; do
            nodes[$i]="${nodes_mgmt[$i]}"
        done
      ;;
      'child')
        for i in ${!nodes_child[@]}; do
            nodes[$i]="${nodes_child[$i]}"
        done
      ;;
      'all')
        for i in ${!nodes_child[@]}; do
            nodes[$i]="${nodes_child[$i]}"
        done
        for i in ${!nodes_mgmt[@]}; do
            nodes[$i]="${nodes_mgmt[$i]}"
        done
      ;;
  esac

  for i in "${!nodes[@]}"; do
    echo "node: $i"
    set -xe
    ipmitool -I lanplus -H ${nodes[$i]} -U engineer -P "${nodes_pw[$i]}" $action
    set +xe
  done
 }

