class UnknownFlagException(Exception):
    pass


def assert_known(flag, known_flags):
    if flag not in known_flags:
        raise UnknownFlagException("Unknown flag: {!r}".format(flag))


def parse(s, known_flags):
    if not s:
        flags = []
    else:
        flags = s.split(',')
        for flag in flags:
            assert_known(flag, known_flags)
    return FeatureFlags(flags, known_flags)


class FeatureFlags:
    def __init__(self, flags, known_flags):
        self.flags = flags
        self.known_flags = known_flags

    def enabled(self, flag):
        assert_known(flag, self.known_flags)
        return flag in self.flags

    def len(self):
        return len(self.flags)

    def list(self):
        return self.flags
