#    Copyright 2022 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1KaaSMetalLBConfig(base.BaseModel):
    pass


class V1KaaSMetalLBConfigList(base.BaseModelList):
    pass


class KaaSMetalLBConfig(base.K8sNamespacedResource):
    resource_type = 'metallbconfig'
    model = V1KaaSMetalLBConfig

    @property
    def cluster(self) -> str:
        return self.data['metadata']['labels'].get('cluster.sigs.k8s.io/cluster-name')


class KaaSMetalLBConfigManager(base.K8sBaseManager):
    model = V1KaaSMetalLBConfigList
    resource_class = KaaSMetalLBConfig
    resource_group = 'kaas.mirantis.com'
    resource_version = 'v1alpha1'
    resource_plural = 'metallbconfigs'

    def filter(self, namespace, cluster_name=None):
        metallb_configs = self.list(namespace=namespace)
        if cluster_name:
            metallb_configs = [config for config in metallb_configs
                               if config.cluster == cluster_name]
        return metallb_configs
