# Repositories test module

## Overview
This directory contains tests related to repositories with Helm charts objects:

- HelmRepository
- GitRepository

Repositories are used to store the following charts:

- ClusterTemplate charts
- ServiceTemplate charts

## Pre-requisites

- Working k0rdent kcm installation required to execute any of those tests

## Existing tests and requirements

### test_add_charts_repository.py
Creates a HelmRepository or GitRepository object in the KCM cluster

#### Variables that MUST be filled before run and have no default value
| ENV Variable                                   | Type    | Desctiption                                                                                 |
|------------------------------------------------|---------|---------------------------------------------------------------------------------------------|
| `CUSTOM_HELM_REPOSITORY_TEMPLATE_PATH`         | `<str>` | YAML template in Jinja2 format to create a Repository object                                |
| `CUSTOM_HELM_REPOSITORY_SECRET_TEMPLATE_PATH`  | `<str>` | YAML template in Jinja2 format to create a Secret with access credentials to the repository |

#### Optional variables
| ENV Variable                               | Type    | Desctiption                                                                    | Defaults    |
|--------------------------------------------|---------|--------------------------------------------------------------------------------|-------------|
| `CUSTOM_HELM_REPOSITORY_OVERWRITE`         | `<str>` | If `True`, then removes the existing Repository object and creates a new one   | False       |
