# Bootstrap test module

## Overview

This directory contains different tests related to bootstrap of k0rdent (kcm)

## Pre-requisites

- Working CNCF Kubernetes installation (KinD/k0s/Minikube/etc...)
- KUBECONFIG file
- KCM Build uploaded to accessible registry

## Detailed description of checks inside bootstrap test (test_install_kcm.py)

The test install kcm chart. Checks for that include:

- Wait for HelmRelease appear and become ready
- Wait for Management object appear and become ready

### Execution

```bash
py.test $(KSI_HOME)/si_tests/bootstrap/test_install_kcm.py
```

### Expected pods check

Not yet appliable.

### Variables that MUST be filled before run and have no default value

| ENV Variable        | Type    | Description             | Example                                       |
|---------------------|---------|-------------------------|-----------------------------------------------|
| `KUBECONFIG`        | `<str>` | Path to KUBECONFIG file | `./kubeconfig`                                |
| `KCM_CHART_VERSION` | `<str>` | Version of KCM chart    | `0.2.0` or `0.1.0-80-g0708b9e` or `0.2.0-rc1` |

### Optional parameters

| ENV Variable                    | Type     | Description                                                                                                                 | Defaults |
|---------------------------------|----------|-----------------------------------------------------------------------------------------------------------------------------|----------|
| `KSI_HELM_INSECURE`             | `<bool>` | Add or not --insecure-skip-tls-verify flag to the helm comands                                                              | `False`  |
| `KSI_CUSTOM_REGISTRY_CERT_PATH` | `<str>`  | Path to the Root CA for registry. Mutually exclusive with KSI_CUSTOM_REGISTRY_CERT_TEXT | `False`  |
| `KSI_CUSTOM_REGISTRY_CERT_TEXT` | `<str>`  | Plain-text Root CA for registry. Mutually exclusive with KSI_CUSTOM_REGISTRY_CERT_PATH | `False`  |

### Source parameter

The main parameter which represents the source of kcm installation.

| ENV Variable | Type    | Description                              | Defaults     |
|--------------|---------|------------------------------------------|--------------|
| `KCM_SOURCE` | `<str>` | KCM source of chart to be installed from | `opensource` |

This variable can have the values: `opensource` `enterprise` or `custom-enterprise`

#### KCM_SOURCE='enterprise'

In that case ksi will use enterprise regestry with default values existing inside chart.
Repo which will be used for install: "oci://registry.mirantis.com/k0rdent-enterprise".

helm install command inside test will be looks like

```bash
helm install kcm oci://registry.mirantis.com/k0rdent-enterprise/kcm --version 1.1.0 --kubeconfig working/kubeconfig --namespace kcm-system --timeout 5m --create-namespace --wait
```

#### KCM_SOURCE='custom-enterprise'

It that case it's needed to set additional mandatory variables to configure release

| ENV Variable          | Type    | Description                                                                                                                                  | Example                       |
|-----------------------|---------|----------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------|
| `KCM_CUSTOM_REGISTRY` | `<str>` | Repo with charts, images, etc without protocol. It's not expected to have 'chart' postfix in full chart path. It will be added automatically | `registry.example.com`        |
| `KSI_K0S_URL`         | `<str>` | Base url to binary. E.g. if the k0s url is `http://binary.repo.net/k8s_binary` the base is `http://binary.repo.net`                          | `http://registry.example.com` |

### Optional parameters

| ENV Variable                       | Type     | Description                                                                                                                    | Defaults |
|------------------------------------|----------|--------------------------------------------------------------------------------------------------------------------------------|----------|
| `KSI_KCM_CUSTOM_INSECURE_REGISTRY` | `<bool>` | Allow insecure registries for KCM                                                                                              | `False`  |
| `KSI_KCM_CUSTOM_REGISTRY_USERNAME` | `<str>`  | Username for custom registry. Can not be used without password                                                                 | `False`  |
| `KSI_KCM_CUSTOM_REGISTRY_PASSWORD` | `<str>`  | Password for custom registry. Can not be used without username                                                                 | `False`  |
| `KSI_CUSTOM_REGISTRY_CERT_PATH` | `<str>`  | Path to the Root CA for registry. Mutually exclusive with KSI_CUSTOM_REGISTRY_CERT_TEXT | `False`  |
| `KSI_CUSTOM_REGISTRY_CERT_TEXT` | `<str>`  | Plain-text Root CA for registry. Mutually exclusive with KSI_CUSTOM_REGISTRY_CERT_PATH | `False`  |


helm install command inside test will be looks like

```bash
helm install kcm oci://<KCM_CUSTOM_REGISTRY>/k0rdent-enterprise --version 1.1.0 --kubeconfig working/kubeconfig --namespace kcm-system --timeout 5m --create-namespace --wait
```

KCM_CUSTOM_REGISTRY will be passed to helm via temporal values file:

```yaml
{
  'image': {
    'repository': KCM_CUSTOM_REGISTRY
  },
  'controller': {
    'templatesRepoURL': oci://KCM_CUSTOM_REGISTRY/charts,
    'createManagement': true,
    'createAccessManagement': true,
    'createRelease': true,
    'createTemplates': true,
    'enableTelemetry': true,
    'globalK0sURL': KSI_K0S_URL
  },
  'cert-manager': {
    'image': {
      'repository': KCM_CUSTOM_REGISTRY/jetstack/cert-manager-controller
    },
    'webhook': {
      'image': {
        'repository': KCM_CUSTOM_REGISTRY/jetstack/cert-manager-webhook
      }
    },
    'cainjector': {
      'image': {
        'repository': KCM_CUSTOM_REGISTRY/jetstack/cert-manager-cainjector
      }
    },
    'startupapicheck': {
      'image': {
        'repository': KCM_CUSTOM_REGISTRY/jetstack/cert-manager-startupapicheck
      }
    }
  },
  'flux2': {
    'helmController': {
      'image': KCM_CUSTOM_REGISTRY/fluxcd/helm-controller
    },
    'sourceController': {
      'image': KCM_CUSTOM_REGISTRY/fluxcd/source-controller
    },
    'cli': {
      'image': KCM_CUSTOM_REGISTRY/fluxcd/flux-cli
    },
  },
  'cluster-api-operator': {
    'image': {
      'manager': {
        'repository': KCM_CUSTOM_REGISTRY/capi-operator/cluster-api-operator
      }
    }
  },
  'velero': {
    'image': {
      'repository': KCM_CUSTOM_REGISTRY/velero/velero
    }
  }
}
```

#### KCM_SOURCE='opensource'

The default behavior of test. Can detect by it's own - release version of kcm or CI version used for install.

In case of released version the equal helm command will looks like

```bash
helm install kcm oci://ghcr.io/k0rdent/kcm/charts --version 0.2.0 --kubeconfig working/kubeconfig --namespace kcm-system --timeout 5m --create-namespace --wait
```

In case of dev version:

```bash
helm install kcm oci://ghcr.io/k0rdent/kcm/charts-ci --version 0.1.0-80-g0708b9e --kubeconfig working/kubeconfig --namespace kcm-system --timeout 5m --create-namespace --wait
```

While using dev version - image repo will be also patched with values:

```yaml
{
  'image': {
    'repository': ghcr.io/k0rdent/kcm/controller-ci
  },
  'controller': {
    'defaultRegistryURL': oci://ghcr.io/k0rdent/kcm/charts-ci,
    'createManagement': true,
    'createAccessManagement': true,
    'createRelease': true,
    'createTemplates': true,
    'enableTelemetry': true
  }
}
```

### Optional variables to customise the deployment

| ENV Variable                    | Type    | Description               | Defaults     |
|---------------------------------|---------|---------------------------|--------------|
| `KCM_CHART_NAME`                | `<str>` | KCM chart name            | `kcm`        |
| `KCM_NAMESPACE`                 | `<str>` | Namespace to install kcm  | `kcm-system` |
| `KSI_KCM_CHART_INSTALL_TIMEOUT` | `<str>` | KCM chart install timeout | `10m`        |

## Cleanup (test_cleanup_kcm.py)

Full cleanup the k8s cluster. Rollback it to the initial state like it was before kcm installation.

### Execution

```bash
py.test $(KSI_HOME)/si_tests/bootstrap/test_cleanup_kcm.py
```

### Mandatory parameters

| ENV Variable | Type    | Description                                                       | Example                  |
|--------------|---------|-------------------------------------------------------------------|--------------------------|
| `KUBECONFIG` | `<str>` | Path to Kubeconfig of working k8s installation with KCM installed | `./bootstrap.kubeconfig` |

### Optional parameters

| ENV Variable                      | Type     | Description                                         | Defaults |
|-----------------------------------|----------|-----------------------------------------------------|----------|
| `REMOVE_RESOURCES_ON_KCM_CLEANUP` | `<bool>` | Remove all resources (clusters/secrets/auth) or not | `True`   |
