#    Copyright 2025 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from urllib.parse import urlparse

from si_tests.clients.k8s import base


class V1HelmRepository(base.BaseModel):
    pass


class V1HelmRepositoryList(base.BaseModelList):
    pass


class HelmRepository(base.K8sNamespacedResource):
    resource_type = 'helmrepository'
    model = V1HelmRepository

    @property
    def cert_secret_name(self):
        return self.data['spec'].get('certSecretRef', {}).get('name', None)

    @property
    def url(self):
        """Url - the main parameter for the repo. Can not be empty"""
        return self.data['spec']['url']

    @property
    def url_raw(self):
        return urlparse(self.url).netloc


class HelmRepositoryManager(base.K8sBaseManager):
    model = V1HelmRepositoryList
    resource_class = HelmRepository
    resource_group = 'source.toolkit.fluxcd.io'
    resource_version = 'v1'
    resource_plural = 'helmrepositories'
