# si-tests.clients.gcore.box-api
## Welcome to Inference Box API  A comprehensive REST API for managing cloud infrastructure resources including ML inference deployments, Kubernetes resources, and application lifecycle management.  ## Overview  Inference Box API is a cloud-native REST API service that provides unified access to manage:  - **ML Inference Deployments**: Create, manage, and scale machine learning inference services - **Slurm Clusters**: Deploy, configure, and manage HPC Slurm clusters for batch workloads - **Kubernetes Resources**: Manage namespaces (projects), pods, secrets, volumes, and other K8s resources - **Application Lifecycle**: Deploy and manage applications from catalog templates - **Resource Management**: Handle flavors, capacities, quotas, and node groups - **User & Access Control**: Manage users, groups, and API keys with RBAC integration - **Monitoring & Metrics**: Query metrics and monitor resource usage via Victoria Metrics  The service is built with Go and integrates with Kubernetes, HashiCorp Vault, and Victoria Metrics to provide a complete cloud infrastructure management solution.  ## Key API Endpoints  - **Inference**: `/v1/{project_name}/inferences` - ML inference deployment management - **Slurm Clusters**: `/v1/{project_name}/slurm/clusters` - Slurm cluster deployment and management - **Flavors**: `/v1/flavors` - Compute resource flavor definitions - **Users**: `/v1/admin/users` - User management (admin only) - **Projects**: `/v1/{project_name}` - Project-scoped resource operations - **Metrics**: `/v1/{project_name}/metrics` - Resource usage metrics  ## Getting Started  ### Authentication  All API requests require authentication using the `X-API-Key` header. Most operations are scoped to specific projects/namespaces.  ### API Organization  The API is organized into logical groups: - **Public endpoints**: `/v1/*` - General access endpoints - **Project-scoped**: `/v1/{project_name}/*` - Project-specific resources - **Admin endpoints**: `/v1/admin/*` - Administrative operations  ### Documentation  Interactive documentation is available at `/docs` when the service is running. 

The `si_tests.clients.gcore.box_api` package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.0
- Package version: 1.0.0
- Generator version: 7.14.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage

This python library package is generated without supporting files like setup.py or requirements files

To be able to use it, you will need these dependencies in your own package that uses this library:

* urllib3 >= 2.1.0, < 3.0.0
* python-dateutil >= 2.8.2
* pydantic >= 2
* typing-extensions >= 4.7.1

## Getting Started

In your own code, to use this library to connect and interact with si-tests.clients.gcore.box-api,
you can run the following:

```python

import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.APIKeysApi(api_client)
    project_name = 'project_name_example' # str | Project name
    v1_create_api_key_request = si_tests.clients.gcore.box_api.V1CreateApiKeyRequest() # V1CreateApiKeyRequest | API key configuration

    try:
        # Create API key
        api_response = api_instance.v1_create_api_key(project_name, v1_create_api_key_request)
        print("The response of APIKeysApi->v1_create_api_key:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling APIKeysApi->v1_create_api_key: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*APIKeysApi* | [**v1_create_api_key**](si_tests/clients/gcore/box_api/docs/APIKeysApi.md#v1_create_api_key) | **POST** /v1/{project_name}/apikeys | Create API key
*APIKeysApi* | [**v1_delete_api_key**](si_tests/clients/gcore/box_api/docs/APIKeysApi.md#v1_delete_api_key) | **DELETE** /v1/{project_name}/apikeys/{name} | Delete API key
*APIKeysApi* | [**v1_get_api_key**](si_tests/clients/gcore/box_api/docs/APIKeysApi.md#v1_get_api_key) | **GET** /v1/{project_name}/apikeys/{name} | Get API key
*APIKeysApi* | [**v1_list_api_keys**](si_tests/clients/gcore/box_api/docs/APIKeysApi.md#v1_list_api_keys) | **GET** /v1/{project_name}/apikeys | List API keys
*APIKeysApi* | [**v1_patch_api_key**](si_tests/clients/gcore/box_api/docs/APIKeysApi.md#v1_patch_api_key) | **PATCH** /v1/{project_name}/apikeys/{name} | Patch API key
*APIKeysApi* | [**v1_update_api_key**](si_tests/clients/gcore/box_api/docs/APIKeysApi.md#v1_update_api_key) | **PUT** /v1/{project_name}/apikeys/{name} | Update API key
*AppsApi* | [**v1_delete_deployed_app**](si_tests/clients/gcore/box_api/docs/AppsApi.md#v1_delete_deployed_app) | **DELETE** /v1/{project_name}/apps/deployments/{deploy_name} | Delete application deployment
*AppsApi* | [**v1_deploy_app**](si_tests/clients/gcore/box_api/docs/AppsApi.md#v1_deploy_app) | **POST** /v1/{project_name}/apps/deployments | Create application deployment
*AppsApi* | [**v1_get_app_catalog**](si_tests/clients/gcore/box_api/docs/AppsApi.md#v1_get_app_catalog) | **GET** /v1/apps/catalog/{app_name} | Get catalog application
*AppsApi* | [**v1_get_deployed_app**](si_tests/clients/gcore/box_api/docs/AppsApi.md#v1_get_deployed_app) | **GET** /v1/{project_name}/apps/deployments/{deploy_name} | Get application deployment
*AppsApi* | [**v1_list_app_catalog**](si_tests/clients/gcore/box_api/docs/AppsApi.md#v1_list_app_catalog) | **GET** /v1/apps/catalog | List catalog applications
*AppsApi* | [**v1_list_deployed_apps**](si_tests/clients/gcore/box_api/docs/AppsApi.md#v1_list_deployed_apps) | **GET** /v1/{project_name}/apps/deployments | List application deployments
*AppsApi* | [**v1_update_deployed_app**](si_tests/clients/gcore/box_api/docs/AppsApi.md#v1_update_deployed_app) | **PATCH** /v1/{project_name}/apps/deployments/{deploy_name} | Update application deployment
*AuditLogsApi* | [**v1_query_audit_log**](si_tests/clients/gcore/box_api/docs/AuditLogsApi.md#v1_query_audit_log) | **GET** /v1/admin/audit-logs | Execute an instant query for audit log
*AutodiscoveryApi* | [**v1_create_sub_region**](si_tests/clients/gcore/box_api/docs/AutodiscoveryApi.md#v1_create_sub_region) | **POST** /v1/admin/autodiscovery/subregions | Create edge region
*AutodiscoveryApi* | [**v1_delete_sub_region**](si_tests/clients/gcore/box_api/docs/AutodiscoveryApi.md#v1_delete_sub_region) | **DELETE** /v1/admin/autodiscovery/subregions/{subregion_name} | Delete edge region
*AutodiscoveryApi* | [**v1_get_sub_region**](si_tests/clients/gcore/box_api/docs/AutodiscoveryApi.md#v1_get_sub_region) | **GET** /v1/admin/autodiscovery/subregions/{subregion_name} | Get edge region
*AutodiscoveryApi* | [**v1_list_nodes**](si_tests/clients/gcore/box_api/docs/AutodiscoveryApi.md#v1_list_nodes) | **GET** /v1/admin/autodiscovery/nodes | List nodes
*AutodiscoveryApi* | [**v1_list_sub_region**](si_tests/clients/gcore/box_api/docs/AutodiscoveryApi.md#v1_list_sub_region) | **GET** /v1/admin/autodiscovery/subregions | List edge regions
*AutodiscoveryApi* | [**v1_update_sub_region**](si_tests/clients/gcore/box_api/docs/AutodiscoveryApi.md#v1_update_sub_region) | **PUT** /v1/admin/autodiscovery/subregions/{subregion_name} | Update edge region
*CapacityApi* | [**v1_list_capacities**](si_tests/clients/gcore/box_api/docs/CapacityApi.md#v1_list_capacities) | **GET** /v1/capacities | List available capacities
*CapacityApi* | [**v1_list_capacities_per_namesapce**](si_tests/clients/gcore/box_api/docs/CapacityApi.md#v1_list_capacities_per_namesapce) | **GET** /v1/capacities/{project_name} | List project available capacities
*DashboardApi* | [**v1_get_overview**](si_tests/clients/gcore/box_api/docs/DashboardApi.md#v1_get_overview) | **GET** /v1/admin/dashboard/overview | Get overview
*FlavorsApi* | [**v1_create_flavor**](si_tests/clients/gcore/box_api/docs/FlavorsApi.md#v1_create_flavor) | **POST** /v1/admin/flavors | Create flavor
*FlavorsApi* | [**v1_delete_flavor**](si_tests/clients/gcore/box_api/docs/FlavorsApi.md#v1_delete_flavor) | **DELETE** /v1/admin/flavors/{flavor_name} | Delete flavor
*FlavorsApi* | [**v1_get_flavor**](si_tests/clients/gcore/box_api/docs/FlavorsApi.md#v1_get_flavor) | **GET** /v1/flavors/{flavor_name} | Get flavor
*FlavorsApi* | [**v1_list_flavors**](si_tests/clients/gcore/box_api/docs/FlavorsApi.md#v1_list_flavors) | **GET** /v1/flavors | List flavors
*InferencesApi* | [**v1_create_inference**](si_tests/clients/gcore/box_api/docs/InferencesApi.md#v1_create_inference) | **POST** /v1/{project_name}/inferences | Create inference deployment
*InferencesApi* | [**v1_delete_inference**](si_tests/clients/gcore/box_api/docs/InferencesApi.md#v1_delete_inference) | **DELETE** /v1/{project_name}/inferences/{inference_name} | Delete inference deployment
*InferencesApi* | [**v1_get_inference**](si_tests/clients/gcore/box_api/docs/InferencesApi.md#v1_get_inference) | **GET** /v1/{project_name}/inferences/{inference_name} | Get inference deployment
*InferencesApi* | [**v1_get_inference_api_key**](si_tests/clients/gcore/box_api/docs/InferencesApi.md#v1_get_inference_api_key) | **GET** /v1/{project_name}/inferences/{inference_name}/apikey | Get inference API key
*InferencesApi* | [**v1_get_inference_logs**](si_tests/clients/gcore/box_api/docs/InferencesApi.md#v1_get_inference_logs) | **GET** /v1/{project_name}/inferences/{inference_name}/logs | Get inference logs
*InferencesApi* | [**v1_list_inferences**](si_tests/clients/gcore/box_api/docs/InferencesApi.md#v1_list_inferences) | **GET** /v1/{project_name}/inferences | List inference deployments
*InferencesApi* | [**v1_update_inference**](si_tests/clients/gcore/box_api/docs/InferencesApi.md#v1_update_inference) | **PUT** /v1/{project_name}/inferences/{inference_name} | Update inference deployment
*JupyterLabApi* | [**create_jupyter_lab_instance**](si_tests/clients/gcore/box_api/docs/JupyterLabApi.md#create_jupyter_lab_instance) | **POST** /v1/{project_name}/jupyterlabs | Create JupyterLab instance
*JupyterLabApi* | [**delete_jupyter_lab_instance**](si_tests/clients/gcore/box_api/docs/JupyterLabApi.md#delete_jupyter_lab_instance) | **DELETE** /v1/{project_name}/jupyterlabs/{instance_name} | Delete JupyterLab instance
*JupyterLabApi* | [**get_jupyter_lab_instance**](si_tests/clients/gcore/box_api/docs/JupyterLabApi.md#get_jupyter_lab_instance) | **GET** /v1/{project_name}/jupyterlabs/{instance_name} | Get JupyterLab instance
*JupyterLabApi* | [**list_jupyter_lab_instances**](si_tests/clients/gcore/box_api/docs/JupyterLabApi.md#list_jupyter_lab_instances) | **GET** /v1/{project_name}/jupyterlabs | List JupyterLab instances
*JupyterLabApi* | [**update_jupyter_lab_instance**](si_tests/clients/gcore/box_api/docs/JupyterLabApi.md#update_jupyter_lab_instance) | **PATCH** /v1/{project_name}/jupyterlabs/{instance_name} | Update JupyterLab instance
*MetricsApi* | [**v1_get_raw_metrics**](si_tests/clients/gcore/box_api/docs/MetricsApi.md#v1_get_raw_metrics) | **GET** /v1/{project_name}/metrics | Return raw metrics
*MetricsApi* | [**v1_query_metrics**](si_tests/clients/gcore/box_api/docs/MetricsApi.md#v1_query_metrics) | **GET** /v1/{project_name}/metrics/query | Execute an instant query for metrics
*MetricsApi* | [**v1_query_range_metrics**](si_tests/clients/gcore/box_api/docs/MetricsApi.md#v1_query_range_metrics) | **GET** /v1/{project_name}/metrics/query_range | Execute a range query for metrics
*NamespacesApi* | [**v1_create_namespace**](si_tests/clients/gcore/box_api/docs/NamespacesApi.md#v1_create_namespace) | **POST** /v1/admin/namespaces | Create project
*NamespacesApi* | [**v1_delete_namespace**](si_tests/clients/gcore/box_api/docs/NamespacesApi.md#v1_delete_namespace) | **DELETE** /v1/admin/namespaces/{namespace_name} | Delete project
*NamespacesApi* | [**v1_list_namespaces**](si_tests/clients/gcore/box_api/docs/NamespacesApi.md#v1_list_namespaces) | **GET** /v1/namespaces | List projects
*NodeGroupsApi* | [**v1_create_node_group**](si_tests/clients/gcore/box_api/docs/NodeGroupsApi.md#v1_create_node_group) | **POST** /v1/admin/node-groups | Create nodegroup
*NodeGroupsApi* | [**v1_delete_node_group**](si_tests/clients/gcore/box_api/docs/NodeGroupsApi.md#v1_delete_node_group) | **DELETE** /v1/admin/node-groups/{group_name} | Delete node group
*NodeGroupsApi* | [**v1_get_node_group**](si_tests/clients/gcore/box_api/docs/NodeGroupsApi.md#v1_get_node_group) | **GET** /v1/admin/node-groups/{group_name} | Get node group
*NodeGroupsApi* | [**v1_list_node_groups**](si_tests/clients/gcore/box_api/docs/NodeGroupsApi.md#v1_list_node_groups) | **GET** /v1/admin/node-groups | List node groups
*NodeGroupsApi* | [**v1_list_node_groups_node**](si_tests/clients/gcore/box_api/docs/NodeGroupsApi.md#v1_list_node_groups_node) | **GET** /v1/admin/node-groups/nodes | List nodes in all node groups
*NodeGroupsApi* | [**v1_update_node_group**](si_tests/clients/gcore/box_api/docs/NodeGroupsApi.md#v1_update_node_group) | **PUT** /v1/admin/node-groups/{group_name} | Update node group
*NodesApi* | [**v1_list_gpu_nodes**](si_tests/clients/gcore/box_api/docs/NodesApi.md#v1_list_gpu_nodes) | **GET** /v1/admin/nodes | List gpu nodes
*NodesApi* | [**v_perform_nodes**](si_tests/clients/gcore/box_api/docs/NodesApi.md#v_perform_nodes) | **POST** /v1/admin/nodes/action | Action perform action on the nodes.
*PodsApi* | [**admin_deschedule_pod**](si_tests/clients/gcore/box_api/docs/PodsApi.md#admin_deschedule_pod) | **POST** /v1/admin/pods/deschedule | Deschedule Pod from current node
*PodsApi* | [**admin_metrics_for_pod**](si_tests/clients/gcore/box_api/docs/PodsApi.md#admin_metrics_for_pod) | **GET** /v1/admin/{project}/pods/{name}/metrics | Get metrics for specific pod
*PodsApi* | [**admin_pods_metrics**](si_tests/clients/gcore/box_api/docs/PodsApi.md#admin_pods_metrics) | **GET** /v1/admin/pods/metrics | Get metrics for inference workloads
*ProjectsApi* | [**v1_create_project**](si_tests/clients/gcore/box_api/docs/ProjectsApi.md#v1_create_project) | **POST** /v1/admin/projects | Create project
*ProjectsApi* | [**v1_delete_project**](si_tests/clients/gcore/box_api/docs/ProjectsApi.md#v1_delete_project) | **DELETE** /v1/admin/projects/{project_name} | Delete project
*ProjectsApi* | [**v1_list_projects**](si_tests/clients/gcore/box_api/docs/ProjectsApi.md#v1_list_projects) | **GET** /v1/projects | List projects
*PullSecretsApi* | [**v1_create_pull_secret**](si_tests/clients/gcore/box_api/docs/PullSecretsApi.md#v1_create_pull_secret) | **POST** /v1/{project_name}/pullsecrets | Create pull secret
*PullSecretsApi* | [**v1_delete_pull_secret**](si_tests/clients/gcore/box_api/docs/PullSecretsApi.md#v1_delete_pull_secret) | **DELETE** /v1/{project_name}/pullsecrets/{pullsecret_name} | Delete pull secret
*PullSecretsApi* | [**v1_get_pull_secret**](si_tests/clients/gcore/box_api/docs/PullSecretsApi.md#v1_get_pull_secret) | **GET** /v1/{project_name}/pullsecrets/{pullsecret_name} | Get pull secret
*PullSecretsApi* | [**v1_list_pull_secrets**](si_tests/clients/gcore/box_api/docs/PullSecretsApi.md#v1_list_pull_secrets) | **GET** /v1/{project_name}/pullsecrets | List pull secrets
*PullSecretsApi* | [**v1_update_pull_secret**](si_tests/clients/gcore/box_api/docs/PullSecretsApi.md#v1_update_pull_secret) | **PUT** /v1/{project_name}/pullsecrets/{pullsecret_name} | Update pull secret
*QuotasApi* | [**admin_create_quota**](si_tests/clients/gcore/box_api/docs/QuotasApi.md#admin_create_quota) | **POST** /v1/admin/quotas/{project_name} | Create quota
*QuotasApi* | [**admin_delete_quota**](si_tests/clients/gcore/box_api/docs/QuotasApi.md#admin_delete_quota) | **DELETE** /v1/admin/quotas/{project_name} | Delete quota
*QuotasApi* | [**admin_list_quota_resource_types**](si_tests/clients/gcore/box_api/docs/QuotasApi.md#admin_list_quota_resource_types) | **GET** /v1/admin/quotas/resource-types | List available resource types
*QuotasApi* | [**admin_list_quotas**](si_tests/clients/gcore/box_api/docs/QuotasApi.md#admin_list_quotas) | **GET** /v1/admin/quotas | List quotas
*QuotasApi* | [**admin_update_quota**](si_tests/clients/gcore/box_api/docs/QuotasApi.md#admin_update_quota) | **PUT** /v1/admin/quotas/{project_name} | Update quota
*QuotasApi* | [**get_admin_quota**](si_tests/clients/gcore/box_api/docs/QuotasApi.md#get_admin_quota) | **GET** /v1/admin/quotas/{project_name} | Get quota
*QuotasApi* | [**get_quota**](si_tests/clients/gcore/box_api/docs/QuotasApi.md#get_quota) | **GET** /v1/quotas/{project_name} | Get quota
*RegionsApi* | [**v1_list_regions**](si_tests/clients/gcore/box_api/docs/RegionsApi.md#v1_list_regions) | **GET** /v1/regions | List regions
*RegistriesApi* | [**v1_create_registry**](si_tests/clients/gcore/box_api/docs/RegistriesApi.md#v1_create_registry) | **POST** /v1/{project_name}/registries | Create container registry
*RegistriesApi* | [**v1_delete_registry**](si_tests/clients/gcore/box_api/docs/RegistriesApi.md#v1_delete_registry) | **DELETE** /v1/{project_name}/registries/{registry_name} | Delete container registry
*RegistriesApi* | [**v1_delete_registry_image**](si_tests/clients/gcore/box_api/docs/RegistriesApi.md#v1_delete_registry_image) | **DELETE** /v1/{project_name}/registries/{registry_name}/images/{image_name} | Delete registry image
*RegistriesApi* | [**v1_get_registry**](si_tests/clients/gcore/box_api/docs/RegistriesApi.md#v1_get_registry) | **GET** /v1/{project_name}/registries/{registry_name} | Get container registry
*RegistriesApi* | [**v1_list_registries**](si_tests/clients/gcore/box_api/docs/RegistriesApi.md#v1_list_registries) | **GET** /v1/{project_name}/registries | List container registries
*RegistriesApi* | [**v1_list_registry_images**](si_tests/clients/gcore/box_api/docs/RegistriesApi.md#v1_list_registry_images) | **GET** /v1/{project_name}/registries/{registry_name}/images | List registry images
*RegistriesApi* | [**v1_update_registry**](si_tests/clients/gcore/box_api/docs/RegistriesApi.md#v1_update_registry) | **PUT** /v1/{project_name}/registries/{registry_name} | Update container registry
*RegistryUsersApi* | [**v1_create_registry_user**](si_tests/clients/gcore/box_api/docs/RegistryUsersApi.md#v1_create_registry_user) | **POST** /v1/{project_name}/registries/{registry_name}/users | Create registry user
*RegistryUsersApi* | [**v1_delete_registry_user**](si_tests/clients/gcore/box_api/docs/RegistryUsersApi.md#v1_delete_registry_user) | **DELETE** /v1/{project_name}/registries/{registry_name}/users/{username} | Delete registry user
*RegistryUsersApi* | [**v1_get_registry_user**](si_tests/clients/gcore/box_api/docs/RegistryUsersApi.md#v1_get_registry_user) | **GET** /v1/{project_name}/registries/{registry_name}/users/{username} | Get registry user
*RegistryUsersApi* | [**v1_get_registry_user_pull_secret**](si_tests/clients/gcore/box_api/docs/RegistryUsersApi.md#v1_get_registry_user_pull_secret) | **GET** /v1/{project_name}/registries/{registry_name}/users/{username}/pullsecret | Get registry user pull secret
*RegistryUsersApi* | [**v1_list_registry_users**](si_tests/clients/gcore/box_api/docs/RegistryUsersApi.md#v1_list_registry_users) | **GET** /v1/{project_name}/registries/{registry_name}/users | List registry users
*RegistryUsersApi* | [**v1_update_registry_user**](si_tests/clients/gcore/box_api/docs/RegistryUsersApi.md#v1_update_registry_user) | **PUT** /v1/{project_name}/registries/{registry_name}/users/{username} | Update registry user
*SecretsApi* | [**v1_create_secret**](si_tests/clients/gcore/box_api/docs/SecretsApi.md#v1_create_secret) | **POST** /v1/{project_name}/secrets | Create secret
*SecretsApi* | [**v1_delete_secret**](si_tests/clients/gcore/box_api/docs/SecretsApi.md#v1_delete_secret) | **DELETE** /v1/{project_name}/secrets/{secret_name} | Delete secret
*SecretsApi* | [**v1_get_secret**](si_tests/clients/gcore/box_api/docs/SecretsApi.md#v1_get_secret) | **GET** /v1/{project_name}/secrets/{secret_name} | Get secret
*SecretsApi* | [**v1_list_secrets**](si_tests/clients/gcore/box_api/docs/SecretsApi.md#v1_list_secrets) | **GET** /v1/{project_name}/secrets | List secrets
*SecretsApi* | [**v1_update_secret**](si_tests/clients/gcore/box_api/docs/SecretsApi.md#v1_update_secret) | **PATCH** /v1/{project_name}/secrets/{secret_name} | Update secret
*SlurmApi* | [**v1_create_slurm_cluster**](si_tests/clients/gcore/box_api/docs/SlurmApi.md#v1_create_slurm_cluster) | **POST** /v1/{project_name}/slurm/clusters | Create Slurm cluster
*SlurmApi* | [**v1_delete_slurm_cluster**](si_tests/clients/gcore/box_api/docs/SlurmApi.md#v1_delete_slurm_cluster) | **DELETE** /v1/{project_name}/slurm/clusters/{region_name} | Delete Slurm cluster
*SlurmApi* | [**v1_get_slurm_cluster**](si_tests/clients/gcore/box_api/docs/SlurmApi.md#v1_get_slurm_cluster) | **GET** /v1/{project_name}/slurm/clusters/{region_name} | Get Slurm cluster
*SlurmApi* | [**v1_list_slurm_clusters**](si_tests/clients/gcore/box_api/docs/SlurmApi.md#v1_list_slurm_clusters) | **GET** /v1/{project_name}/slurm/clusters | List Slurm clusters
*SlurmApi* | [**v1_update_slurm_cluster**](si_tests/clients/gcore/box_api/docs/SlurmApi.md#v1_update_slurm_cluster) | **PATCH** /v1/{project_name}/slurm/clusters/{region_name} | Update Slurm cluster
*TLSSecretsApi* | [**v1_create_tls_secret**](si_tests/clients/gcore/box_api/docs/TLSSecretsApi.md#v1_create_tls_secret) | **POST** /v1/{project_name}/tlssecrets | Create tls secret
*TLSSecretsApi* | [**v1_delete_tls_secret**](si_tests/clients/gcore/box_api/docs/TLSSecretsApi.md#v1_delete_tls_secret) | **DELETE** /v1/{project_name}/tlssecrets/{secret_name} | Delete tls secret
*TLSSecretsApi* | [**v1_get_tls_secret**](si_tests/clients/gcore/box_api/docs/TLSSecretsApi.md#v1_get_tls_secret) | **GET** /v1/{project_name}/tlssecrets/{secret_name} | Get tls secret
*TLSSecretsApi* | [**v1_list_tls_secrets**](si_tests/clients/gcore/box_api/docs/TLSSecretsApi.md#v1_list_tls_secrets) | **GET** /v1/{project_name}/tlssecrets | List tls secrets
*TLSSecretsApi* | [**v1_update_tls_secret**](si_tests/clients/gcore/box_api/docs/TLSSecretsApi.md#v1_update_tls_secret) | **PATCH** /v1/{project_name}/tlssecrets/{secret_name} | Update tls secret
*UserGroupsApi* | [**v1_create_group**](si_tests/clients/gcore/box_api/docs/UserGroupsApi.md#v1_create_group) | **POST** /v1/admin/groups | Create user group
*UserGroupsApi* | [**v1_delete_group**](si_tests/clients/gcore/box_api/docs/UserGroupsApi.md#v1_delete_group) | **DELETE** /v1/admin/groups/{group_name} | Delete user group
*UserGroupsApi* | [**v1_get_group**](si_tests/clients/gcore/box_api/docs/UserGroupsApi.md#v1_get_group) | **GET** /v1/admin/groups/{group_name} | Get user group
*UserGroupsApi* | [**v1_groups_list**](si_tests/clients/gcore/box_api/docs/UserGroupsApi.md#v1_groups_list) | **GET** /v1/users/me/groups | Get current user&#39;s groups
*UserGroupsApi* | [**v1_list_groups**](si_tests/clients/gcore/box_api/docs/UserGroupsApi.md#v1_list_groups) | **GET** /v1/admin/groups | List user groups
*UserGroupsApi* | [**v1_replace_group**](si_tests/clients/gcore/box_api/docs/UserGroupsApi.md#v1_replace_group) | **PUT** /v1/admin/groups/{group_name} | Replace user group
*UsersApi* | [**v1_create_user**](si_tests/clients/gcore/box_api/docs/UsersApi.md#v1_create_user) | **POST** /v1/admin/users | Create user
*UsersApi* | [**v1_delete_user**](si_tests/clients/gcore/box_api/docs/UsersApi.md#v1_delete_user) | **DELETE** /v1/admin/users/{user_name} | Delete user
*UsersApi* | [**v1_get_user**](si_tests/clients/gcore/box_api/docs/UsersApi.md#v1_get_user) | **GET** /v1/admin/users/{user_name} | Get user
*UsersApi* | [**v1_get_user_secret**](si_tests/clients/gcore/box_api/docs/UsersApi.md#v1_get_user_secret) | **GET** /v1/admin/users/{user_name}/secret | Get user password
*UsersApi* | [**v1_list_users**](si_tests/clients/gcore/box_api/docs/UsersApi.md#v1_list_users) | **GET** /v1/admin/users | List users
*UsersApi* | [**v1_login_user**](si_tests/clients/gcore/box_api/docs/UsersApi.md#v1_login_user) | **POST** /v1/login | Login user
*UsersApi* | [**v1_refresh_user_token**](si_tests/clients/gcore/box_api/docs/UsersApi.md#v1_refresh_user_token) | **POST** /v1/refresh | Refresh user&#39;s token
*UsersApi* | [**v1_update_user**](si_tests/clients/gcore/box_api/docs/UsersApi.md#v1_update_user) | **PUT** /v1/admin/users/{user_name} | Update user
*UsersApi* | [**v1_update_user_secret**](si_tests/clients/gcore/box_api/docs/UsersApi.md#v1_update_user_secret) | **PUT** /v1/admin/users/{user_name}/secret | Update user password
*UsersApi* | [**v1_who_am_i**](si_tests/clients/gcore/box_api/docs/UsersApi.md#v1_who_am_i) | **GET** /v1/users/me | Get current user
*VolumesApi* | [**v1_create_volume**](si_tests/clients/gcore/box_api/docs/VolumesApi.md#v1_create_volume) | **POST** /v1/{project_name}/volumes | Create volume
*VolumesApi* | [**v1_delete_volume**](si_tests/clients/gcore/box_api/docs/VolumesApi.md#v1_delete_volume) | **DELETE** /v1/{project_name}/volumes/{volume_name} | Delete volume
*VolumesApi* | [**v1_get_volume**](si_tests/clients/gcore/box_api/docs/VolumesApi.md#v1_get_volume) | **GET** /v1/{project_name}/volumes/{volume_name} | Get volume
*VolumesApi* | [**v1_list_storage_classes**](si_tests/clients/gcore/box_api/docs/VolumesApi.md#v1_list_storage_classes) | **GET** /v1/volumes/storageclasses | List storage classes
*VolumesApi* | [**v1_list_volumes**](si_tests/clients/gcore/box_api/docs/VolumesApi.md#v1_list_volumes) | **GET** /v1/{project_name}/volumes | List volumes
*VolumesApi* | [**v1_update_volume**](si_tests/clients/gcore/box_api/docs/VolumesApi.md#v1_update_volume) | **PUT** /v1/{project_name}/volumes/{volume_name} | Update volume


## Documentation For Models

 - [ApiErrorResponse](si_tests/clients/gcore/box_api/docs/ApiErrorResponse.md)
 - [ApiServicesAutodiscoveriesV1ListNodesResponse](si_tests/clients/gcore/box_api/docs/ApiServicesAutodiscoveriesV1ListNodesResponse.md)
 - [ApiServicesAutodiscoveriesV1NodeResponse](si_tests/clients/gcore/box_api/docs/ApiServicesAutodiscoveriesV1NodeResponse.md)
 - [ApiServicesInferenceV1Flavor](si_tests/clients/gcore/box_api/docs/ApiServicesInferenceV1Flavor.md)
 - [ApiServicesInferenceV1Volume](si_tests/clients/gcore/box_api/docs/ApiServicesInferenceV1Volume.md)
 - [ApiServicesNodegroupsV1ListNodesResponse](si_tests/clients/gcore/box_api/docs/ApiServicesNodegroupsV1ListNodesResponse.md)
 - [ApiServicesNodegroupsV1NodeResponse](si_tests/clients/gcore/box_api/docs/ApiServicesNodegroupsV1NodeResponse.md)
 - [ApiServicesOverviewV1PreheatPolicy](si_tests/clients/gcore/box_api/docs/ApiServicesOverviewV1PreheatPolicy.md)
 - [ApiServicesOverviewV1PreheatPolicyFilters](si_tests/clients/gcore/box_api/docs/ApiServicesOverviewV1PreheatPolicyFilters.md)
 - [ApiServicesOverviewV1PreheatPolicyTrigger](si_tests/clients/gcore/box_api/docs/ApiServicesOverviewV1PreheatPolicyTrigger.md)
 - [ApiServicesOverviewV1Region](si_tests/clients/gcore/box_api/docs/ApiServicesOverviewV1Region.md)
 - [ApiServicesOverviewV1RegistryResponse](si_tests/clients/gcore/box_api/docs/ApiServicesOverviewV1RegistryResponse.md)
 - [ApiServicesRegistriesV1PreheatPolicy](si_tests/clients/gcore/box_api/docs/ApiServicesRegistriesV1PreheatPolicy.md)
 - [ApiServicesRegistriesV1PreheatPolicyFilters](si_tests/clients/gcore/box_api/docs/ApiServicesRegistriesV1PreheatPolicyFilters.md)
 - [ApiServicesRegistriesV1PreheatPolicyTrigger](si_tests/clients/gcore/box_api/docs/ApiServicesRegistriesV1PreheatPolicyTrigger.md)
 - [ApiServicesRegistriesV1RegistryResponse](si_tests/clients/gcore/box_api/docs/ApiServicesRegistriesV1RegistryResponse.md)
 - [ApiServicesSecretsV1SecretResponse](si_tests/clients/gcore/box_api/docs/ApiServicesSecretsV1SecretResponse.md)
 - [ApiServicesUsersV1SecretResponse](si_tests/clients/gcore/box_api/docs/ApiServicesUsersV1SecretResponse.md)
 - [ApiUtilReferencesObjectReference](si_tests/clients/gcore/box_api/docs/ApiUtilReferencesObjectReference.md)
 - [ApiValidationErrorResponse](si_tests/clients/gcore/box_api/docs/ApiValidationErrorResponse.md)
 - [AutodiscoveryRegionType](si_tests/clients/gcore/box_api/docs/AutodiscoveryRegionType.md)
 - [SchemasApp](si_tests/clients/gcore/box_api/docs/SchemasApp.md)
 - [SchemasAppComponent](si_tests/clients/gcore/box_api/docs/SchemasAppComponent.md)
 - [SchemasAppDeployment](si_tests/clients/gcore/box_api/docs/SchemasAppDeployment.md)
 - [SchemasAppDeploymentCreateRequest](si_tests/clients/gcore/box_api/docs/SchemasAppDeploymentCreateRequest.md)
 - [SchemasAppDeploymentList](si_tests/clients/gcore/box_api/docs/SchemasAppDeploymentList.md)
 - [SchemasAppDeploymentPatchRequest](si_tests/clients/gcore/box_api/docs/SchemasAppDeploymentPatchRequest.md)
 - [SchemasAppInference](si_tests/clients/gcore/box_api/docs/SchemasAppInference.md)
 - [SchemasAppListResponse](si_tests/clients/gcore/box_api/docs/SchemasAppListResponse.md)
 - [SchemasComponentConfiguration](si_tests/clients/gcore/box_api/docs/SchemasComponentConfiguration.md)
 - [SchemasComponentConfigurationPatch](si_tests/clients/gcore/box_api/docs/SchemasComponentConfigurationPatch.md)
 - [SchemasComponentStatus](si_tests/clients/gcore/box_api/docs/SchemasComponentStatus.md)
 - [SchemasExposeAddress](si_tests/clients/gcore/box_api/docs/SchemasExposeAddress.md)
 - [SchemasParameter](si_tests/clients/gcore/box_api/docs/SchemasParameter.md)
 - [SchemasParameterOverride](si_tests/clients/gcore/box_api/docs/SchemasParameterOverride.md)
 - [SchemasParameterType](si_tests/clients/gcore/box_api/docs/SchemasParameterType.md)
 - [SchemasRegionStatus](si_tests/clients/gcore/box_api/docs/SchemasRegionStatus.md)
 - [SchemasScale](si_tests/clients/gcore/box_api/docs/SchemasScale.md)
 - [SchemasScalePatch](si_tests/clients/gcore/box_api/docs/SchemasScalePatch.md)
 - [SchemasShortFlavor](si_tests/clients/gcore/box_api/docs/SchemasShortFlavor.md)
 - [SchemasStatus](si_tests/clients/gcore/box_api/docs/SchemasStatus.md)
 - [V1AccessRule](si_tests/clients/gcore/box_api/docs/V1AccessRule.md)
 - [V1ActionRequests](si_tests/clients/gcore/box_api/docs/V1ActionRequests.md)
 - [V1ApiKeyResponse](si_tests/clients/gcore/box_api/docs/V1ApiKeyResponse.md)
 - [V1AuditLogResponse](si_tests/clients/gcore/box_api/docs/V1AuditLogResponse.md)
 - [V1AuditLogsResponse](si_tests/clients/gcore/box_api/docs/V1AuditLogsResponse.md)
 - [V1Cluster](si_tests/clients/gcore/box_api/docs/V1Cluster.md)
 - [V1ContainerProbe](si_tests/clients/gcore/box_api/docs/V1ContainerProbe.md)
 - [V1CpuTrigger](si_tests/clients/gcore/box_api/docs/V1CpuTrigger.md)
 - [V1CreateApiKeyRequest](si_tests/clients/gcore/box_api/docs/V1CreateApiKeyRequest.md)
 - [V1CreateFlavorRequest](si_tests/clients/gcore/box_api/docs/V1CreateFlavorRequest.md)
 - [V1CreateGroupRequest](si_tests/clients/gcore/box_api/docs/V1CreateGroupRequest.md)
 - [V1CreateInferenceRequest](si_tests/clients/gcore/box_api/docs/V1CreateInferenceRequest.md)
 - [V1CreateInstanceRequest](si_tests/clients/gcore/box_api/docs/V1CreateInstanceRequest.md)
 - [V1CreateInstanceResponse](si_tests/clients/gcore/box_api/docs/V1CreateInstanceResponse.md)
 - [V1CreateNamespaceRequest](si_tests/clients/gcore/box_api/docs/V1CreateNamespaceRequest.md)
 - [V1CreateNodeGroupRequest](si_tests/clients/gcore/box_api/docs/V1CreateNodeGroupRequest.md)
 - [V1CreateProjectRequest](si_tests/clients/gcore/box_api/docs/V1CreateProjectRequest.md)
 - [V1CreatePullSecretRequest](si_tests/clients/gcore/box_api/docs/V1CreatePullSecretRequest.md)
 - [V1CreateQuotaRequest](si_tests/clients/gcore/box_api/docs/V1CreateQuotaRequest.md)
 - [V1CreateRegistryRequest](si_tests/clients/gcore/box_api/docs/V1CreateRegistryRequest.md)
 - [V1CreateRegistryUserRequest](si_tests/clients/gcore/box_api/docs/V1CreateRegistryUserRequest.md)
 - [V1CreateScaleRequest](si_tests/clients/gcore/box_api/docs/V1CreateScaleRequest.md)
 - [V1CreateScaleTriggers](si_tests/clients/gcore/box_api/docs/V1CreateScaleTriggers.md)
 - [V1CreateSecretRequest](si_tests/clients/gcore/box_api/docs/V1CreateSecretRequest.md)
 - [V1CreateSlurmClusterLoginConfig](si_tests/clients/gcore/box_api/docs/V1CreateSlurmClusterLoginConfig.md)
 - [V1CreateSlurmClusterRequest](si_tests/clients/gcore/box_api/docs/V1CreateSlurmClusterRequest.md)
 - [V1CreateSlurmClusterWorkerConfig](si_tests/clients/gcore/box_api/docs/V1CreateSlurmClusterWorkerConfig.md)
 - [V1CreateSubRegionRequest](si_tests/clients/gcore/box_api/docs/V1CreateSubRegionRequest.md)
 - [V1CreateTlsSecretRequest](si_tests/clients/gcore/box_api/docs/V1CreateTlsSecretRequest.md)
 - [V1CreateUserRequest](si_tests/clients/gcore/box_api/docs/V1CreateUserRequest.md)
 - [V1CreateVolumeRequest](si_tests/clients/gcore/box_api/docs/V1CreateVolumeRequest.md)
 - [V1DeploymentStatus](si_tests/clients/gcore/box_api/docs/V1DeploymentStatus.md)
 - [V1DeschedulePodRequest](si_tests/clients/gcore/box_api/docs/V1DeschedulePodRequest.md)
 - [V1EmptyDirVolumeSource](si_tests/clients/gcore/box_api/docs/V1EmptyDirVolumeSource.md)
 - [V1ExecProbe](si_tests/clients/gcore/box_api/docs/V1ExecProbe.md)
 - [V1FlavorRef](si_tests/clients/gcore/box_api/docs/V1FlavorRef.md)
 - [V1FlavorResponse](si_tests/clients/gcore/box_api/docs/V1FlavorResponse.md)
 - [V1GetApiKeyResponse](si_tests/clients/gcore/box_api/docs/V1GetApiKeyResponse.md)
 - [V1GetInstanceResponse](si_tests/clients/gcore/box_api/docs/V1GetInstanceResponse.md)
 - [V1GetMetricsForPodResponse](si_tests/clients/gcore/box_api/docs/V1GetMetricsForPodResponse.md)
 - [V1GetPodsMetricsResponse](si_tests/clients/gcore/box_api/docs/V1GetPodsMetricsResponse.md)
 - [V1GpuMemoryTrigger](si_tests/clients/gcore/box_api/docs/V1GpuMemoryTrigger.md)
 - [V1GpuUtilizationTrigger](si_tests/clients/gcore/box_api/docs/V1GpuUtilizationTrigger.md)
 - [V1GroupResponse](si_tests/clients/gcore/box_api/docs/V1GroupResponse.md)
 - [V1HttpGetProbe](si_tests/clients/gcore/box_api/docs/V1HttpGetProbe.md)
 - [V1HttpTrigger](si_tests/clients/gcore/box_api/docs/V1HttpTrigger.md)
 - [V1ImageResponse](si_tests/clients/gcore/box_api/docs/V1ImageResponse.md)
 - [V1ImageVolumeSource](si_tests/clients/gcore/box_api/docs/V1ImageVolumeSource.md)
 - [V1InferenceAPIKeySecretResponse](si_tests/clients/gcore/box_api/docs/V1InferenceAPIKeySecretResponse.md)
 - [V1InferenceLog](si_tests/clients/gcore/box_api/docs/V1InferenceLog.md)
 - [V1InferenceLogsResponse](si_tests/clients/gcore/box_api/docs/V1InferenceLogsResponse.md)
 - [V1InferenceResponse](si_tests/clients/gcore/box_api/docs/V1InferenceResponse.md)
 - [V1IngressOpts](si_tests/clients/gcore/box_api/docs/V1IngressOpts.md)
 - [V1ListApiKeysResponse](si_tests/clients/gcore/box_api/docs/V1ListApiKeysResponse.md)
 - [V1ListFlavorResponse](si_tests/clients/gcore/box_api/docs/V1ListFlavorResponse.md)
 - [V1ListGroupResponse](si_tests/clients/gcore/box_api/docs/V1ListGroupResponse.md)
 - [V1ListImagesResponse](si_tests/clients/gcore/box_api/docs/V1ListImagesResponse.md)
 - [V1ListInferenceResponse](si_tests/clients/gcore/box_api/docs/V1ListInferenceResponse.md)
 - [V1ListInstanceResponse](si_tests/clients/gcore/box_api/docs/V1ListInstanceResponse.md)
 - [V1ListNamespaceResponse](si_tests/clients/gcore/box_api/docs/V1ListNamespaceResponse.md)
 - [V1ListNodeGroupResponse](si_tests/clients/gcore/box_api/docs/V1ListNodeGroupResponse.md)
 - [V1ListProjectResponse](si_tests/clients/gcore/box_api/docs/V1ListProjectResponse.md)
 - [V1ListPullSecretResponse](si_tests/clients/gcore/box_api/docs/V1ListPullSecretResponse.md)
 - [V1ListQuotasResponse](si_tests/clients/gcore/box_api/docs/V1ListQuotasResponse.md)
 - [V1ListRegionResponse](si_tests/clients/gcore/box_api/docs/V1ListRegionResponse.md)
 - [V1ListRegistryResponse](si_tests/clients/gcore/box_api/docs/V1ListRegistryResponse.md)
 - [V1ListRegistryUserResponse](si_tests/clients/gcore/box_api/docs/V1ListRegistryUserResponse.md)
 - [V1ListSecretResponse](si_tests/clients/gcore/box_api/docs/V1ListSecretResponse.md)
 - [V1ListSlurmClustersResponse](si_tests/clients/gcore/box_api/docs/V1ListSlurmClustersResponse.md)
 - [V1ListStorageClassesResponse](si_tests/clients/gcore/box_api/docs/V1ListStorageClassesResponse.md)
 - [V1ListSubRegionResponse](si_tests/clients/gcore/box_api/docs/V1ListSubRegionResponse.md)
 - [V1ListTlsSecretResponse](si_tests/clients/gcore/box_api/docs/V1ListTlsSecretResponse.md)
 - [V1ListUserResponse](si_tests/clients/gcore/box_api/docs/V1ListUserResponse.md)
 - [V1ListVolumesResponse](si_tests/clients/gcore/box_api/docs/V1ListVolumesResponse.md)
 - [V1Logging](si_tests/clients/gcore/box_api/docs/V1Logging.md)
 - [V1LoginResponse](si_tests/clients/gcore/box_api/docs/V1LoginResponse.md)
 - [V1LoginUserRequest](si_tests/clients/gcore/box_api/docs/V1LoginUserRequest.md)
 - [V1MemoryTrigger](si_tests/clients/gcore/box_api/docs/V1MemoryTrigger.md)
 - [V1MetricsQueryData](si_tests/clients/gcore/box_api/docs/V1MetricsQueryData.md)
 - [V1MetricsQueryResponse](si_tests/clients/gcore/box_api/docs/V1MetricsQueryResponse.md)
 - [V1NamespaceResponse](si_tests/clients/gcore/box_api/docs/V1NamespaceResponse.md)
 - [V1Node](si_tests/clients/gcore/box_api/docs/V1Node.md)
 - [V1NodeGroupResponse](si_tests/clients/gcore/box_api/docs/V1NodeGroupResponse.md)
 - [V1NodeListResponse](si_tests/clients/gcore/box_api/docs/V1NodeListResponse.md)
 - [V1NodesPerRegion](si_tests/clients/gcore/box_api/docs/V1NodesPerRegion.md)
 - [V1OverviewResponse](si_tests/clients/gcore/box_api/docs/V1OverviewResponse.md)
 - [V1PVCVolumeSource](si_tests/clients/gcore/box_api/docs/V1PVCVolumeSource.md)
 - [V1PatchApiKeyRequest](si_tests/clients/gcore/box_api/docs/V1PatchApiKeyRequest.md)
 - [V1PatchSlurmClusterRequest](si_tests/clients/gcore/box_api/docs/V1PatchSlurmClusterRequest.md)
 - [V1PatchSlurmClusterWorkerConfig](si_tests/clients/gcore/box_api/docs/V1PatchSlurmClusterWorkerConfig.md)
 - [V1Pod](si_tests/clients/gcore/box_api/docs/V1Pod.md)
 - [V1ProbeConfiguration](si_tests/clients/gcore/box_api/docs/V1ProbeConfiguration.md)
 - [V1Probes](si_tests/clients/gcore/box_api/docs/V1Probes.md)
 - [V1ProjectResponse](si_tests/clients/gcore/box_api/docs/V1ProjectResponse.md)
 - [V1PullSecretResponse](si_tests/clients/gcore/box_api/docs/V1PullSecretResponse.md)
 - [V1QuotaResponse](si_tests/clients/gcore/box_api/docs/V1QuotaResponse.md)
 - [V1RefreshRequest](si_tests/clients/gcore/box_api/docs/V1RefreshRequest.md)
 - [V1RegionResponse](si_tests/clients/gcore/box_api/docs/V1RegionResponse.md)
 - [V1RegionalVolumeStatus](si_tests/clients/gcore/box_api/docs/V1RegionalVolumeStatus.md)
 - [V1RegistryImageRef](si_tests/clients/gcore/box_api/docs/V1RegistryImageRef.md)
 - [V1RegistryRef](si_tests/clients/gcore/box_api/docs/V1RegistryRef.md)
 - [V1RegistryUserRef](si_tests/clients/gcore/box_api/docs/V1RegistryUserRef.md)
 - [V1RegistryUserResponse](si_tests/clients/gcore/box_api/docs/V1RegistryUserResponse.md)
 - [V1ResourceTypesResponse](si_tests/clients/gcore/box_api/docs/V1ResourceTypesResponse.md)
 - [V1Scale](si_tests/clients/gcore/box_api/docs/V1Scale.md)
 - [V1SlurmClusterLoginConfig](si_tests/clients/gcore/box_api/docs/V1SlurmClusterLoginConfig.md)
 - [V1SlurmClusterResponse](si_tests/clients/gcore/box_api/docs/V1SlurmClusterResponse.md)
 - [V1SlurmClusterWorkerConfig](si_tests/clients/gcore/box_api/docs/V1SlurmClusterWorkerConfig.md)
 - [V1SqsTrigger](si_tests/clients/gcore/box_api/docs/V1SqsTrigger.md)
 - [V1Status](si_tests/clients/gcore/box_api/docs/V1Status.md)
 - [V1StorageClassResponse](si_tests/clients/gcore/box_api/docs/V1StorageClassResponse.md)
 - [V1SubRegionResponse](si_tests/clients/gcore/box_api/docs/V1SubRegionResponse.md)
 - [V1TcpSocketProbe](si_tests/clients/gcore/box_api/docs/V1TcpSocketProbe.md)
 - [V1TlsSecretResponse](si_tests/clients/gcore/box_api/docs/V1TlsSecretResponse.md)
 - [V1TriggersResponse](si_tests/clients/gcore/box_api/docs/V1TriggersResponse.md)
 - [V1UpdateApiKeyRequest](si_tests/clients/gcore/box_api/docs/V1UpdateApiKeyRequest.md)
 - [V1UpdateGroupRequest](si_tests/clients/gcore/box_api/docs/V1UpdateGroupRequest.md)
 - [V1UpdateInferenceRequest](si_tests/clients/gcore/box_api/docs/V1UpdateInferenceRequest.md)
 - [V1UpdateInstanceRequest](si_tests/clients/gcore/box_api/docs/V1UpdateInstanceRequest.md)
 - [V1UpdateInstanceResponse](si_tests/clients/gcore/box_api/docs/V1UpdateInstanceResponse.md)
 - [V1UpdateNodeGroupRequest](si_tests/clients/gcore/box_api/docs/V1UpdateNodeGroupRequest.md)
 - [V1UpdatePullSecretRequest](si_tests/clients/gcore/box_api/docs/V1UpdatePullSecretRequest.md)
 - [V1UpdateQuotaRequest](si_tests/clients/gcore/box_api/docs/V1UpdateQuotaRequest.md)
 - [V1UpdateRegistryRequest](si_tests/clients/gcore/box_api/docs/V1UpdateRegistryRequest.md)
 - [V1UpdateRegistryUserRequest](si_tests/clients/gcore/box_api/docs/V1UpdateRegistryUserRequest.md)
 - [V1UpdateSecretRequest](si_tests/clients/gcore/box_api/docs/V1UpdateSecretRequest.md)
 - [V1UpdateSubRegionRequest](si_tests/clients/gcore/box_api/docs/V1UpdateSubRegionRequest.md)
 - [V1UpdateTlsSecretRequest](si_tests/clients/gcore/box_api/docs/V1UpdateTlsSecretRequest.md)
 - [V1UpdateUserRequest](si_tests/clients/gcore/box_api/docs/V1UpdateUserRequest.md)
 - [V1UpdateUserSecretRequest](si_tests/clients/gcore/box_api/docs/V1UpdateUserSecretRequest.md)
 - [V1UpdateVolumeRequest](si_tests/clients/gcore/box_api/docs/V1UpdateVolumeRequest.md)
 - [V1UserResponse](si_tests/clients/gcore/box_api/docs/V1UserResponse.md)
 - [V1VolumeResponse](si_tests/clients/gcore/box_api/docs/V1VolumeResponse.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="ApiKeyAuth"></a>
### ApiKeyAuth

- **Type**: API key
- **API key parameter name**: X-API-Key
- **Location**: HTTP header


## Author




