# si_tests.clients.gcore.box_api.VolumesApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1_create_volume**](VolumesApi.md#v1_create_volume) | **POST** /v1/{project_name}/volumes | Create volume
[**v1_delete_volume**](VolumesApi.md#v1_delete_volume) | **DELETE** /v1/{project_name}/volumes/{volume_name} | Delete volume
[**v1_get_volume**](VolumesApi.md#v1_get_volume) | **GET** /v1/{project_name}/volumes/{volume_name} | Get volume
[**v1_list_storage_classes**](VolumesApi.md#v1_list_storage_classes) | **GET** /v1/volumes/storageclasses | List storage classes
[**v1_list_volumes**](VolumesApi.md#v1_list_volumes) | **GET** /v1/{project_name}/volumes | List volumes
[**v1_update_volume**](VolumesApi.md#v1_update_volume) | **PUT** /v1/{project_name}/volumes/{volume_name} | Update volume


# **v1_create_volume**
> V1VolumeResponse v1_create_volume(project_name, v1_create_volume_request)

Create volume

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_create_volume_request import V1CreateVolumeRequest
from si_tests.clients.gcore.box_api.models.v1_volume_response import V1VolumeResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.VolumesApi(api_client)
    project_name = 'project_name_example' # str | Project name
    v1_create_volume_request = si_tests.clients.gcore.box_api.V1CreateVolumeRequest() # V1CreateVolumeRequest | Volume body

    try:
        # Create volume
        api_response = api_instance.v1_create_volume(project_name, v1_create_volume_request)
        print("The response of VolumesApi->v1_create_volume:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling VolumesApi->v1_create_volume: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **v1_create_volume_request** | [**V1CreateVolumeRequest**](V1CreateVolumeRequest.md)| Volume body | 

### Return type

[**V1VolumeResponse**](V1VolumeResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_delete_volume**
> v1_delete_volume(project_name, volume_name)

Delete volume

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.VolumesApi(api_client)
    project_name = 'project_name_example' # str | Project name
    volume_name = 'volume_name_example' # str | Volume name

    try:
        # Delete volume
        api_instance.v1_delete_volume(project_name, volume_name)
    except Exception as e:
        print("Exception when calling VolumesApi->v1_delete_volume: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **volume_name** | **str**| Volume name | 

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_get_volume**
> V1VolumeResponse v1_get_volume(project_name, volume_name)

Get volume

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_volume_response import V1VolumeResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.VolumesApi(api_client)
    project_name = 'project_name_example' # str | Project name
    volume_name = 'volume_name_example' # str | Volume name

    try:
        # Get volume
        api_response = api_instance.v1_get_volume(project_name, volume_name)
        print("The response of VolumesApi->v1_get_volume:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling VolumesApi->v1_get_volume: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **volume_name** | **str**| Volume name | 

### Return type

[**V1VolumeResponse**](V1VolumeResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_list_storage_classes**
> V1ListStorageClassesResponse v1_list_storage_classes()

List storage classes

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_list_storage_classes_response import V1ListStorageClassesResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.VolumesApi(api_client)

    try:
        # List storage classes
        api_response = api_instance.v1_list_storage_classes()
        print("The response of VolumesApi->v1_list_storage_classes:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling VolumesApi->v1_list_storage_classes: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**V1ListStorageClassesResponse**](V1ListStorageClassesResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_list_volumes**
> V1ListVolumesResponse v1_list_volumes(project_name)

List volumes

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_list_volumes_response import V1ListVolumesResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.VolumesApi(api_client)
    project_name = 'project_name_example' # str | Project name

    try:
        # List volumes
        api_response = api_instance.v1_list_volumes(project_name)
        print("The response of VolumesApi->v1_list_volumes:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling VolumesApi->v1_list_volumes: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 

### Return type

[**V1ListVolumesResponse**](V1ListVolumesResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_update_volume**
> V1VolumeResponse v1_update_volume(project_name, volume_name, v1_update_volume_request)

Update volume

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_update_volume_request import V1UpdateVolumeRequest
from si_tests.clients.gcore.box_api.models.v1_volume_response import V1VolumeResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.VolumesApi(api_client)
    project_name = 'project_name_example' # str | Project name
    volume_name = 'volume_name_example' # str | Volume name
    v1_update_volume_request = si_tests.clients.gcore.box_api.V1UpdateVolumeRequest() # V1UpdateVolumeRequest | Volume body

    try:
        # Update volume
        api_response = api_instance.v1_update_volume(project_name, volume_name, v1_update_volume_request)
        print("The response of VolumesApi->v1_update_volume:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling VolumesApi->v1_update_volume: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **volume_name** | **str**| Volume name | 
 **v1_update_volume_request** | [**V1UpdateVolumeRequest**](V1UpdateVolumeRequest.md)| Volume body | 

### Return type

[**V1VolumeResponse**](V1VolumeResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

