Contributing to KSI
===================

Thank you for your interest in contributing to **KSI (Kordent Systems Integration)**. This guide explains how to set up your environment, contribute changes, file issues, and maintain project standards.

* * *

🚀 Getting Started
------------------

1.  [**Fork the repository**](https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/working-with-forks/fork-a-repo) on GitHub.
2.  **Clone your fork**:
    
        git clone https://github.com/<your-username>/ksi.git
        cd ksi
    
3.  **Create a Python virtual environment**:
    
        python3 -m venv venv
        source venv/bin/activate
        pip install -r si_tests/requirements.txt
    

* * *

🐞 Filing an Issue
------------------

If you find a bug, unexpected behavior, or have a feature request, please file an issue using the following process:

1.  **Search existing issues** to avoid duplicates.
2.  **Open a new issue**, using the appropriate template if available.
3.  **Include:**
    *   A clear and descriptive title
    *   Steps to reproduce (if applicable)
    *   Logs, error messages, or outputs
    *   Relevant test suite or component (`kcm`, `ksm`, etc.)
    *   Your environment (OS, Python version, etc.)

### 🧾 Issue Triage Process

Once filed, your issue will go through triage:

*   **Acknowledgement**: A maintainer will label the issue and may request clarification.
*   **Classification**: The issue will be categorized (e.g., bug, enhancement, question).
*   **Assignment**: If actionable, it will be assigned to a contributor or added to a milestone.

* * *

🧪 Testing
----------

*   Tests must pass via **GitHub Actions** before merging.
    * You may run local minimal test-coverage before pushing code via `tox -v` command.
    See [action](.github/workflows/tox.yaml) for examples.
*   Each pytest should have a re-usable smoke test workflow that tests the pytest with reasonable defaults.
*   Add smoke test to `smoke-tests.yaml`
*   Bundle pytests with [GH Actions](https://docs.github.com/en/actions/sharing-automations/creating-actions) where appropriate and create unit test workflow for the GH Action.
*   If unit test created for action add unit test to `action-unit-tests.yaml`

* * *

📁 Repo Standards
-----------------

*   Use coding style best practices for all code including:
    *    [**Python**](https://peps.python.org/pep-0008/)
    *    [**Terraform**](https://developer.hashicorp.com/terraform/language/style)
    *    [**yaml**](https://yaml.org/spec/1.2.2/)
         *    Yaml should use 2 spaces for indentation
*   Use Linters where possible.
*   Update the `README.md` next to any new artifacts or test cases. Documentation should follow the [Kubernetes Style Guide](https://kubernetes.io/docs/contribute/style/style-guide/)
*   Follow naming conventions and structure established in the repo. Consult Maintainers if adjustment or addition to structure is necessary.
*   Follow rules for ``si_tests/settings.py`` module:
    * All variables **SHOULD** start with `KSI_` prefix.
    * All `secret` variables **SHOULD** start with `KSI_SECRET_` and must be `none` by default.
* * *

📥 Contribution Flow
--------------------

1.  **Fork → branch → PR**
2.  Ensure your PR includes:
    *   ✅ Passing CI checks
    *   📝 Relevant documentation updates
    *   🧪 New/updated tests as needed
3.  Submit the PR and request review.
4.  **Code Owners** will review and approve.

* * *

✅ Guidelines
------------

*   Keep commits atomic with meaningful messages. Follow [Conventional Commits Guidelines](https://www.conventionalcommits.org/en/v1.0.0/)
*   Write clean, readable, and purposeful test code.
*   Submit logically sized PRs—avoid bundling unrelated changes.

* * *

🙏 Thank You
------------