import pytest
from os import environ as os_env
from si_tests.deployments.perf_analyzer import base as perf_analyzer
from si_tests import settings

perf_analyzer_dns_wait_timeout = settings.PERF_ANALYZER_DNS_WAIT_TIMEOUT
perf_analyzer_etcd_wait_timeout = settings.PERF_ANALYZER_ETCD_WAIT_TIMEOUT
perf_analyzer_rabbitmq_wait_timeout = settings.PERF_ANALYZER_RABBITMQ_WAIT_TIMEOUT
perf_analyzer_mariadb_wait_timeout = settings.PERF_ANALYZER_MARIADB_WAIT_TIMEOUT


def _test_performance(perf, wait_timeout):
    perf.prepare()
    perf.install()
    perf.wait_completed(timeout=wait_timeout)
    perf.collect()
    perf.check_status()
    perf.cleanup()
    perf.remove()


@pytest.mark.parametrize("_", ["PERF_CONFIG_NAME={0}"
                         .format(os_env.get("PERF_CONFIG_NAME", ""))])
# @pytest.mark.usefixtures('mos_workload_downtime_report')
# @pytest.mark.usefixtures('mos_loadtest_os_refapp')  # Should be used if ALLOW_WORKLOAD == True
# @pytest.mark.usefixtures('mos_per_node_workload_check_after_test')
def test_performance_dnsperf(_):
    """ Run dnsperf performance tests on the environment.

       Parameters required for test execution:
         - KUBECONFIG
         - PERF_ANALYZER_SCENARIO_FILE
         - PERF_ANALYZER_DIR
    """

    perf = perf_analyzer.Dnsperf(settings.PERF_ANALYZER_SCENARIO_FILE)
    _test_performance(perf, wait_timeout=perf_analyzer_dns_wait_timeout)


@pytest.mark.parametrize("_", ["PERF_CONFIG_NAME={0}"
                         .format(os_env.get("PERF_CONFIG_NAME", ""))])
# @pytest.mark.usefixtures('mos_workload_downtime_report')
# @pytest.mark.usefixtures('mos_loadtest_os_refapp')  # Should be used if ALLOW_WORKLOAD == True
# @pytest.mark.usefixtures('mos_per_node_workload_check_after_test')
def test_performance_rabbitmqperf(_):
    """ Run rabbitmq performance tests on the environment.

       Parameters required for test execution:
         - KUBECONFIG
         - PERF_ANALYZER_SCENARIO_FILE
         - PERF_ANALYZER_DIR
    """

    perf = perf_analyzer.Rabbitmqperf(settings.PERF_ANALYZER_SCENARIO_FILE)
    _test_performance(perf, wait_timeout=perf_analyzer_rabbitmq_wait_timeout)


@pytest.mark.parametrize("_", ["PERF_CONFIG_NAME={0}"
                         .format(os_env.get("PERF_CONFIG_NAME", ""))])
# @pytest.mark.usefixtures('mos_workload_downtime_report')
# @pytest.mark.usefixtures('mos_loadtest_os_refapp')  # Should be used if ALLOW_WORKLOAD == True
# @pytest.mark.usefixtures('mos_per_node_workload_check_after_test')
def test_performance_mariadbperf(_):
    """ Run mariadb performance tests on the environment.

       Parameters required for test execution:
         - KUBECONFIG
         - PERF_ANALYZER_SCENARIO_FILE
         - PERF_ANALYZER_DIR
    """

    perf = perf_analyzer.Mariadbperf(settings.PERF_ANALYZER_SCENARIO_FILE)
    _test_performance(perf, wait_timeout=perf_analyzer_mariadb_wait_timeout)


@pytest.mark.parametrize("_", ["PERF_CONFIG_NAME={0}"
                         .format(os_env.get("PERF_CONFIG_NAME", ""))])
# @pytest.mark.usefixtures('mos_workload_downtime_report')
# @pytest.mark.usefixtures('mos_loadtest_os_refapp')  # Should be used if ALLOW_WORKLOAD == True
# @pytest.mark.usefixtures('mos_per_node_workload_check_after_test')
def test_performance_etcdperf(_):
    """ Run etcd performance tests on the environment.

       Parameters required for test execution:
         - KUBECONFIG
         - PERF_ANALYZER_SCENARIO_FILE
         - PERF_ANALYZER_DIR
    """

    perf = perf_analyzer.Etcdperf(settings.PERF_ANALYZER_SCENARIO_FILE)
    _test_performance(perf, wait_timeout=perf_analyzer_etcd_wait_timeout)
