import pytest

from si_tests import logger
from si_tests import settings

LOG = logger.logger


@pytest.mark.usefixtures("introspect_distribution_not_changed")
@pytest.mark.usefixtures("collect_downtime_statistics")     # Should be used if ALLOW_WORKLOAD == True
def test_downscale_child_cluster_slave_nodes(kaas_manager):

    cluster_name = settings.TARGET_CLUSTER
    namespace_name = settings.TARGET_NAMESPACE

    child_ns = kaas_manager.get_namespace(namespace_name)
    LOG.info("Namespace name - %s", namespace_name)

    child_cluster = child_ns.get_cluster(cluster_name)
    LOG.info("Cluster name - %s", cluster_name)

    child_workers = child_cluster.get_machines(machine_type='worker')
    LOG.info("Cluster workers - %s", [w.name for w in child_workers])

    assert len(child_workers) >= 3, \
        "Before remove child worker, we mush have at least 3 nodes"
    one_worker = child_workers[0]
    one_worker_name = one_worker.name
    one_worker_k8s_name = one_worker.get_k8s_node_name()

    one_worker.delete()
    child_cluster.wait_machine_deletion(one_worker.name)
    child_cluster.check.check_deleted_node(one_worker_k8s_name)

    child_cluster.check.check_actual_expected_pods(timeout=3200)
    child_cluster.check.check_k8s_pods()

    child_cluster.check.check_cluster_readiness()

    left_child_workers = child_cluster.get_machines(machine_type='worker')
    assert one_worker_name not in (n.name for n in left_child_workers), \
        "Worker's {} still in cluster {}".format(
            one_worker_name, cluster_name)
