import pytest
from si_tests import logger
from si_tests import settings
from si_tests.utils import utils
LOG = logger.logger


@pytest.mark.usefixtures("introspect_child_target_objects")
@pytest.mark.usefixtures('create_hoc_before_lcm_and_delete_after')
def test_machine_enable(kaas_manager, show_step):
    """ Enable disabled Machine of the cluster
        Scenario:
            1. Check cluster state
            2. Check if a Machine is disabled
            3. Enable the Machine. Wait for Machine becomes ready
            4. Check cluster init state
            5. Check components versions
        """
    cluster_name = settings.TARGET_CLUSTER
    namespace_name = settings.TARGET_NAMESPACE
    ns = kaas_manager.get_namespace(namespace_name)
    cluster = ns.get_cluster(cluster_name)
    if not cluster.is_child:
        pytest.skip(f"Cluster {cluster.name} is not a child cluster")
    if cluster.provider is not utils.Provider.baremetal:
        pytest.skip(f"Cluster {cluster.name} provider is not a baremetal")

    # Get machine for disable
    machine_to_disable = cluster.day2operations.get_machine_to_disable()

    show_step(1)
    LOG.banner("Check cluster Machines readiness")
    cluster.check.check_machines_status()
    LOG.banner("Check Cluster conditions readiness")
    cluster.day2operations.check_cluster_readiness(exp_provider_status=False,
                                                   timeout=settings.CHECK_CLUSTER_READINESS_TIMEOUT + 1800)
    LOG.banner("Check cluster Nodes readiness")
    cluster.check.check_k8s_nodes()

    show_step(2)
    cluster.day2operations.check_machine_disabled(machine_to_disable)

    show_step(3)
    cluster.day2operations.fix_broken_lcm_for_day2_operations(machines=[machine_to_disable])
    cluster.day2operations.enable_machine(machine_to_disable)

    show_step(4)
    cluster.check.check_machines_status()
    cluster.check.check_cluster_readiness()
    cluster.check.check_k8s_nodes()
    cluster.check.check_cluster_nodes()
    cluster.check.check_k8s_pods()

    show_step(5)
    lcmcluster = cluster.get_lcm_cluster(name=cluster.name, namespace=cluster.namespace)
    cluster_ucp_version = lcmcluster.data.get('status', {}).get('components', {}).get('ucpVersion', '')
    cluster_release = lcmcluster.data.get('status', {}).get('release', '')
    cluster_mcr_version = lcmcluster.data.get('status', {}).get('mcrVersion', '')

    lcmmachine = machine_to_disable.lcmmachine
    lcmmachine_release = lcmmachine.data.get('status', {}).get('release', '')
    assert lcmmachine_release == cluster_release, \
        f"Machine {lcmmachine.namespace}/{lcmmachine.name} has release {lcmmachine_release}, " \
        f"expected: {cluster_release}"
    lcmmachine_ucp_version = lcmmachine.data.get('status', {}).get('components', {}).get('ucpVersion', '')
    assert lcmmachine_ucp_version == cluster_ucp_version, \
        f"Machine {lcmmachine.namespace}/{lcmmachine.name} has ucpVersion {lcmmachine_ucp_version}, " \
        f"expected: {cluster_ucp_version}"
    lcmmachine_mcr_version = lcmmachine.data.get('status', {}).get('mcrVersion', '')
    assert lcmmachine_mcr_version == cluster_mcr_version, \
        f"Machine {lcmmachine.namespace}/{lcmmachine.name} has mcrVersion {lcmmachine_mcr_version}, " \
        f"expected: {cluster_mcr_version}"
