import os.path
import yaml

from si_tests import logger
from si_tests import settings
from si_tests.managers import bootstrap_manager


LOG = logger.logger


def test_clean_kaas_on_openstack(openstack_client, kaas_manager, show_step):
    """Clean up environment.

    Scenario:
        1. Collect all deployed clusters
        2. Remove all child clusters
        3. Save artifacts
        4. Erase previous KaaS environment and seed node
    """
    show_step(1)
    all_ns = kaas_manager.get_namespaces()
    LOG.info('Detected %s namespace(s) - %s',
             len(all_ns), [n.name for n in all_ns])

    clusters = []
    for ns in all_ns:
        for child in ns.get_clusters():
            clusters.append(child)
    LOG.info("Collected clusters - {}".format([c.name for c in clusters]))

    show_step(2)
    clusters_meta = []
    for one in list(clusters):
        LOG.info("Deleting child cluster - %s", one.name)
        # collecting metadata as artifact
        clusters_meta.append(
            {
                "name": one.name,
                "uid": one.uid,
                "namespace": one.namespace
            }
        )
        one.delete()
        LOG.info("Waiting for cluster deletion")
        one.check.check_cluster_deleted(timeout=settings.KAAS_CHILD_CLUSTER_DELETE_TIMEOUT)

    show_step(3)
    fname = os.path.join(settings.ARTIFACTS_DIR, 'deleted_clusters.yaml')
    with open(fname, 'w') as f:
        f.write(yaml.dump(clusters_meta))

    show_step(4)
    seed_ip = openstack_client.get_seed_ip()
    bootstrap = bootstrap_manager.BootstrapManager(seed_ip=seed_ip)
    bootstrap.step_001_erase_env_before()
    LOG.info(f"Remove heat stack {settings.ENV_NAME}")
    openstack_client.delete_stack()
