from si_tests.deployments.utils import file_utils
from si_tests import settings


def get_run_command(report_name):
    test_scheme_path = settings.OPENSTACK_TEST_SCHEME_PATH
    test_scheme = file_utils.get_yaml_content(
        test_scheme_path, file_not_found_fail=False)

    if not test_scheme:
        return None

    cmd = ['cat', '/etc/tempest/tempest.conf;',
           'tempest', 'run', '--config-file', '/etc/tempest/tempest.conf']
    keys = ["concurrency", "blacklist-file", "regex"]

    for key in keys:
        if test_scheme.get(key):
            cmd.extend(["--{}".format(key), str(test_scheme[key])])

    if not test_scheme.get("regex") and test_scheme.get("smoke", True):
        cmd.append("--smoke")
    # Add saving of test results to pvc in command
    # If there are FAILED cases, temepest-test returns non-zero code.
    # pod CrashLoopBackOff -> run tempest tests again and again
    # without saving results.
    # Currently, no relevant what returns `tempest run`, because of for
    # processing results of execution tempest tests
    # we're use procResultsJob and report of tempest tests.
    cmd.append(
        "|| true; stestr last --subunit > /var/lib/tempest/data/{}".format(
            report_name))

    return " ".join(cmd)
