# Offline (airgap) testing with OpenStack

## Registry, bundle and k0s binary server using openstack heat backend

To provide that ability - the HOT template was prepared.

### Structure

| Name     |                            Template reference                             | Env cofig                                                          | Cloud-init                                                                                 | 
|----------|:-------------------------------------------------------------------------:|--------------------------------------------------------------------|--------------------------------------------------------------------------------------------|
| registry | [registry-bundle.hot](../si_tests/test_env_data/heat/registry-bundle.hot) | [registry.yaml](../si_tests/test_env_data/heat/envs/registry.yaml) | [registry-userdata.yaml](../si_tests/test_env_data/heat/cloud-init/registry-userdata.yaml) |

### Pre-requisites

- Working OpenStack environment (imc-eu or imc-us in internal Mirantis case)
- Clouds.yaml [file](https://docs.openstack.org/python-openstackclient/pike/configuration/index.html) with the OpenStack cloud configured (It's possile to download in from OpenStack dashboard in the identity section)
- OpenStack CLI installed and [configured](https://docs.openstack.org/python-openstackclient/latest/cli/man/openstack.html): [python-openstackclient](https://pypi.org/project/python-openstackclient/)

### Configuring the registry

#### Parameters

| Parameter         | Description                                                                                                                                          | Default value                          |
|-------------------|------------------------------------------------------------------------------------------------------------------------------------------------------|----------------------------------------|
| key_pair          | SSH key pair name to access the registry VM                                                                                                          | `none`                                 |
| flavor            | Flavor to use for the registry VM                                                                                                                    | `m1.small`                             |
| image             | Image to use for the registry VM                                                                                                                     | `jammy-server-cloudimg-amd64-20240417` |
| public_net_id     | Public network ID to use for the registry VM                                                                                                         | `public`                               |
| availability_zone | Availability zone to use for the registry VM                                                                                                         | `nova`                                 |
| nameservers       | Nameservers to use for the VM                                                                                                                        | `172.18.176.6`                         | 
| instance_os_name  | Name pattern for the VM                                                                                                                              | `registry`                             | 
| bundle_version    | Airgap bundle version to use                                                                                                                         | `1.1.0`                                |
| k0s_bin           | k0s binary version to serve [expected](https://docs.k0rdent-enterprise.io/latest/admin/installation/airgap/airgap-install/#installation) k0s version | `k0s-v1.32.6+k0s.0-amd64`              |

#### What to change?

* instance_os_name - this parameter MUST be changed to avoid the mess in the tenant
* key_pair - Create the keypair in your tetant and use the name of the keypair
* image - default image is good, but in case if it will not be available - consider using another image
* bundle_version - Depennds on which k0rdent enterprise version you're want to use
* k0s_bin - Depends on product requirements

### Deploying the registry

After all steps - it's quite simple to start the deployment:

```bash
openstack stack create -t si_tests/test_env_data/heat/registry-bundle.hot -e si_tests/test_env_data/heat/envs/registry.yaml <your-username-with-registry-name>
```

### Outputs

* The IP address of the vm can be found in the OpenStack dashboard in the Compute -> Instances section.
* Registry URL will be `https://<vm-ip>:5000/`
* k0s binary URL will be `http://<vm-ip>:8080/<k0s_bin>`
* CA for the registry will be available at `https://<vm-ip>:8080/domain.crt`

### Verifying the registry

To verify that the registry is working correctly, you can use the following command:


```bash
curl -k https://<vm-ip>:5000/v2/_catalog
```

You might want to use jq to format the output:

```bash
curl -k https://<vm-ip>:5000/v2/_catalog | jq
```

Or test the certificate conversation:

```bash
wget http://<vm-ip>:8080/domain.crt
curl https://<vm-ip>:5000/v2/_catalog --cacert domain.crt | jq
```

## KSI configuration to use the Airgapped setup

### Adding the CA to the trust store of the initial cluster

The k0s initial one-node cluster will be used in this particular example since its using system CA store by default and does not require any additional configuration.
If you does not have such - bootstrap a simple VM in the Openstack (with floating IP for access) and install [k0s](https://k0sproject.io) on it.

---
**NOTE**

In case if you're going to run ksi outside of that VM - do not forget to add your floating IP of the VM into the sans of the certificates in k0s conf.
Save the config:
```bash
k0s config create > k0s.yaml
```

Then edit the `k0s.yaml` file and add your floating IP to the `sans` section under `api`:

```yaml
apiVersion: k0s.k0sproject.io/v1beta1
kind: ClusterConfig
metadata:
  name: k0s
  namespace: kube-system
spec:
  api:
    address: 10.10.10.10
    ca:
      certificatesExpireAfter: 8760h0m0s
      expiresAfter: 87600h0m0s
    k0sApiPort: 9443
    port: 6443
    sans:
      - <your_floating_ip>
      - 10.10.10.10
      - 172.48.10.1
      - 172.17.0.1
      - 10.244.0.1
      - fe80::f816:3eff:fe23:6408
      - fc00:f853:ccd:e793::1
      - fe80::42:4fff:fe67:c6b4
      - fe80::413:c3ff:fe62:39ca
      - fe80::c7d:6bff:fec2:514e
      - fe80::c051:cdff:fea6:a919
```
Now it's possible to work with your cluster using the floating IP address.

Obtain the kubeconfig
```bash
sudo k0s kubeconfig admin
```
and replace the `server` field in the kubeconfig with your floating IP address:

```yaml
apiVersion: v1
clusters:
  - cluster:
      server: https://<floating_ip>:6443
```

Now config is portable and can be used outside of the VM.

---

To add the CA to the trust store of the initial cluster, you can use the following command:

```bash
sudo wget http://<vm-ip>:8080/domain.crt -O /usr/local/share/ca-certificates/cert.crt
sudo update-ca-certificates
sudo service k0scontroller restart
```

Now your initial cluster have ability to pull the images from the registry.

### Running ksi to bootstrap k0rdent enterprise

The parameters for the ksi run will differ from usual online enterprise run

```bash
export KUBECONFIG=/path/to/your/kubeconfig
export KSI_CUSTOM_REGISTRY_CERT_PATH=path/to/the/domain.crt
export KSI_K0S_URL=http://<vm-ip>:8080
export KCM_CHART_VERSION=1.1.0
export KCM_SOURCE=custom-enterprise
export KCM_CUSTOM_REGISTRY=<vm-ip>:5000
py.test si_tests/tests/bootstrap/test_install_kcm.py
```

The initial cluster is ready and in this stage we need to create specific standalone OS cluster to use it as isolated mothership.

### Creating the standalone OS cluster
The actual documentation should be used [here](../si_tests/tests/clusterdeployments/README.md#test_create_os_clusterdeploymentpy).

But the most important parameter in our this is `KSI_OS_SECURITY_GROUP`. This parameter is controlling the security group assignement to the nodes. 
Because of this param we able to make the deployment offline (airgapped).

The specific security group name is `core-offline-sg` and it is available in the `ksi` and `kcm-dev` tenants by default.
It's needed to export it along with other parameters:

```bash
export KCM_CLUSTER_DEPLOYMENT_NAME=my-username-os-mothership-aug-19-25
export KSI_OS_SECURITY_GROUP=core-offline-sg
...
py.test si_tests/tests/clusterdeployments/test_create_os_clusterdeployment.py
```
After the provision test will be finished (it's including post-deployment checks) - the airgapped environment will be ready to install the k0rdent enterprise.

### Mothership installation

It's correct way to use the same variables as for initial cluster but the `KUBECONFIG` should point to the new cluster kubeconfig file.
The deployed cluster kubeconfig can be obtained in `si_tests/artifacts` directory. In this example it will be `my-username-os-mothership-aug-19-25-kubeconfig`.
On this stage the certificate already provisioned on nodes during the cluster creation process, so no needs to update the CA store.

```bash
export KUBECONFIG=si_tests/artifacts/my-username-os-mothership-aug-19-25-kubeconfig
export KSI_CUSTOM_REGISTRY_CERT_PATH=path/to/the/domain.crt
export KSI_K0S_URL=http://<vm-ip>:8080
export KCM_CHART_VERSION=1.1.0
export KCM_SOURCE=custom-enterprise
export KCM_CUSTOM_REGISTRY=<vm-ip>:5000
py.test si_tests/tests/bootstrap/test_install_kcm.py
```

After the test will be finished - the k0rdent enterprise will be installed on the airgapped OpenStack cluster.

Happy airgapping :)