import pytest

from si_tests import logger
from si_tests import settings
from si_tests.clients import k8s as k8s_client
from si_tests.managers import bootstrap_manager
from si_tests.managers.kcm_manager import Manager as kcmManager
from si_tests.utils import utils

LOG = logger.logger


# TODO(alexz-kh): this is draft test scenario, later will be split.

@pytest.mark.usefixtures('log_step_time')
@pytest.mark.usefixtures('log_method_time')
def test_install_seed(show_step):
    """Initiate seed node configuration

    Scenario:
        1. Init metal3-k0rdent-bm
        2. Init -bm cluster bootstrap
    """
    show_step(1)
    # self test, to not harm random env
    utils.ksi_seed_check_fuse()
    ns_name = settings.KCM_NAMESPACE
    # TODO(alexz-kh): when we will get PR tests, here might be fixes required!
    oot_capi_provider_metal3_registry = settings.KCM_REPO_DICT['oot-capi-provider-metal3-ci-registry']
    # if settings.KCM_SOURCE == 'enterprise':
    #     oot_capi_provider_metal3_registry = settings.KCM_REPO_DICT['oot-capi-provider-metal3-enterprise-registry']
    bs_data = utils.render_and_save_data(template_path=settings.KSI_BOOTSTRAP_DATA_PATH,
                                         render_opts={
                                             'target_namespace': ns_name,
                                             'oot_capi_provider_metal3_registry': oot_capi_provider_metal3_registry
                                         })
    # ksi_config = ksi_config_manager.KSIConfigManager(ksi_config_path=settings.KSI_CONFIG_PATH)
    show_step(1)
    k8s = k8s_client.K8sCluster(kubeconfig=settings.KSI_KUBECONFIG_PATH,
                                default_namespace=ns_name)
    kcm_bs_mgr = bootstrap_manager.KCMBootstrapManager(kubeconfig=settings.KSI_KUBECONFIG_PATH)
    #
    # LOG.info('creating infrastructureproviders')
    # capi_ip_names = [i.name for i in k8s.capi_infrastructureproviders.list()]
    # for infrastructureprovider_raw in bs_data.get('infrastructureproviders_raw', []):
    #     if infrastructureprovider_raw['metadata']['name'] not in capi_ip_names:
    #         k8s.capi_infrastructureproviders.create(body=infrastructureprovider_raw)
    # #
    # LOG.info('creating providerinterfaces')
    # prov_iface_names = [i.name for i in k8s.k0rdent_provider_interfaces.list_all()]
    # for providerinterface_raw in bs_data.get('providerinterfaces_raw', []):
    #     if providerinterface_raw['metadata']['name'] not in prov_iface_names:
    #         k8s.k0rdent_provider_interfaces.create(body=providerinterface_raw)
    #
    # LOG.info('patching clusterrole')
    # cluster_role = k8s.clusterrole.get(name='kcm-manager-role', namespace=ns_name)
    # _body = cluster_role.data
    # metal3_rules = {
    #     "api_groups": ["infrastructure.cluster.x-k8s.io"],
    #     "resources": ["metal3clusters"],
    #     "verbs": ["get", "list", "patch", "watch"],
    # }
    # _body['rules'].append(metal3_rules)
    # cluster_role.patch(body=_body, verbose=True)
    #
    LOG.info('creating secrets')
    current_secrets = [i.name for i in k8s.secrets.list()]
    for secret_raw in bs_data.get('secrets_raw', []):
        if secret_raw['metadata']['name'] not in current_secrets:
            k8s.secrets.create(body=secret_raw)
    #
    LOG.info('creating helmrepositories.source.toolkit.fluxcd.io')
    current_helmrepos = [i.name for i in k8s.helmrepositories.list()]
    for helmrepo_raw in bs_data.get('helmrepositories_raw', []):
        if helmrepo_raw['metadata']['name'] not in current_helmrepos:
            k8s.helmrepositories.create(body=helmrepo_raw)
    #
    LOG.info('creating providertemplates.k0rdent.mirantis.com')
    current_provider_templates = [i.name for i in k8s.k0rdent_provider_templates.list_all()]
    for provider_template_raw in bs_data.get('providertemplates_raw', []):
        if provider_template_raw['metadata']['name'] not in current_provider_templates:
            k8s.k0rdent_provider_templates.create(body=provider_template_raw)
    #
    # LOG.info('patching releases.k0rdent.mirantis.com')
    # # as for now, we expect only one release, which provided by settings
    # # during kcm_m.install_kcm()
    # kcm_version_in_crd_format = kcm_bs_mgr.get_kcm_chart_version().replace('.', '-')
    # kcm_release = k8s.k0rdent_releases.get(name=kcm_version_in_crd_format)
    # kcm_release_body = kcm_release.data
    # for release_raw in bs_data.get('releases_raw', []):
    #     if not utils.is_list_has_overlap(kcm_release_body['spec']['providers'],
    #                                      release_raw['spec']['providers']):
    #         kcm_release_body['spec']['providers'].extend(release_raw['spec']['providers'])
    #         kcm_release.patch(kcm_release_body)
    #
    LOG.info('patching managements.k0rdent.mirantis.com')
    kcm_mgmt = k8s.k0rdent_managements.get(name=settings.KCM_MANAGEMENT_NAME)
    kcm_mgmt_body = kcm_mgmt.data
    for management_raw in bs_data.get('managements_raw', []):
        if not utils.is_list_has_overlap(kcm_mgmt_body['spec']['providers'],
                                         management_raw['spec']['providers']):
            kcm_mgmt_body['spec']['providers'].extend(management_raw['spec']['providers'])
            kcm_mgmt.patch(kcm_mgmt_body)
    kcm_bs_mgr.check.wait_for_helmrelease_readiness(chart_name='cluster-api-provider-metal3',
                                                    chart_namespace=ns_name)
    kcm_bs_mgr.check.wait_for_mgmt_object_readiness()
    #
    show_step(2)
    LOG.info('creating baremetalhosts.metal3.io')
    current_bmhs = [i.name for i in k8s.metal3_baremetalhosts.list()]
    new_bmh_names = []
    for baremetalhost_raw in bs_data.get('baremetalhosts_raw', []):
        _name = baremetalhost_raw['metadata']['name']
        if _name not in current_bmhs:
            k8s.metal3_baremetalhosts.create(body=baremetalhost_raw)
            new_bmh_names.append(_name)

    kcm_mgr = kcmManager(settings.KSI_KUBECONFIG_PATH)
    ns = kcm_mgr.get_namespace(ns_name)

    if new_bmh_names:
        ns.wait_baremetalhosts_statuses(bmh_names=new_bmh_names, wait_status='available',
                                        retries=60, interval=30)
    #
    LOG.info('creating credentials.k0rdent.mirantis.com')
    current_creds = [i.name for i in k8s.k0rdent_credentials.list()]
    for cred_raw in bs_data.get('credentials_raw', []):
        if cred_raw['metadata']['name'] not in current_creds:
            k8s.k0rdent_credentials.create(body=cred_raw)
    #
    current_cl_templates = [i.name for i in k8s.k0rdent_cluster_templates.list()]
    for cl_template in bs_data.get('clustertemplates_raw', []):
        _name = cl_template['metadata']['name']
        if _name not in current_cl_templates:
            _ = ns.create_cluster_template(body=cl_template)
            ns.wait_cluster_template(_)
    #
    LOG.info('creating clusterdeployments')
    # WARNING(alexz-kh): regardless we might support multiply deployments, current test as for now
    # supports only one
    current_cl_deployments = [i.name for i in k8s.k0rdent_cluster_templates.list()]
    cl_depl_template = bs_data.get('clusterdeployments_raw', [])[0]
    _name = cl_depl_template['metadata']['name']
    if _name not in current_cl_deployments:
        cl_deployment = ns.create_cluster_deployment_raw(body=cl_depl_template)
        cl_deployment.check.check_cluster_readiness()

    LOG.info('done')
