# si_tests.clients.gcore.box_api.RegistryUsersApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1_create_registry_user**](RegistryUsersApi.md#v1_create_registry_user) | **POST** /v1/{project_name}/registries/{registry_name}/users | Create registry user
[**v1_delete_registry_user**](RegistryUsersApi.md#v1_delete_registry_user) | **DELETE** /v1/{project_name}/registries/{registry_name}/users/{username} | Delete registry user
[**v1_get_registry_user**](RegistryUsersApi.md#v1_get_registry_user) | **GET** /v1/{project_name}/registries/{registry_name}/users/{username} | Get registry user
[**v1_get_registry_user_pull_secret**](RegistryUsersApi.md#v1_get_registry_user_pull_secret) | **GET** /v1/{project_name}/registries/{registry_name}/users/{username}/pullsecret | Get registry user pull secret
[**v1_list_registry_users**](RegistryUsersApi.md#v1_list_registry_users) | **GET** /v1/{project_name}/registries/{registry_name}/users | List registry users
[**v1_update_registry_user**](RegistryUsersApi.md#v1_update_registry_user) | **PUT** /v1/{project_name}/registries/{registry_name}/users/{username} | Update registry user


# **v1_create_registry_user**
> V1RegistryUserResponse v1_create_registry_user(project_name, registry_name, v1_create_registry_user_request)

Create registry user

Creates a new user with access to the specified container registry.

This endpoint allows you to create a user with either read-only or read-write
access to the registry. A pull secret is automatically generated for the user,
which can be used to authenticate with the registry. Read-only users can only pull
images, while read-write users can both pull and push images. This is useful for
granting limited access to CI/CD systems or external services.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_create_registry_user_request import V1CreateRegistryUserRequest
from si_tests.clients.gcore.box_api.models.v1_registry_user_response import V1RegistryUserResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.RegistryUsersApi(api_client)
    project_name = 'project_name_example' # str | Project name
    registry_name = 'registry_name_example' # str | Registry name
    v1_create_registry_user_request = si_tests.clients.gcore.box_api.V1CreateRegistryUserRequest() # V1CreateRegistryUserRequest | Registry user configuration

    try:
        # Create registry user
        api_response = api_instance.v1_create_registry_user(project_name, registry_name, v1_create_registry_user_request)
        print("The response of RegistryUsersApi->v1_create_registry_user:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling RegistryUsersApi->v1_create_registry_user: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **registry_name** | **str**| Registry name | 
 **v1_create_registry_user_request** | [**V1CreateRegistryUserRequest**](V1CreateRegistryUserRequest.md)| Registry user configuration | 

### Return type

[**V1RegistryUserResponse**](V1RegistryUserResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_delete_registry_user**
> v1_delete_registry_user(project_name, registry_name, username)

Delete registry user

Deletes a user from the specified container registry.

This operation permanently removes the user's access to the registry and
deletes their associated pull secret. This action cannot be undone. After deletion,
any systems or services using this user's credentials will no longer be able to
authenticate with the registry. Make sure to update any configurations that were
using the deleted user's pull secret.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.RegistryUsersApi(api_client)
    project_name = 'project_name_example' # str | Project name
    registry_name = 'registry_name_example' # str | Registry name
    username = 'username_example' # str | Registry username

    try:
        # Delete registry user
        api_instance.v1_delete_registry_user(project_name, registry_name, username)
    except Exception as e:
        print("Exception when calling RegistryUsersApi->v1_delete_registry_user: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **registry_name** | **str**| Registry name | 
 **username** | **str**| Registry username | 

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_get_registry_user**
> V1RegistryUserResponse v1_get_registry_user(project_name, registry_name, username)

Get registry user

Returns detailed information about a specific user of the container registry.

This endpoint provides information about a registry user, including their
access permissions (read-only or read-write) and associated pull secret name.
Registry users can be used to grant limited access to your registry for CI/CD systems
or other services that need to pull or push images.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_registry_user_response import V1RegistryUserResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.RegistryUsersApi(api_client)
    project_name = 'project_name_example' # str | Project name
    registry_name = 'registry_name_example' # str | Registry name
    username = 'username_example' # str | Registry username

    try:
        # Get registry user
        api_response = api_instance.v1_get_registry_user(project_name, registry_name, username)
        print("The response of RegistryUsersApi->v1_get_registry_user:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling RegistryUsersApi->v1_get_registry_user: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **registry_name** | **str**| Registry name | 
 **username** | **str**| Registry username | 

### Return type

[**V1RegistryUserResponse**](V1RegistryUserResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_get_registry_user_pull_secret**
> V1PullSecretResponse v1_get_registry_user_pull_secret(project_name, registry_name, username)

Get registry user pull secret

Returns the pull secret for a specific user of the container registry.

This endpoint provides the pull secret that can be used to authenticate
with the registry when pulling or pushing images. The pull secret can be used in
Kubernetes deployments, Docker configurations, or CI/CD pipelines to authenticate
with the registry. For read-only users, the secret can only be used to pull images,
while read-write users can both pull and push.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_pull_secret_response import V1PullSecretResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.RegistryUsersApi(api_client)
    project_name = 'project_name_example' # str | Project name
    registry_name = 'registry_name_example' # str | Registry name
    username = 'username_example' # str | Registry username

    try:
        # Get registry user pull secret
        api_response = api_instance.v1_get_registry_user_pull_secret(project_name, registry_name, username)
        print("The response of RegistryUsersApi->v1_get_registry_user_pull_secret:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling RegistryUsersApi->v1_get_registry_user_pull_secret: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **registry_name** | **str**| Registry name | 
 **username** | **str**| Registry username | 

### Return type

[**V1PullSecretResponse**](V1PullSecretResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_list_registry_users**
> V1ListRegistryUserResponse v1_list_registry_users(project_name, registry_name)

List registry users

Returns a list of all users that have access to the specified container registry.

This endpoint provides information about all users who can access the registry,
including their access permissions (read-only or read-write) and associated pull secrets.
You can use this to manage access control to your registry and review which users or
services have been granted access. Each user has their own credentials and access level.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_list_registry_user_response import V1ListRegistryUserResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.RegistryUsersApi(api_client)
    project_name = 'project_name_example' # str | Project name
    registry_name = 'registry_name_example' # str | Registry name

    try:
        # List registry users
        api_response = api_instance.v1_list_registry_users(project_name, registry_name)
        print("The response of RegistryUsersApi->v1_list_registry_users:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling RegistryUsersApi->v1_list_registry_users: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **registry_name** | **str**| Registry name | 

### Return type

[**V1ListRegistryUserResponse**](V1ListRegistryUserResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_update_registry_user**
> V1RegistryUserResponse v1_update_registry_user(project_name, registry_name, username, v1_update_registry_user_request)

Update registry user

Updates an existing user's access permissions for the specified container registry.

This endpoint allows you to modify a user's access permissions, such as
changing from read-only to read-write access or vice versa. This is useful when
you need to change the level of access for CI/CD systems or external services
without having to create a new user and update all configurations that use the
existing pull secret.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_registry_user_response import V1RegistryUserResponse
from si_tests.clients.gcore.box_api.models.v1_update_registry_user_request import V1UpdateRegistryUserRequest
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.RegistryUsersApi(api_client)
    project_name = 'project_name_example' # str | Project name
    registry_name = 'registry_name_example' # str | Registry name
    username = 'username_example' # str | Registry username
    v1_update_registry_user_request = si_tests.clients.gcore.box_api.V1UpdateRegistryUserRequest() # V1UpdateRegistryUserRequest | Updated registry user configuration

    try:
        # Update registry user
        api_response = api_instance.v1_update_registry_user(project_name, registry_name, username, v1_update_registry_user_request)
        print("The response of RegistryUsersApi->v1_update_registry_user:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling RegistryUsersApi->v1_update_registry_user: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **registry_name** | **str**| Registry name | 
 **username** | **str**| Registry username | 
 **v1_update_registry_user_request** | [**V1UpdateRegistryUserRequest**](V1UpdateRegistryUserRequest.md)| Updated registry user configuration | 

### Return type

[**V1RegistryUserResponse**](V1RegistryUserResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

