# si_tests.clients.gcore.box_api.JupyterLabApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_jupyter_lab_instance**](JupyterLabApi.md#create_jupyter_lab_instance) | **POST** /v1/{project_name}/jupyterlabs | Create JupyterLab instance
[**delete_jupyter_lab_instance**](JupyterLabApi.md#delete_jupyter_lab_instance) | **DELETE** /v1/{project_name}/jupyterlabs/{instance_name} | Delete JupyterLab instance
[**get_jupyter_lab_instance**](JupyterLabApi.md#get_jupyter_lab_instance) | **GET** /v1/{project_name}/jupyterlabs/{instance_name} | Get JupyterLab instance
[**list_jupyter_lab_instances**](JupyterLabApi.md#list_jupyter_lab_instances) | **GET** /v1/{project_name}/jupyterlabs | List JupyterLab instances
[**update_jupyter_lab_instance**](JupyterLabApi.md#update_jupyter_lab_instance) | **PATCH** /v1/{project_name}/jupyterlabs/{instance_name} | Update JupyterLab instance


# **create_jupyter_lab_instance**
> V1CreateInstanceResponse create_jupyter_lab_instance(project_name, v1_create_instance_request)

Create JupyterLab instance

This endpoint creates a new JupyterLab instance in the specified project.

JupyterLab instances provide interactive environments for data science and development.

The request should include:
- Desired configuration (flavor, region, volume)
- Instance name

The response contains:
- Details of the created instance (name, configuration, status)

If an instance with the given name already exists in the project and region, a conflict error is returned.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_create_instance_request import V1CreateInstanceRequest
from si_tests.clients.gcore.box_api.models.v1_create_instance_response import V1CreateInstanceResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.JupyterLabApi(api_client)
    project_name = 'project_name_example' # str | Project name
    v1_create_instance_request = si_tests.clients.gcore.box_api.V1CreateInstanceRequest() # V1CreateInstanceRequest | JupyterLab instance specs

    try:
        # Create JupyterLab instance
        api_response = api_instance.create_jupyter_lab_instance(project_name, v1_create_instance_request)
        print("The response of JupyterLabApi->create_jupyter_lab_instance:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling JupyterLabApi->create_jupyter_lab_instance: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **v1_create_instance_request** | [**V1CreateInstanceRequest**](V1CreateInstanceRequest.md)| JupyterLab instance specs | 

### Return type

[**V1CreateInstanceResponse**](V1CreateInstanceResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Created |  -  |
**400** | Bad Request |  -  |
**409** | Conflict |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_jupyter_lab_instance**
> delete_jupyter_lab_instance(project_name, instance_name)

Delete JupyterLab instance

This endpoint deletes a specific JupyterLab instance from the project.

JupyterLab instances are interactive environments for data science and development.

Upon successful deletion, the instance is permanently removed and cannot be recovered.

If the instance does not exist, a not found error is returned.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.JupyterLabApi(api_client)
    project_name = 'project_name_example' # str | Project name
    instance_name = 'instance_name_example' # str | Instance name

    try:
        # Delete JupyterLab instance
        api_instance.delete_jupyter_lab_instance(project_name, instance_name)
    except Exception as e:
        print("Exception when calling JupyterLabApi->delete_jupyter_lab_instance: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **instance_name** | **str**| Instance name | 

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |
**400** | Bad Request |  -  |
**404** | Not Found |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_jupyter_lab_instance**
> V1GetInstanceResponse get_jupyter_lab_instance(project_name, instance_name)

Get JupyterLab instance

This endpoint retrieves detailed information about a specific JupyterLab instance in the project.

JupyterLab instances are interactive environments for data science and development.

The response includes:
- Configuration details (flavor, region and volume)
- Status information (endpoint, token and state)

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_get_instance_response import V1GetInstanceResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.JupyterLabApi(api_client)
    project_name = 'project_name_example' # str | Project name
    instance_name = 'instance_name_example' # str | Instance name

    try:
        # Get JupyterLab instance
        api_response = api_instance.get_jupyter_lab_instance(project_name, instance_name)
        print("The response of JupyterLabApi->get_jupyter_lab_instance:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling JupyterLabApi->get_jupyter_lab_instance: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **instance_name** | **str**| Instance name | 

### Return type

[**V1GetInstanceResponse**](V1GetInstanceResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**400** | Bad Request |  -  |
**404** | Not Found |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_jupyter_lab_instances**
> V1ListInstanceResponse list_jupyter_lab_instances(project_name)

List JupyterLab instances

This endpoint lists all JupyterLab instances within a specific project.

JupyterLab instances are interactive environments for data science and development.

The response includes:
- A collection of instances with summary details (name, region, flavor, and status)

Use this endpoint to discover available instances and their states in your project.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_list_instance_response import V1ListInstanceResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.JupyterLabApi(api_client)
    project_name = 'project_name_example' # str | Project name

    try:
        # List JupyterLab instances
        api_response = api_instance.list_jupyter_lab_instances(project_name)
        print("The response of JupyterLabApi->list_jupyter_lab_instances:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling JupyterLabApi->list_jupyter_lab_instances: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 

### Return type

[**V1ListInstanceResponse**](V1ListInstanceResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**400** | Bad Request |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_jupyter_lab_instance**
> V1UpdateInstanceResponse update_jupyter_lab_instance(project_name, instance_name, v1_update_instance_request)

Update JupyterLab instance

This endpoint updates the configuration of a specific JupyterLab instance in the project.

JupyterLab instances are interactive environments for data science and development.

The request should specify:
- The fields to update (such as flavor, volume, etc.)

The response contains:
- Updated instance details (configuration and status)

If the instance does not exist, a not found error is returned.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_update_instance_request import V1UpdateInstanceRequest
from si_tests.clients.gcore.box_api.models.v1_update_instance_response import V1UpdateInstanceResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.JupyterLabApi(api_client)
    project_name = 'project_name_example' # str | Project name
    instance_name = 'instance_name_example' # str | Instance name
    v1_update_instance_request = si_tests.clients.gcore.box_api.V1UpdateInstanceRequest() # V1UpdateInstanceRequest | JupyterLab instance update specs

    try:
        # Update JupyterLab instance
        api_response = api_instance.update_jupyter_lab_instance(project_name, instance_name, v1_update_instance_request)
        print("The response of JupyterLabApi->update_jupyter_lab_instance:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling JupyterLabApi->update_jupyter_lab_instance: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **instance_name** | **str**| Instance name | 
 **v1_update_instance_request** | [**V1UpdateInstanceRequest**](V1UpdateInstanceRequest.md)| JupyterLab instance update specs | 

### Return type

[**V1UpdateInstanceResponse**](V1UpdateInstanceResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**400** | Bad Request |  -  |
**404** | Not Found |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

