import pytest

from si_tests import logger
from si_tests import settings
from si_tests.utils import waiters


LOG = logger.logger


@pytest.mark.parametrize("_", ["CLUSTER_NAME={0}"
                               .format(settings.TARGET_CLUSTER)])
def test_add_taints_to_nodes(kaas_manager, _):
    taint = {"key": settings.NODE_TAINT_KEY,
             "value": settings.NODE_TAINT_VALUE,
             "effect": settings.NODE_TAINT_EFFECT}
    tg_name = settings.TARGET_CLUSTER
    tg_ns = kaas_manager.get_namespace(settings.TARGET_NAMESPACE)
    tg_cluster = tg_ns.get_cluster(tg_name)
    nodes = tg_cluster.k8sclient.nodes.list(label_selector=settings.NODE_LABEL_SELECTOR)

    LOG.info('Add taint to nodes')
    for node in nodes:
        if not node.exists_taint(taint):
            node.add_taint(taint)

    LOG.info('Wait for tains are applied')

    def taints_applied(nodes, taint):
        not_applied = []
        for node in nodes:
            if not node.exists_taint(taint):
                not_applied.append(node.name)
        if not_applied:
            LOG.info(f"Taints for nodes {not_applied} are still not applied")
        return not not_applied

    waiters.wait(lambda: taints_applied(nodes, taint))
